/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.boxes.ActiveBox;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.JOptionPane;

public abstract class AudioBuffer {
    public static final int MAX_RECORD_LENGTH = 20;
    protected int m_seconds;
    protected static Cursor recCursor;
    protected static AudioBuffer activeAudioBuffer;
    protected static Component owner;
    protected static Cursor backOwnerCursor;
    protected static Component mainOwner;
    protected static Cursor backMainOwnerCursor;

    public AudioBuffer(int seconds) throws Exception {
        if (seconds <= 0 || seconds > 20) {
            throw new Exception("Error: Audio buffer length can't exceed 20 seconds");
        }
        this.m_seconds = seconds;
    }

    public abstract void play() throws Exception;

    public abstract void stop();

    protected abstract void clear();

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    public static boolean busy() {
        return activeAudioBuffer != null;
    }

    protected static AudioBuffer getActiveAudioBuffer() {
        return activeAudioBuffer;
    }

    public void record(PlayStation ps, ActiveBox bx) throws Exception {
        AudioBuffer.forceStop();
        recCursor = ps.getCustomCursor(2);
        owner = bx == null ? null : bx.getContainerResolve();
        mainOwner = JOptionPane.getFrameForComponent(ps.getComponent());
        AudioBuffer.showRecordingCursor();
        this.record();
    }

    protected abstract void record() throws Exception;

    protected static void forceStop() throws Exception {
        if (AudioBuffer.busy()) {
            AudioBuffer.getActiveAudioBuffer().stop();
            Thread.yield();
            if (AudioBuffer.busy()) {
                throw new Exception("Unable to stop recorder!");
            }
        }
    }

    protected static void showRecordingCursor() {
        if (recCursor != null) {
            if (owner != null) {
                backOwnerCursor = owner.getCursor();
                if (backOwnerCursor == Cursor.getDefaultCursor()) {
                    backOwnerCursor = null;
                }
                owner.setCursor(recCursor);
            }
            if (mainOwner != null) {
                backMainOwnerCursor = mainOwner.getCursor();
                if (backMainOwnerCursor == Cursor.getDefaultCursor()) {
                    backMainOwnerCursor = null;
                }
                mainOwner.setCursor(recCursor);
            }
        }
    }

    protected static void hideRecordingCursor() {
        if (owner != null) {
            owner.setCursor(backOwnerCursor);
            owner = null;
        }
        if (mainOwner != null) {
            mainOwner.setCursor(backMainOwnerCursor);
            mainOwner = null;
        }
    }
}

