/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.media.JavaSoundAudioPlayer;
import edu.xtec.jclic.media.PseudoClip;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;

public class ClipWrapper
implements PseudoClip {
    private Clip clip;
    private AudioInputStream ais;

    private ClipWrapper(AudioInputStream ais, Clip clip) {
        this.clip = clip;
        this.ais = ais;
    }

    public static ClipWrapper getClipWrapper(MediaBag mb, String mediaFileName) throws Exception {
        Object result = null;
        JavaSoundAudioPlayer jsap = new JavaSoundAudioPlayer();
        jsap.setDataSource(mb.getMediaDataSource(mediaFileName));
        AudioInputStream ais = jsap.ais;
        Clip clip = jsap.getClip();
        return ais == null || clip == null ? null : new ClipWrapper(ais, clip);
    }

    @Override
    public void close() {
        this.clip.close();
    }

    @Override
    public AudioFormat getFormat() {
        return this.clip.getFormat();
    }

    @Override
    public boolean isActive() {
        return this.clip.isActive();
    }

    @Override
    public boolean isOpen() {
        return this.clip.isOpen();
    }

    @Override
    public boolean isRunning() {
        return this.clip.isRunning();
    }

    @Override
    public void loop(int count) throws Exception {
        this.clip.loop(count);
    }

    @Override
    public void open() throws Exception {
        this.clip.open(this.ais);
    }

    @Override
    public void setFramePosition(int frames) {
        this.clip.setFramePosition(frames);
    }

    @Override
    public void setLoopPoints(int start, int end) {
        this.clip.setLoopPoints(start, end);
    }

    @Override
    public void start() throws Exception {
        this.clip.start();
    }

    @Override
    public void stop() {
        this.clip.stop();
    }
}

