/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.media.AudioBuffer;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class JavaSoundAudioBuffer
extends AudioBuffer {
    public static final float RATE = 11025.0f;
    public static final int BITS = 16;
    public static final int CHANNELS = 1;
    public static final int LINE_BUFFER = 10000;
    public static final int STEP_BUFFER = 5000;
    private static TargetDataLine m_targetLine;
    private static SourceDataLine m_sourceLine;
    private static RecordThread recordThread;
    private static PlayThread playThread;
    private static Timer recordTimer;
    private static boolean initialized;
    private byte[] m_buffer;

    public JavaSoundAudioBuffer(int seconds) throws Exception {
        super(seconds);
        JavaSoundAudioBuffer.initialize();
    }

    public static void initialize() throws Exception {
        if (!initialized) {
            JavaSoundAudioBuffer.buildLines();
        }
    }

    protected static void buildLines() throws Exception {
        DataLine.Info dli;
        ArrayList<AudioFormat> vOptimal = new ArrayList<AudioFormat>();
        ArrayList<AudioFormat> vAll = new ArrayList<AudioFormat>();
        for (Line.Info info : AudioSystem.getTargetLineInfo(new Line.Info(TargetDataLine.class))) {
            if (!(info instanceof DataLine.Info)) continue;
            for (AudioFormat format : ((DataLine.Info)info).getFormats()) {
                if (format.getSampleRate() == -1.0f || format.getSampleRate() >= 8000.0f) {
                    vAll.add(format);
                }
                if (format.getChannels() != 1 || format.getSampleSizeInBits() != 16 || format.getSampleRate() != -1.0f && format.getSampleRate() != 11025.0f) continue;
                vOptimal.add(format);
            }
        }
        if (vAll.isEmpty()) {
            throw new Exception("Unable to find any available TargetDataLine for recording");
        }
        if (!vOptimal.isEmpty()) {
            AudioFormat[] af = vOptimal.toArray(new AudioFormat[vOptimal.size()]);
            dli = new DataLine.Info(TargetDataLine.class, af, 10000, 11000);
            try {
                m_targetLine = (TargetDataLine)AudioSystem.getLine(dli);
                m_targetLine.open();
            }
            catch (Exception ex) {
                m_targetLine = null;
            }
        }
        if (m_targetLine == null) {
            AudioFormat[] af = vAll.toArray(new AudioFormat[vAll.size()]);
            dli = new DataLine.Info(TargetDataLine.class, af, 10000, 11000);
            m_targetLine = (TargetDataLine)AudioSystem.getLine(dli);
            m_targetLine.open();
        }
        dli = new DataLine.Info(SourceDataLine.class, m_targetLine.getFormat());
        m_sourceLine = (SourceDataLine)AudioSystem.getLine(dli);
        m_sourceLine.open();
        initialized = true;
    }

    @Override
    public void record() throws Exception {
        if (!initialized) {
            AudioBuffer.hideRecordingCursor();
            AudioBuffer.activeAudioBuffer = null;
            return;
        }
        this.stop();
        recordThread = new RecordThread();
        recordThread.start();
        recordTimer = new Timer();
        recordTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                recordTimer = null;
                if (recordThread != null) {
                    recordThread.running = false;
                }
            }
        }, this.m_seconds * 1000);
    }

    @Override
    public void play() throws Exception {
        if (!initialized) {
            return;
        }
        this.stop();
        if (this.m_buffer != null && this.m_buffer.length > 0) {
            playThread = new PlayThread();
            playThread.start();
        }
    }

    private boolean isRunning() {
        return playThread != null || recordThread != null;
    }

    @Override
    public void stop() {
        if (recordThread != null) {
            JavaSoundAudioBuffer.recordThread.running = false;
        }
        if (playThread != null) {
            JavaSoundAudioBuffer.playThread.running = false;
        }
        while (recordThread != null || playThread != null) {
            Thread.yield();
        }
    }

    @Override
    protected void clear() {
        this.stop();
        this.m_buffer = null;
    }

    static /* synthetic */ byte[] access$002(JavaSoundAudioBuffer x0, byte[] x1) {
        x0.m_buffer = x1;
        return x1;
    }

    class PlayThread
    extends Thread {
        public boolean running = false;
        byte[] buf;

        public PlayThread() {
            this.buf = new byte[JavaSoundAudioBuffer.this.m_buffer.length];
            System.arraycopy(JavaSoundAudioBuffer.this.m_buffer, 0, this.buf, 0, JavaSoundAudioBuffer.this.m_buffer.length);
        }

        @Override
        public void run() {
            this.running = true;
            try {
                int k;
                m_sourceLine.start();
                int l = m_sourceLine.getBufferSize() / 2;
                int p = 0;
                for (int remainingData = this.buf.length; this.running && remainingData > 0; remainingData -= k) {
                    k = m_sourceLine.write(this.buf, p, Math.min(l, remainingData));
                    p += k;
                    Thread.yield();
                }
            }
            catch (Exception ex) {
                System.err.println("JavaSound playing error:\n" + ex);
            }
            m_sourceLine.drain();
            m_sourceLine.stop();
            playThread = null;
            this.running = false;
        }
    }

    class RecordThread
    extends Thread {
        public boolean running = false;

        @Override
        public void run() {
            AudioBuffer.activeAudioBuffer = JavaSoundAudioBuffer.this;
            this.running = true;
            JavaSoundAudioBuffer.access$002(JavaSoundAudioBuffer.this, null);
            ByteArrayOutputStream out = new ByteArrayOutputStream(10000);
            try {
                byte[] data = new byte[5000];
                m_targetLine.start();
                do {
                    int avail;
                    if ((avail = m_targetLine.available()) > 0) {
                        int numBytesRead = m_targetLine.read(data, 0, Math.min(avail, data.length));
                        out.write(data, 0, numBytesRead);
                    }
                    Thread.yield();
                } while (this.running);
                if (recordTimer != null) {
                    recordTimer.cancel();
                    recordTimer = null;
                }
            }
            catch (Exception ex) {
                System.err.println("JavaSound recording error:\n" + ex);
            }
            m_targetLine.stop();
            m_targetLine.flush();
            JavaSoundAudioBuffer.access$002(JavaSoundAudioBuffer.this, out.toByteArray());
            AudioBuffer.hideRecordingCursor();
            AudioBuffer.activeAudioBuffer = null;
            recordThread = null;
            this.running = false;
        }
    }
}

