/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.media.AudioPlayer;
import edu.xtec.jclic.media.QT61Tools;
import quicktime.app.time.TaskAllMovies;
import quicktime.app.view.MoviePlayer;

public class QT61AudioPlayer
implements AudioPlayer {
    MoviePlayer player = null;

    @Override
    public void play() {
        if (this.player != null) {
            this.stop();
            try {
                this.player.setTime(0);
                TaskAllMovies.addMovieAndStart();
                this.player.getMovie().setActive(true);
                this.player.setRate(1.0f);
            }
            catch (Exception ex) {
                System.err.println("QT Exception:\n" + ex);
            }
        }
    }

    @Override
    public boolean setDataSource(Object source) throws Exception {
        this.close();
        this.player = QT61Tools.getPlayer(source);
        return this.player != null;
    }

    @Override
    public void stop() {
        if (this.player != null) {
            try {
                this.player.setRate(0.0f);
                this.player.getMovie().setActive(false);
                TaskAllMovies.removeMovie();
            }
            catch (Exception ex) {
                System.err.println("QT Error:\n" + ex);
            }
        }
    }

    @Override
    public void close() {
        if (this.player != null) {
            this.stop();
            if (this.player != null) {
                try {
                    this.player.getMovie().disposeQTObject();
                }
                catch (Exception ex) {
                    System.err.println("QT Error:\n" + ex);
                }
            }
            this.player = null;
        }
    }

    @Override
    public void realize(String fileName, MediaBag mediaBag) throws Exception {
        if (fileName != null) {
            this.setDataSource(mediaBag.getMediaDataSource(fileName));
        }
    }
}

