/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.activities.panels.Menu;
import edu.xtec.jclic.activities.panels.MenuEditor;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorTreePanel;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.project.ProjectLibraryEditor;
import edu.xtec.util.ExtendedJDialog;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.ResourceManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.jdom.Document;
import org.jdom.Element;

public class ProjectLibrary
extends JClicProject
implements Editable {
    public static final String LIBRARY_TYPE = "library";
    public static final String MSG_ID = "library_";

    private ProjectLibrary(ResourceBridge rb, FileSystem fileSystem, String fullPath) {
        super(rb, fileSystem, fullPath);
        this.type = LIBRARY_TYPE;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        this.type = null;
        super.setProperties(e, aux);
        if (!LIBRARY_TYPE.equals(this.type)) {
            throw new Exception(this.bridge.getMsg("library_badFormat"));
        }
    }

    public static ProjectLibrary createNewProjectLibrary(ResourceBridge rb, FileSystem fileSystem) {
        String description;
        ProjectLibrary pl = new ProjectLibrary(rb, fileSystem, null);
        pl.settings.title = rb.getMsg("library_newLibraryName");
        Menu m = new Menu(pl);
        m.name = "main";
        m.description = description = rb.getMsg("library_mainMenu");
        ActiveBoxContent[] messages = m.getMessages();
        messages[1] = new ActiveBoxContent();
        messages[1].setBoxBase(new BoxBase());
        messages[1].setTextContent(description);
        pl.activityBag.addActivity(m);
        pl.activitySequence.add(new ActivitySequenceElement(m.name, true));
        return pl;
    }

    public static ProjectLibrary getProjectLibrary(Element e, ResourceBridge rb, FileSystem fileSystem, String fullPath) throws Exception {
        ProjectLibrary pl = new ProjectLibrary(rb, fileSystem, fullPath);
        pl.setProperties(e, null);
        return pl;
    }

    public static ProjectLibrary loadProjectLibrary(String fullPath, ResourceBridge rb) throws Exception {
        FileSystem fs = FileSystem.createFileSystem(fullPath, rb);
        Document doc = fs.getXMLDocument(FileSystem.getFileNameOf(fullPath));
        ProjectLibrary pl = new ProjectLibrary(rb, fs, fullPath);
        pl.setProperties(doc.getRootElement(), null);
        return pl;
    }

    public void save(String path) throws Exception {
        if (path == null) {
            path = this.fullPath;
        }
        FileOutputStream fos = this.fileSystem.createSecureFileOutputStream(path);
        this.saveDocument(fos);
        fos.close();
    }

    public String toString() {
        return this.settings.title;
    }

    @Override
    public String getPublicName() {
        return this.settings.title;
    }

    public Menu getRootMenu() {
        Menu result = null;
        if (this.activitySequence.getSize() > 0) {
            try {
                Activity act;
                ActivitySequenceElement ase = this.activitySequence.getElement(0, false);
                if (ase != null && (act = Activity.getActivity(this.activityBag.getElement(ase.getActivityName()).getData(), this)) instanceof Menu) {
                    result = (Menu)act;
                }
            }
            catch (Exception ex) {
                System.err.println("Error reading project library!\n" + ex);
            }
        }
        return result;
    }

    @Override
    public Editor getEditor(Editor parent) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, parent);
    }

    public boolean editProjectLibrary(Object parent) {
        ProjectLibraryDialog pld = parent instanceof JDialog ? new ProjectLibraryDialog(true, true, (JDialog)parent) : new ProjectLibraryDialog(true, true);
        pld.setVisible(true);
        return pld.accept;
    }

    protected JComponent getRbComponent() {
        if (this.bridge == null) {
            return null;
        }
        return this.bridge.getComponent();
    }

    protected String getRbMessage(String msg) {
        if (this.bridge == null) {
            return "";
        }
        return this.bridge.getMsg(msg);
    }

    class ProjectLibraryDialog
    extends ExtendedJDialog {
        ProjectLibraryEditor pled;
        EditorTreePanel etp;
        Menu result;
        boolean accept;
        boolean allowEdit;
        boolean allowNewMenu;
        Action selectAction;
        Action cancelAction;

        ProjectLibraryDialog(boolean allowNewMenu, boolean allowEdit, JDialog parent) {
            super(parent, ProjectLibrary.this.bridge.getMsg("library_caption"), true);
            this.result = null;
            this.accept = false;
            this.allowEdit = allowEdit;
            this.allowNewMenu = allowNewMenu;
            this.init();
        }

        ProjectLibraryDialog(boolean allowNewMenu, boolean allowEdit) {
            super(ProjectLibrary.this.getRbComponent(), ProjectLibrary.this.getRbMessage("library_caption"), true);
            this.result = null;
            this.accept = false;
            this.allowEdit = allowEdit;
            this.allowNewMenu = allowNewMenu;
            this.init();
        }

        protected void init() {
            this.buildActions();
            this.pled = (ProjectLibraryEditor)ProjectLibrary.this.getEditor(null);
            this.etp = new EditorTreePanel(this.pled, ProjectLibrary.this.bridge.getOptions(), !this.allowEdit, this.allowEdit ? null : Menu.class){

                @Override
                protected void currentItemChanged() {
                    if (!ProjectLibraryDialog.this.allowEdit) {
                        ProjectLibraryDialog.this.selectAction.setEnabled(this.currentItem != null);
                    }
                    super.currentItemChanged();
                }
            };
            this.getContentPane().add((Component)this.etp, "Center");
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.add(new JButton(this.selectAction));
            buttonsPanel.add(new JButton(this.cancelAction));
            this.getContentPane().add((Component)buttonsPanel, "South");
            this.pack();
            this.centerOver(ProjectLibrary.this.bridge.getComponent());
        }

        void buildActions() {
            String s = this.allowEdit ? "select_caption_ok" : "select_caption";
            this.selectAction = new AbstractAction(ProjectLibrary.this.bridge.getMsg(ProjectLibrary.MSG_ID + s), ResourceManager.getImageIcon(this.allowEdit ? "icons/commit_changes.gif" : "icons/file_open.gif")){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (ProjectLibraryDialog.this.allowEdit && ProjectLibraryDialog.this.etp.getCurrentPanel() != null) {
                        ProjectLibraryDialog.this.etp.getCurrentPanel().save();
                        if (ProjectLibraryDialog.this.pled.isModified()) {
                            ProjectLibraryDialog.this.pled.saveMenus(ProjectLibraryDialog.this.pled);
                            try {
                                ProjectLibrary.this.save(null);
                            }
                            catch (Exception ex) {
                                ProjectLibrary.this.bridge.getOptions().getMessages().showErrorWarning((Component)ProjectLibraryDialog.this.getParent(), "FILE_ERR_SAVING", ProjectLibrary.this.fullPath, ex, null);
                            }
                        }
                    }
                    if (ProjectLibraryDialog.this.etp.currentItem != null && ProjectLibraryDialog.this.etp.currentItem instanceof MenuEditor) {
                        ProjectLibraryDialog.this.result = ((MenuEditor)ProjectLibraryDialog.this.etp.currentItem).getMenu();
                    } else {
                        ProjectLibraryDialog.this.result = null;
                        if (!ProjectLibraryDialog.this.allowEdit) {
                            return;
                        }
                    }
                    ProjectLibraryDialog.this.accept = true;
                    ProjectLibraryDialog.this.setVisible(false);
                }
            };
            this.selectAction.putValue("ShortDescription", ProjectLibrary.this.bridge.getMsg(ProjectLibrary.MSG_ID + s + "_tooltip"));
            if (!this.allowEdit) {
                this.selectAction.setEnabled(false);
            }
            this.cancelAction = new AbstractAction(ProjectLibrary.this.bridge.getMsg("library_cancel_caption"), ResourceManager.getImageIcon("icons/cancel.gif")){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ProjectLibraryDialog.this.result = null;
                    ProjectLibraryDialog.this.accept = false;
                    ProjectLibraryDialog.this.setVisible(false);
                }
            };
            this.cancelAction.putValue("ShortDescription", ProjectLibrary.this.bridge.getMsg("library_cancel_tooltip"));
        }
    }
}

