/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.project.Author;
import edu.xtec.jclic.project.Organization;
import edu.xtec.jclic.project.Revision;
import edu.xtec.util.Domable;
import edu.xtec.util.Html;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import edu.xtec.util.StrUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectSettings
implements Editable,
Domable {
    public String title = UNTITLED;
    public String iconFileName = null;
    public String description = null;
    public String descriptors = null;
    public String area = null;
    public String level = null;
    public Locale locale = null;
    public String[] languages = null;
    public Author[] authors = null;
    public Organization[] organizations = null;
    public Revision[] revisions = new Revision[]{new Revision(new Date(), "created")};
    public String skinFileName = null;
    public EventSounds eventSounds = new EventSounds(null);
    public static String UNTITLED = "untitled";
    public static String ELEMENT_NAME = "settings";
    public static String TITLE = "title";
    public static String LOCALE = "locale";
    public static String LANGUAGE = "language";
    public static String DESCRIPTION = "description";
    public static String DESCRIPTORS = "descriptors";
    public static String SKIN = "skin";
    public static String FILE = "file";
    public static String AREA = "area";
    public static String LEVEL = "level";
    public static String ICON = "icon";

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        e.addContent(new Element(TITLE).setText(this.title));
        if (this.revisions != null) {
            for (Domable domable : this.revisions) {
                e.addContent(((Revision)domable).getJDomElement());
            }
        }
        if (this.authors != null) {
            for (Author author : this.authors) {
                e.addContent(author.getJDomElement());
            }
        }
        if (this.organizations != null) {
            for (Organization organization : this.organizations) {
                e.addContent(organization.getJDomElement());
            }
        }
        if (this.languages != null) {
            for (String string : this.languages) {
                e.addContent(new Element(LANGUAGE).setText(string));
            }
        }
        if (this.locale != null) {
            StringBuilder sb = new StringBuilder(this.locale.getLanguage());
            if (this.locale.getCountry() != null && this.locale.getCountry().length() > 0) {
                sb.append('-').append(this.locale.getCountry());
                if (this.locale.getVariant() != null && this.locale.getVariant().length() > 0) {
                    sb.append('-').append(this.locale.getVariant());
                }
            }
            e.setAttribute(LOCALE, sb.substring(0));
        }
        if (this.description != null) {
            JDomUtility.addParagraphs(e, DESCRIPTION, this.description);
        }
        Element child = new Element(DESCRIPTORS);
        if (this.area != null) {
            child.setAttribute(AREA, this.area);
        }
        if (this.level != null) {
            child.setAttribute(LEVEL, this.level);
        }
        if (this.descriptors != null) {
            child.setText(this.descriptors);
        }
        e.addContent(child);
        child = this.eventSounds.getJDomElement();
        if (child != null) {
            e.addContent(child);
        }
        if (this.skinFileName != null) {
            child = new Element(SKIN);
            child.setAttribute(FILE, this.skinFileName);
            e.addContent(child);
        }
        if (this.iconFileName != null) {
            child = new Element(ICON);
            child.setAttribute(FILE, this.iconFileName);
            e.addContent(child);
        }
        return e;
    }

    public static ProjectSettings getProjectSettings(Element e) throws Exception {
        ProjectSettings st = new ProjectSettings();
        st.setProperties(e, null);
        return st;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        String s;
        JDomUtility.checkName(e, ELEMENT_NAME);
        Element child = e.getChild(TITLE);
        if (child != null) {
            this.title = child.getText();
        }
        ArrayList<Revision> alr = new ArrayList<Revision>();
        Iterator itr = e.getChildren("revision").iterator();
        while (itr.hasNext()) {
            alr.add(Revision.getRevision((Element)itr.next()));
        }
        if (!alr.isEmpty()) {
            this.revisions = alr.toArray(new Revision[alr.size()]);
        }
        ArrayList<Author> alau = new ArrayList<Author>();
        itr = e.getChildren("author").iterator();
        while (itr.hasNext()) {
            alau.add(Author.getAuthor((Element)itr.next()));
        }
        if (!alau.isEmpty()) {
            this.authors = alau.toArray(new Author[alau.size()]);
        }
        ArrayList<Organization> alo = new ArrayList<Organization>();
        itr = e.getChildren("organization").iterator();
        while (itr.hasNext()) {
            alo.add(Organization.getOrganization((Element)itr.next()));
        }
        if (!alo.isEmpty()) {
            this.organizations = alo.toArray(new Organization[alo.size()]);
        }
        ArrayList<String> all = new ArrayList<String>();
        itr = e.getChildren(LANGUAGE).iterator();
        while (itr.hasNext()) {
            all.add(((Element)itr.next()).getText());
        }
        if (!all.isEmpty()) {
            this.languages = all.toArray(new String[all.size()]);
        }
        if ((s = JDomUtility.getStringAttr(e, LOCALE, null, false)) != null) {
            StringTokenizer stk = new StringTokenizer(s, "-");
            String l = null;
            String c = null;
            String v = null;
            if (stk.hasMoreTokens()) {
                l = stk.nextToken();
            }
            if (stk.hasMoreTokens()) {
                c = stk.nextToken();
            }
            if (stk.hasMoreTokens()) {
                v = stk.nextToken();
            }
            if (l != null && c != null) {
                this.locale = v != null ? new Locale(l, c, v) : new Locale(l, c);
            }
        }
        this.description = JDomUtility.getParagraphs(e.getChild(DESCRIPTION));
        child = e.getChild(DESCRIPTORS);
        if (child != null) {
            if (!child.getChildren("p").isEmpty()) {
                this.descriptors = JDomUtility.getParagraphs(e.getChild(DESCRIPTORS));
                this.descriptors = StrUtils.replace(this.descriptors, "\n", ", ");
            } else {
                this.descriptors = StrUtils.nullableString(child.getTextNormalize());
            }
            this.area = JDomUtility.getStringAttr(child, AREA, this.area, false);
            this.level = JDomUtility.getStringAttr(child, LEVEL, this.level, false);
        }
        if ((child = e.getChild("eventSounds")) != null) {
            this.eventSounds = EventSounds.getEventSounds(child);
        }
        if ((child = e.getChild(SKIN)) != null) {
            this.skinFileName = JDomUtility.getStringAttr(child, FILE, this.skinFileName, false);
        }
        if ((child = e.getChild(ICON)) != null) {
            this.iconFileName = JDomUtility.getStringAttr(child, FILE, this.iconFileName, false);
        }
    }

    public String toHtmlString(Messages msg) {
        int i;
        int k;
        String msgBase = "about_window_lb_";
        Html html = new Html(1000);
        html.doubleCell(msg.get(msgBase + "project"), true, this.title, true);
        if (this.area != null) {
            html.doubleCell(msg.get(msgBase + "area"), true, this.area, false);
        }
        if (this.level != null) {
            html.doubleCell(msg.get(msgBase + "level"), true, this.level, false);
        }
        if (this.authors != null) {
            k = this.authors.length;
            html.tr(true).td(msg.get(msgBase + "author" + (k > 1 ? "s" : "")), true).td(true);
            for (i = 0; i < k; ++i) {
                if (this.authors[i] == null) continue;
                html.append(this.authors[i].toHtmlString(msg)).br();
            }
            html.td(false).tr(false);
        }
        if (this.organizations != null) {
            k = this.organizations.length;
            html.tr(true).td(msg.get(msgBase + "organization" + (k > 1 ? "s" : "")), true).td(true);
            for (i = 0; i < this.organizations.length; ++i) {
                if (i > 0) {
                    html.nbsp().br();
                }
                if (this.organizations[i] == null) continue;
                html.append(this.organizations[i].toHtmlString(msg)).br();
            }
            html.td(false).tr(false);
        }
        if (this.revisions != null) {
            html.tr(true).td(msg.get(msgBase + "history"), true).td(true);
            for (int i2 = 0; i2 < this.revisions.length; ++i2) {
                if (i2 > 0) {
                    html.nbsp().br();
                }
                if (this.revisions[i2] == null) continue;
                html.append(this.revisions[i2].toHtmlString(msg)).br();
            }
            html.td(false).tr(false);
        }
        if (this.languages != null) {
            k = this.languages.length;
            html.tr(true).td(msg.get(msgBase + "language" + (k > 1 ? "s" : "")), true).td(true);
            for (i = 0; i < k; ++i) {
                if (this.languages[i] == null) continue;
                html.append(this.languages[i]).sp();
            }
            html.td(false).tr(false);
        }
        if (this.description != null) {
            html.doubleCell(msg.get(msgBase + "description"), true, this.description, false);
        }
        if (this.descriptors != null) {
            html.doubleCell(msg.get(msgBase + "descriptors"), true, this.descriptors, false);
        }
        return Html.table(html.toString(), null, 1, 5, -1, null, false);
    }

    public JSONObject toJSON(Messages msg) throws JSONException {
        StringBuilder sb;
        JSONObject json = new JSONObject();
        json.put("title", this.title);
        if (this.authors != null && this.authors.length > 0) {
            sb = new StringBuilder();
            for (Domable domable : this.authors) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(((Author)domable).toString());
            }
            json.put("author", sb.toString());
        }
        if (this.organizations != null && this.organizations.length > 0) {
            sb = new StringBuilder();
            for (Domable domable : this.organizations) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(((Organization)domable).toString());
            }
            json.put("school", sb.toString());
        }
        if (this.revisions != null && this.revisions.length > 0) {
            json.put("date", msg.getShortDateStr(this.revisions[0].date));
        }
        Locale locale = msg.getLocale();
        String langCode = msg.getLocale().getLanguage();
        boolean langCodeSet = false;
        if (this.languages != null && this.languages.length > 0) {
            String langNames = "";
            for (String lang : this.languages) {
                String code = null;
                int p = lang.lastIndexOf(40);
                int q = lang.lastIndexOf(41);
                code = p > 0 && q > p ? lang.substring(p + 1, q) : (String)Messages.getNamesToCodes().get(lang.toLowerCase());
                if (code == null) continue;
                if (!langCodeSet) {
                    langCode = code;
                    locale = new Locale(code);
                    langCodeSet = true;
                }
                json.append("langCodes", code);
                if (langNames.length() > 0) {
                    langNames = langNames + ", ";
                }
                langNames = langNames + new Locale(code).getDisplayName(locale);
            }
            if (langNames.length() > 0) {
                json.put("languages", new JSONObject().put(langCode, langNames));
            }
        }
        if (this.area != null) {
            json.put("areas", new JSONObject().put(langCode, this.area));
        }
        if (this.level != null) {
            json.put("levels", new JSONObject().put(langCode, this.level));
        }
        if (this.description != null) {
            json.put("description", new JSONObject().put(langCode, this.description));
        }
        json.append("meta_langs", langCode);
        return json;
    }

    @Override
    public Editor getEditor(Editor parent) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, parent);
    }
}

