/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.report.GroupData;
import edu.xtec.jclic.report.SequenceReg;
import edu.xtec.jclic.report.SessionReg;
import edu.xtec.jclic.report.UserData;
import edu.xtec.util.CompoundListCellRenderer;
import edu.xtec.util.Encryption;
import edu.xtec.util.Html;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class Reporter {
    String userId;
    String sessionKey;
    String sessionContext;
    String groupCodeFilter;
    String userCodeFilter;
    String description;
    Date started;
    List<SessionReg> sessions = new CopyOnWriteArrayList<SessionReg>();
    SessionReg currentSession;
    public boolean initiated = false;
    protected Boolean bUserBased;
    public static final String ALLOW_CREATE_GROUPS = "ALLOW_CREATE_GROUPS";
    public static final String ALLOW_CREATE_USERS = "ALLOW_CREATE_USERS";
    public static final String SHOW_GROUP_LIST = "SHOW_GROUP_LIST";
    public static final String SHOW_USER_LIST = "SHOW_USER_LIST";
    public static final String USER_TABLES = "USER_TABLES";
    public static final String TIME_LAP = "TIME_LAP";
    public static final String ELEMENT_NAME = "reporter";
    public static final String USER_ID = "user";
    public static final String KEY = "key";
    public static final String CONTEXT = "context";
    public static final String GROUP_CODE_FILTER = "groupCodeFilter";
    public static final String USER_CODE_FILTER = "userCodeFilter";

    public Reporter() {
        this.started = new Date();
    }

    public String getProperty(String key, String defaultValue) throws Exception {
        return defaultValue;
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) throws Exception {
        String s = this.getProperty(key, new Boolean(defaultValue).toString());
        return key == null ? defaultValue : Boolean.valueOf(s);
    }

    public List<GroupData> getGroups() throws Exception {
        return null;
    }

    public List<UserData> getUsers(String groupId) throws Exception {
        return null;
    }

    public UserData getUserData(String userId) throws Exception {
        return null;
    }

    public GroupData getGroupData(String groupId) throws Exception {
        return null;
    }

    public boolean userBased() throws Exception {
        if (this.bUserBased == null) {
            this.bUserBased = this.getBooleanProperty(USER_TABLES, true);
        }
        return this.bUserBased;
    }

    protected GroupData promptForNewGroup(Component parent, Messages msg) throws Exception {
        JTextField gName = new JTextField(20);
        JTextField gId = new JTextField(20);
        JComponent[] jc = new JComponent[]{gName, gId};
        String[] ps = new String[]{"report_name_prompt", "report_id_prompt"};
        GroupData result = null;
        while (result == null) {
            boolean dlgResult = msg.showInputDlg(parent, new String[]{"report_new_group_data"}, ps, jc, "report_new_group");
            if (!dlgResult) {
                return null;
            }
            String name = StrUtils.nullableString(gName.getText());
            String id = StrUtils.nullableString(gId.getText());
            if (id == null) {
                msg.showAlert(parent, "report_err_bad_id");
                continue;
            }
            if (this.getGroupData(id) != null) {
                msg.showAlert(parent, "report_err_duplicate_id");
                continue;
            }
            if (name == null) {
                msg.showAlert(parent, "report_err_bad_name");
                continue;
            }
            result = new GroupData(id, name, null, null);
            result.setId(this.newGroup(result));
        }
        return result;
    }

    protected UserData promptForNewUser(Component parent, Messages msg, String groupId) throws Exception {
        if (groupId == null && (groupId = this.promptGroupId(parent, msg)) == null) {
            return null;
        }
        JTextField gName = new JTextField(20);
        JTextField gId = new JTextField(20);
        JPasswordField pwf1 = new JPasswordField(24);
        JPasswordField pwf2 = new JPasswordField(24);
        JComponent[] jc = new JComponent[]{gName, gId, pwf1, pwf2};
        String[] ps = new String[]{"report_name_prompt", "report_id_prompt", "report_pw_prompt", "report_pw_prompt_confirm"};
        UserData result = null;
        while (result == null) {
            if (!msg.showInputDlg(parent, new String[]{"report_new_user_data"}, ps, jc, "report_new_user")) {
                return null;
            }
            String name = StrUtils.nullableString(gName.getText());
            String id = StrUtils.nullableString(gId.getText());
            String pw = StrUtils.nullableString(String.copyValueOf(pwf1.getPassword()));
            boolean pwOk = true;
            if (pw != null) {
                pwOk = pw.equals(StrUtils.nullableString(String.copyValueOf(pwf2.getPassword())));
                pw = Encryption.Encrypt(pw);
            }
            if (!pwOk) {
                msg.showAlert(parent, "report_err_bad_pwd");
                continue;
            }
            if (id == null) {
                msg.showAlert(parent, "report_err_bad_id");
                continue;
            }
            if (this.getUserData(id) != null) {
                msg.showAlert(parent, "report_err_duplicate_id");
                continue;
            }
            if (name == null) {
                msg.showAlert(parent, "report_err_bad_name");
                continue;
            }
            result = new UserData(id, name, null, pw, groupId);
            result.setId(this.newUser(result));
        }
        return result;
    }

    protected String promptGroupId(Component parent, final Messages msg) throws Exception {
        GroupData gd;
        JComponent[] jc;
        String groupId = null;
        if (this.getGroups().isEmpty()) {
            String s = msg.get("report_generic_group_name");
            this.newGroup(new GroupData(s, s, null, null));
            if (this.getGroups().isEmpty()) {
                return groupId;
            }
        }
        final List<GroupData> vg = this.getGroups();
        final JList<Object> list = new JList<Object>();
        list.setCellRenderer(new CompoundListCellRenderer());
        list.setListData(vg.toArray());
        list.setSelectedValue(vg.get(0), false);
        JScrollPane listScroll = new JScrollPane(list);
        if (this.getBooleanProperty(ALLOW_CREATE_GROUPS, false)) {
            JButton btn = new JButton(msg.get("report_new_group"));
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Component cmp = null;
                    if (evt.getSource() != null && evt.getSource() instanceof Component) {
                        cmp = (Component)evt.getSource();
                    }
                    try {
                        GroupData gd = Reporter.this.promptForNewGroup(cmp, msg);
                        if (gd != null) {
                            vg.add(gd);
                            list.setListData(vg.toArray());
                            list.setSelectedValue(gd, true);
                        }
                    }
                    catch (Exception ex) {
                        msg.showErrorWarning(cmp, "report_err_creating_group", ex);
                    }
                }
            });
            jc = new JComponent[]{listScroll, btn};
        } else {
            jc = new JComponent[]{listScroll};
        }
        if (msg.showInputDlg(parent, new String[]{"report_grouplist_title"}, null, jc, "report_ident_user") && (gd = (GroupData)list.getSelectedValue()) != null) {
            groupId = gd.getId();
        }
        return groupId;
    }

    public String promptUserId(Component parent, final Messages msg) throws Exception {
        if (!this.userBased()) {
            throw new Exception("No users defined in the database!");
        }
        boolean cancel = false;
        int tries = 0;
        while (this.userId == null && !cancel && tries++ < 3) {
            String uPwd;
            String s;
            if (this.getBooleanProperty(SHOW_USER_LIST, true)) {
                UserData ud;
                JComponent[] jc;
                String gi = null;
                if (this.getBooleanProperty(SHOW_GROUP_LIST, true) && (gi = this.promptGroupId(parent, msg)) == null) {
                    return null;
                }
                final String groupId = gi;
                final List<UserData> v = this.getUsers(groupId);
                boolean allow_create_users = this.getBooleanProperty(ALLOW_CREATE_USERS, false);
                if (v.isEmpty() && !allow_create_users) {
                    msg.showErrorWarning(parent, groupId == null ? "report_err_no_users" : "report_err_no_users_in_group", null);
                    break;
                }
                final JList<Object> list = new JList<Object>();
                list.setCellRenderer(new CompoundListCellRenderer());
                list.setListData(v.toArray());
                if (!v.isEmpty()) {
                    list.setSelectedValue(v.get(0), false);
                }
                JScrollPane listScroll = new JScrollPane(list);
                if (allow_create_users) {
                    JButton btn = new JButton(msg.get("report_new_user"));
                    btn.setToolTipText(msg.get("report_new_user_tooltip"));
                    btn.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            Component cmp = null;
                            if (evt.getSource() != null && evt.getSource() instanceof Component) {
                                cmp = (Component)evt.getSource();
                            }
                            try {
                                UserData ud = Reporter.this.promptForNewUser(cmp, msg, groupId);
                                if (ud != null) {
                                    v.add(ud);
                                    list.setListData(v.toArray());
                                    list.setSelectedValue(ud, true);
                                }
                            }
                            catch (Exception ex) {
                                msg.showErrorWarning(cmp, "report_err_creating_user", ex);
                            }
                        }
                    });
                    jc = new JComponent[]{listScroll, btn};
                } else {
                    jc = new JComponent[]{listScroll};
                }
                if (!msg.showInputDlg(parent, new String[]{"report_userlist_title"}, null, jc, "report_ident_user") || (ud = (UserData)list.getSelectedValue()) == null) break;
                if (ud.pwd != null && ud.pwd.length() > 0) {
                    String inputPwd;
                    String pwd = Encryption.Decrypt(ud.pwd);
                    if (pwd.equals(inputPwd = msg.showInputDlg(parent, "report_user_has_pwd", "report_pw_prompt", null, "report_ident_user", true))) {
                        this.userId = ud.getId();
                        continue;
                    }
                    msg.showErrorWarning(parent, "report_err_invalid_user", null);
                    continue;
                }
                this.userId = ud.getId();
                continue;
            }
            JTextField textField = new JTextField();
            JPasswordField pwdField = new JPasswordField(24);
            if (!msg.showInputDlg(parent, new String[]{"report_select_user"}, new String[]{"report_id_prompt", "report_pw_prompt"}, new JComponent[]{textField, pwdField}, "report_ident_user") || (s = StrUtils.nullableString(textField.getText())) == null) break;
            UserData ud = this.getUserData(s);
            boolean userOk = false;
            if (ud != null && ((uPwd = StrUtils.nullableString(ud.pwd)) == null || Encryption.Decrypt(uPwd).equals(String.copyValueOf(pwdField.getPassword())))) {
                userOk = true;
            }
            if (!userOk) {
                msg.showErrorWarning(parent, "report_err_invalid_user", null);
                continue;
            }
            this.userId = ud == null ? "" : ud.getId();
        }
        return this.userId;
    }

    public String toHtmlString(Messages msg) {
        String prefix = "report_";
        Html html = new Html(3000);
        Html tb = new Html(3000);
        tb.doubleCell(msg.get(prefix + "started"), true, msg.getShortDateTimeStr(this.started), false);
        tb.doubleCell(msg.get(prefix + "system"), true, this.description == null ? msg.get(prefix + "system_standard") : this.description, false);
        if (this.userId != null) {
            tb.doubleCell(msg.get(prefix + USER_ID), true, this.userId, false);
        }
        int numSessions = 0;
        int numSequences = 0;
        int nActivities = 0;
        int nActSolved = 0;
        int nActScore = 0;
        int nActions = 0;
        boolean percentSolved = false;
        long tScore = 0L;
        long tTime = 0L;
        Iterator<SessionReg> it = this.sessions.iterator();
        while (it.hasNext()) {
            SessionReg.Info inf = it.next().getInfo(true);
            if (inf.numSequences <= 0) continue;
            ++numSessions;
            numSequences += inf.numSequences;
            if (inf.nActivities <= 0) continue;
            nActivities += inf.nActivities;
            nActSolved += inf.nActSolved;
            nActions += inf.nActions;
            if (inf.nActScore > 0) {
                tScore += inf.tScore * (long)inf.nActScore;
                nActScore += inf.nActScore;
            }
            tTime += inf.tTime;
        }
        if (numSequences > 0) {
            if (numSessions > 1) {
                tb.doubleCell(msg.get(prefix + "num_projects"), true, msg.getNumber(numSessions), false);
            }
            tb.doubleCell(msg.get(prefix + "num_sequences"), true, msg.getNumber(numSequences), false);
            tb.doubleCell(msg.get(prefix + "num_activities"), true, msg.getNumber(nActivities), false);
            if (nActivities > 0) {
                tb.doubleCell(msg.get(prefix + "num_activities_solved"), true, msg.getNumber(nActSolved) + " (" + msg.getPercent(nActSolved * 100 / nActivities) + ")", false);
                if (nActScore > 0) {
                    tb.doubleCell(msg.get(prefix + "global_score"), true, msg.getPercent(tScore / (long)nActScore), false);
                }
                tb.doubleCell(msg.get(prefix + "total_time"), true, msg.getHmsTime(tTime), false);
                tb.doubleCell(msg.get(prefix + "num_actions"), true, msg.getNumber(nActions), false);
            }
            html.append(Html.table(tb.toString(), null, 0, 2, -1, null, false)).append("&nbsp;");
            StringBuilder tbs = new StringBuilder();
            for (SessionReg sr : this.sessions) {
                if (sr.getInfo((boolean)false).numSequences <= 0) continue;
                tbs.append(sr.toHtmlString(msg, false, numSessions > 1));
            }
            html.append(Html.table(tbs.substring(0), null, 1, 2, -1, null, false));
        } else {
            html.append(Html.table(tb.toString(), null, 0, 2, -1, null, false));
            html.br().bold(msg.get(prefix + "no_activities"));
        }
        return html.toString();
    }

    public void init(HashMap properties, Component parent, Messages msg) throws Exception {
        this.userId = (String)properties.get(USER_ID);
        this.sessionKey = (String)properties.get(KEY);
        this.sessionContext = (String)properties.get(CONTEXT);
        this.groupCodeFilter = (String)properties.get(GROUP_CODE_FILTER);
        this.userCodeFilter = (String)properties.get(USER_CODE_FILTER);
        this.initiated = true;
    }

    public static Reporter getReporter(HashMap properties, Component parent, Messages msg) throws Exception {
        if (properties == null) {
            throw new IllegalArgumentException("Null properties passed to \"getReporter\"");
        }
        String className = (String)properties.get("class");
        if (className == null) {
            throw new IllegalArgumentException("Properties passed to \"getReporter\" with null class name");
        }
        Class<?> reporterClass = Class.forName(className);
        Reporter rep = (Reporter)reporterClass.newInstance();
        rep.init(properties, parent, msg);
        return rep;
    }

    public static Reporter getReporter(String className, String strProperties, Component parent, Messages msg) throws Exception {
        if (className == null || className.length() == 0) {
            throw new IllegalArgumentException("Properties passed to \"getReporter\" with null class name");
        }
        if (className.indexOf(46) < 0) {
            className = "edu.xtec.jclic.report." + className;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("class", className);
        Options.strToMap(strProperties, properties, ";", '=', false);
        return Reporter.getReporter(properties, parent, msg);
    }

    protected void finalize() throws Throwable {
        try {
            this.end();
        }
        finally {
            super.finalize();
        }
    }

    public void end() {
        this.endSession();
    }

    public void endSequence() {
        if (this.currentSession != null) {
            this.currentSession.endSequence();
        }
    }

    public void endSession() {
        this.endSequence();
        this.currentSession = null;
    }

    public String newGroup(GroupData gd) throws Exception {
        throw new Exception("No database!");
    }

    public String newUser(UserData ud) throws Exception {
        throw new Exception("No database!");
    }

    public void newSession(JClicProject jcp, Component parent, Messages msg) {
        this.endSession();
        this.currentSession = new SessionReg(jcp);
        this.sessions.add(this.currentSession);
    }

    public void newSequence(ActivitySequenceElement ase) {
        if (this.currentSession != null) {
            this.currentSession.newSequence(ase);
        }
    }

    public void newActivity(Activity act) {
        if (this.currentSession != null) {
            this.currentSession.newActivity(act);
        }
    }

    public void endActivity(int score, int numActions, boolean solved) {
        if (this.currentSession != null) {
            this.currentSession.endActivity(score, numActions, solved);
        }
    }

    public void newAction(String type, String source, String dest, boolean ok) {
        if (this.currentSession != null) {
            this.currentSession.newAction(type, source, dest, ok);
        }
    }

    public SequenceReg.Info getCurrentSequenceInfo() {
        return this.currentSession == null ? null : this.currentSession.getCurrentSequenceInfo();
    }

    public String getCurrentSequenceTag() {
        return this.currentSession == null ? null : this.currentSession.getCurrentSequenceTag();
    }
}

