/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.report.ActivityReg;
import edu.xtec.util.Html;
import edu.xtec.util.Messages;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SequenceReg
implements Serializable {
    String name;
    String description;
    List<ActivityReg> activities;
    ActivityReg currentActivity;
    long totalTime;
    boolean closed;
    protected transient Info info;

    public SequenceReg(ActivitySequenceElement ase) {
        this.name = ase.getTag();
        this.description = ase.getDescription();
        this.activities = new CopyOnWriteArrayList<ActivityReg>();
        this.currentActivity = null;
        this.totalTime = 0L;
        this.closed = false;
        this.info = new Info();
    }

    public String toHtmlString(Messages msg) {
        Html html = new Html(3000);
        String fh = new Html(200).td(this.name, 0, false, "ROWSPAN=\"" + msg.getNumber(this.activities.size()) + "\"").toString();
        Iterator<ActivityReg> it = this.activities.iterator();
        while (it.hasNext()) {
            html.append(it.next().toHtmlString(msg, fh));
            fh = null;
        }
        return html.toString();
    }

    public Info getInfo(boolean recalc) {
        if (recalc) {
            this.info.recalc();
        }
        return this.info;
    }

    void newActivity(Activity act) {
        if (!this.closed) {
            this.currentActivity = new ActivityReg(act);
            this.activities.add(this.currentActivity);
        }
    }

    void newAction(String type, String source, String dest, boolean ok) {
        if (this.currentActivity != null) {
            this.currentActivity.newAction(type, source, dest, ok);
        }
    }

    void endActivity(int score, int numActions, boolean solved) {
        if (this.currentActivity != null) {
            this.currentActivity.endActivity(score, numActions, solved);
        }
    }

    void endSequence() {
        if (this.currentActivity != null && !this.activities.isEmpty()) {
            if (!this.currentActivity.closed) {
                this.currentActivity.closeActivity();
            }
            ActivityReg firstActivity = this.activities.get(0);
            this.totalTime = this.currentActivity.startTime + this.currentActivity.totalTime - firstActivity.startTime;
        }
    }

    public String toString() {
        return new StringBuilder("SEQUENCE: ").append(this.name).substring(0);
    }

    public class Info {
        public int nActivities;
        public int nActClosed;
        public int nActSolved;
        public int nActScore;
        public int percentSolved;
        public int nActions;
        public long tScore;
        public long tTime;

        protected Info() {
            this.clear();
        }

        protected void clear() {
            this.nActions = 0;
            this.percentSolved = 0;
            this.nActScore = 0;
            this.nActSolved = 0;
            this.nActClosed = 0;
            this.nActivities = 0;
            this.tTime = 0L;
            this.tScore = 0L;
        }

        public void recalc() {
            this.clear();
            this.nActivities = SequenceReg.this.activities.size();
            if (this.nActivities > 0) {
                for (ActivityReg ar : SequenceReg.this.activities) {
                    int r;
                    if (!ar.closed) continue;
                    ++this.nActClosed;
                    this.tTime += ar.totalTime;
                    this.nActions += ar.numActions;
                    if (ar.solved) {
                        ++this.nActSolved;
                    }
                    if ((r = ar.getPrecision()) < 0) continue;
                    this.tScore += (long)r;
                    ++this.nActScore;
                }
                if (this.nActClosed > 0) {
                    this.percentSolved = this.nActSolved * 100 / this.nActClosed;
                }
                if (this.nActScore > 0) {
                    this.tScore /= (long)this.nActScore;
                }
            }
        }
    }
}

