/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.util.JDomUtility;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.StringTokenizer;
import org.jdom.Element;

public class ShapeData
implements Cloneable {
    public static final int CAPACITY_BLOCK = 6;
    protected double[] points = new double[12];
    protected int pointsIndex = 0;
    protected int[] descriptors = new int[6];
    protected int descriptorsIndex = 0;
    protected int windingRule = 1;
    protected int primitiveType = -1;
    protected double[] primitivePoints = null;
    public String comment = null;
    public static final String ELEMENT_NAME = "shape";
    public static final String COMMENT = "comment";
    public static final int RECTANGLE = 0;
    public static final int ELLIPSE = 1;
    public static final int ROUND_RECT = 2;
    public static final int ARC = 3;
    public static final int NUM_PRIMITIVES = 4;
    public static final String[] PRIMITIVES = new String[]{"rectangle", "ellipse", "roundRectangle", "pie"};
    public static final String RULE = "rule";
    public static final String MOVE_TO = "M";
    public static final String LINE_TO = "L";
    public static final String QUAD_TO = "Q";
    public static final String CUBIC_TO = "B";
    public static final String CLOSE = "X";
    public static final String DELIMS = "|:,";
    public static final char[] DELIM_CHAR = "|:,".toCharArray();
    private static DecimalFormat DF;

    public Element getJDomElement(double scaleW, double scaleH) {
        Element e = new Element(ELEMENT_NAME);
        if (this.comment != null && this.comment.length() > 0) {
            e.setAttribute(COMMENT, this.comment);
        }
        StringBuilder sb = new StringBuilder();
        int j = 0;
        if (this.primitiveType >= 0 && this.primitivePoints != null) {
            this.writeToSb(sb, PRIMITIVES[this.primitiveType], this.primitivePoints, j, this.primitivePoints.length, scaleW, scaleH);
        } else {
            if (this.windingRule != 1) {
                e.setAttribute(RULE, Integer.toString(this.windingRule));
            }
            for (int i = 0; i < this.descriptorsIndex; ++i) {
                String type = CLOSE;
                int k = 0;
                if (i > 0) {
                    sb.append(DELIM_CHAR[0]);
                }
                switch (this.descriptors[i]) {
                    case 0: {
                        type = MOVE_TO;
                        k = 2;
                        break;
                    }
                    case 1: {
                        type = LINE_TO;
                        k = 2;
                        break;
                    }
                    case 2: {
                        type = QUAD_TO;
                        k = 4;
                        break;
                    }
                    case 3: {
                        type = CUBIC_TO;
                        k = 6;
                        break;
                    }
                }
                this.writeToSb(sb, type, this.points, j, k, scaleW, scaleH);
                j += k;
            }
        }
        e.addContent(sb.substring(0));
        return e;
    }

    public static ShapeData getShapeData(Element e, double scaleW, double scaleH) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        ShapeData sd = new ShapeData();
        sd.comment = JDomUtility.getStringAttr(e, COMMENT, sd.comment, false);
        sd.setWindingRule(JDomUtility.getIntAttr(e, RULE, sd.windingRule));
        StringTokenizer st = new StringTokenizer(e.getText(), DELIMS);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            for (int k = 0; k < 4; ++k) {
                if (!s.equals(PRIMITIVES[k])) continue;
                double[] data = ShapeData.decodeData(st, k >= 2 ? 6 : 4, scaleW, scaleH);
                RectangularShape sh = null;
                switch (k) {
                    case 0: {
                        sh = new Rectangle2D.Double(data[0], data[1], data[2], data[3]);
                        break;
                    }
                    case 1: {
                        sh = new Ellipse2D.Double(data[0], data[1], data[2], data[3]);
                        break;
                    }
                    case 2: {
                        sh = new RoundRectangle2D.Double(data[0], data[1], data[2], data[3], data[4], data[5]);
                        break;
                    }
                    case 3: {
                        sh = new Arc2D.Double(data[0], data[1], data[2], data[3], data[4] * scaleW, data[5] * scaleH, 2);
                        break;
                    }
                    default: {
                        throw new Exception("unknown primitive shape!");
                    }
                }
                if (sh == null) continue;
                return ShapeData.getShapeData(sh, sd.comment);
            }
            if (s.equals(MOVE_TO)) {
                sd.addDescriptor(0);
                sd.addData(ShapeData.decodeData(st, 2, scaleW, scaleH));
                continue;
            }
            if (s.equals(LINE_TO)) {
                sd.addDescriptor(1);
                sd.addData(ShapeData.decodeData(st, 2, scaleW, scaleH));
                continue;
            }
            if (s.equals(QUAD_TO)) {
                sd.addDescriptor(2);
                sd.addData(ShapeData.decodeData(st, 4, scaleW, scaleH));
                continue;
            }
            if (s.equals(CUBIC_TO)) {
                sd.addDescriptor(3);
                sd.addData(ShapeData.decodeData(st, 6, scaleW, scaleH));
                continue;
            }
            if (s.equals(CLOSE)) {
                sd.addDescriptor(4);
                continue;
            }
            throw new IllegalArgumentException("Unknown ShapeData type: " + s);
        }
        return sd;
    }

    private void writeToSb(StringBuilder sb, String type, double[] values, int j, int k, double scaleW, double scaleH) {
        sb.append(type);
        if (k > 0) {
            if (DF == null) {
                DF = new DecimalFormat("0.0#####");
                DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                dfs.setDecimalSeparator('.');
                DF.setDecimalFormatSymbols(dfs);
            }
            sb.append(DELIM_CHAR[1]);
            for (int w = 0; w < k; ++w) {
                String s;
                if ((s = DF.format(values[j++] * ((j & 1) != 0 ? scaleW : scaleH))).endsWith(".0")) {
                    s = s.substring(0, s.length() - 2);
                }
                if (w > 0) {
                    sb.append(DELIM_CHAR[2]);
                }
                sb.append(s);
            }
        }
    }

    private void addDescriptor(int descriptor) {
        if (this.descriptorsIndex + 1 >= this.descriptors.length) {
            int[] d2 = new int[this.descriptors.length + 6];
            System.arraycopy(this.descriptors, 0, d2, 0, this.descriptorsIndex);
            this.descriptors = d2;
        }
        this.descriptors[this.descriptorsIndex++] = descriptor;
    }

    private void addData(double[] data) {
        if (data == null) {
            return;
        }
        if (this.pointsIndex + data.length >= this.points.length) {
            double[] d2 = new double[this.points.length + 12];
            System.arraycopy(this.points, 0, d2, 0, this.pointsIndex);
            this.points = d2;
        }
        for (double d : data) {
            this.points[this.pointsIndex++] = d;
        }
    }

    private static double[] decodeData(StringTokenizer st, int count, double scaleW, double scaleH) throws Exception {
        double[] data = new double[count];
        for (int i = 0; i < count; ++i) {
            data[i] = Double.parseDouble(st.nextToken()) / ((i & 1) == 0 ? scaleW : scaleH);
        }
        return data;
    }

    protected void add(int descriptor, double[] data) {
        this.addDescriptor(descriptor);
        if (data != null) {
            this.addData(data);
        }
    }

    public void moveTo(double x, double y) {
        this.add(0, new double[]{x, y});
    }

    public void lineTo(double x, double y) {
        this.add(1, new double[]{x, y});
    }

    public void quadTo(double x0, double y0, double x1, double y1) {
        this.add(2, new double[]{x0, y0, x1, y1});
    }

    public void cubicTo(double x0, double y0, double x1, double y1, double x2, double y2) {
        this.add(3, new double[]{x0, y0, x1, y1, x2, y2});
    }

    public void closePath() {
        this.add(4, null);
    }

    public void setWindingRule(int setRule) {
        this.windingRule = setRule;
    }

    public void scaleTo(double scaleX, double scaleY) {
        int i;
        if (this.points != null) {
            for (i = 0; i < this.points.length; i += 2) {
                int n = i;
                this.points[n] = this.points[n] / scaleX;
                int n2 = i + 1;
                this.points[n2] = this.points[n2] / scaleY;
            }
        }
        if (this.primitivePoints != null) {
            for (i = 0; i < this.primitivePoints.length; i += 2) {
                int n = i;
                this.primitivePoints[n] = this.primitivePoints[n] / scaleX;
                int n3 = i + 1;
                this.primitivePoints[n3] = this.primitivePoints[n3] / scaleY;
            }
        }
    }

    public Shape getShape(Rectangle2D rect) {
        return this.getShape(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public Shape getShape(double dx, double dy, double scaleX, double scaleY) {
        GeneralPath gp = new GeneralPath(this.windingRule, this.pointsIndex + 1);
        int j = 0;
        block6: for (int i = 0; i < this.descriptorsIndex; ++i) {
            switch (this.descriptors[i]) {
                case 0: {
                    gp.moveTo((float)(dx + scaleX * this.points[j++]), (float)(dy + scaleY * this.points[j++]));
                    continue block6;
                }
                case 1: {
                    gp.lineTo((float)(dx + scaleX * this.points[j++]), (float)(dy + scaleY * this.points[j++]));
                    continue block6;
                }
                case 2: {
                    gp.quadTo((float)(dx + scaleX * this.points[j++]), (float)(dy + scaleY * this.points[j++]), (float)(dx + scaleX * this.points[j++]), (float)(dy + scaleY * this.points[j++]));
                    continue block6;
                }
                case 3: {
                    gp.curveTo((float)(dx + scaleX * this.points[j++]), (float)(dy + scaleY * this.points[j++]), (float)(dx + scaleX * this.points[j++]), (float)(dy + scaleY * this.points[j++]), (float)(dx + scaleX * this.points[j++]), (float)(dy + scaleY * this.points[j++]));
                    continue block6;
                }
                default: {
                    gp.closePath();
                }
            }
        }
        return gp;
    }

    public static ShapeData getShapeData(Shape sh, String comment) {
        return ShapeData.getShapeData(sh, comment, true);
    }

    public static ShapeData getShapeData(Shape sh, String comment, boolean closeTo) {
        ShapeData sd = new ShapeData();
        sd.comment = comment;
        if (sh instanceof RectangularShape) {
            Arc2D ar;
            RectangularShape rs = (RectangularShape)sh;
            if (sh instanceof Rectangle2D) {
                sd.primitiveType = 0;
                sd.primitivePoints = new double[]{rs.getX(), rs.getY(), rs.getWidth(), rs.getHeight()};
            } else if (sh instanceof Ellipse2D) {
                sd.primitiveType = 1;
                sd.primitivePoints = new double[]{rs.getX(), rs.getY(), rs.getWidth(), rs.getHeight()};
            } else if (sh instanceof RoundRectangle2D) {
                sd.primitiveType = 2;
                RoundRectangle2D rr = (RoundRectangle2D)sh;
                sd.primitivePoints = new double[]{rs.getX(), rs.getY(), rs.getWidth(), rs.getHeight(), rr.getArcWidth(), rr.getArcHeight()};
            } else if (sh instanceof Arc2D && (ar = (Arc2D)sh).getArcType() == 2) {
                sd.primitiveType = 3;
                sd.primitivePoints = new double[]{rs.getX(), rs.getY(), rs.getWidth(), rs.getHeight(), ar.getAngleStart(), ar.getAngleExtent()};
            }
        }
        PathIterator it = sh.getPathIterator(null);
        double[] data = new double[6];
        sd.setWindingRule(it.getWindingRule());
        while (!it.isDone()) {
            switch (it.currentSegment(data)) {
                case 0: {
                    sd.moveTo(data[0], data[1]);
                    break;
                }
                case 1: {
                    sd.lineTo(data[0], data[1]);
                    break;
                }
                case 2: {
                    sd.quadTo(data[0], data[1], data[2], data[3]);
                    break;
                }
                case 3: {
                    sd.cubicTo(data[0], data[1], data[2], data[3], data[4], data[5]);
                    break;
                }
                case 4: {
                    if (!closeTo) break;
                    sd.closePath();
                    break;
                }
                default: {
                    System.err.println("ShapeData error: Unknown PathIterator!");
                }
            }
            it.next();
        }
        return sd;
    }

    public Object clone() throws CloneNotSupportedException {
        ShapeData sd = (ShapeData)super.clone();
        if (this.points != null) {
            sd.points = (double[])this.points.clone();
        }
        if (this.descriptors != null) {
            sd.descriptors = (int[])this.descriptors.clone();
        }
        if (this.primitivePoints != null) {
            sd.primitivePoints = (double[])this.primitivePoints.clone();
        }
        return sd;
    }
}

