/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.skins;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.Counter;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.skins.AboutWindow;
import edu.xtec.util.ExtendedJDialog;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ProgressInputStream;
import edu.xtec.util.ResourceManager;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdom.Element;

public abstract class Skin
extends JPanel
implements ProgressInputStream.ProgressInputStreamListener {
    public static final int DEFAULT_PROGRESS_WAKE_ON = 1000;
    public static final String RESOURCE_FOLDER = "skins";
    public static final String RESOURCE_LIST_FILE = "listskins.properties";
    public static final int MAIN = 0;
    public static final int AUX = 1;
    public static final int MEM = 2;
    public static final int NUM_MSG_AREAS = 3;
    public static final String[] msgAreaNames = new String[]{"main", "aux", "mem"};
    public String name = null;
    public String fileName = null;
    protected AbstractButton[] buttons = new AbstractButton[8];
    protected Counter[] counters = new Counter[3];
    protected ActiveBox[] msgArea = new ActiveBox[3];
    protected Component player;
    protected PlayStation ps;
    protected ActiveBox msgBox;
    long mem;
    private static int waitCursorCount;
    protected boolean readyToPaint;
    public JDialog currentHelpWindow;
    public JDialog currentAboutWindow;
    protected int progressMax;
    protected int progress;
    protected boolean hasProgress;
    protected boolean progressActive;
    protected long progressStartTime = 0L;
    protected static HashSet<Skin> skinStack;
    public static final String ELEMENT_NAME = "skin";
    public static final String INTERNAL_SKIN_PREFIX = "@";
    public static final String NAME = "name";

    protected Skin() {
        this.setEnabled(false);
        this.readyToPaint = false;
        this.setLayout(null);
        this.player = null;
        this.ps = null;
        this.currentHelpWindow = null;
        this.currentAboutWindow = null;
        this.progress = 0;
        this.progressMax = 100;
        this.progressActive = false;
        this.hasProgress = false;
        skinStack.add(this);
        this.enableEvents(16L);
    }

    public void emptySkinStack() {
        skinStack = new HashSet();
    }

    public void attach(Component setPlayer) {
        if (this.player != null) {
            this.detach();
        }
        this.player = setPlayer;
        this.add(this.player);
        this.setWaitCursor();
        this.setEnabled(true);
        this.revalidate();
    }

    public void detach() {
        if (this.player != null) {
            this.remove(this.player);
            this.player = null;
        }
        if (this.currentHelpWindow != null) {
            this.currentHelpWindow.setVisible(false);
        }
        if (this.currentAboutWindow != null) {
            this.currentAboutWindow.setVisible(false);
        }
        this.setEnabled(false);
    }

    public static Skin getSkin(String skinName, FileSystem fs, PlayStation ps) throws Exception {
        Element e;
        for (Skin s : skinStack) {
            if (s == null || !skinName.equals(s.fileName) || !ps.equals(s.ps)) continue;
            return s;
        }
        if (skinName.startsWith(INTERNAL_SKIN_PREFIX)) {
            e = FileSystem.getXMLDocument(ResourceManager.getResourceAsStream("skins/" + skinName.substring(INTERNAL_SKIN_PREFIX.length()))).getRootElement();
            fs = null;
        } else {
            e = fs.getXMLDocument(skinName).getRootElement();
        }
        JDomUtility.checkName(e, ELEMENT_NAME);
        Class<?> skinClass = Class.forName(JDomUtility.getClassName(e));
        Skin sk = (Skin)skinClass.newInstance();
        sk.name = e.getAttributeValue(NAME);
        sk.fileName = skinName;
        sk.ps = ps;
        sk.setProperties(e, fs);
        return sk;
    }

    protected abstract void setProperties(Element var1, FileSystem var2) throws Exception;

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints rh = g2.getRenderingHints();
        if (this.player != null) {
            g2.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
        }
        this.render(g2, g2.getClipBounds());
        if (rh != null) {
            g2.setRenderingHints(rh);
        }
    }

    public abstract void render(Graphics2D var1, Rectangle var2);

    @Override
    protected void processEvent(AWTEvent e) {
        if (this.ps != null && e instanceof MouseEvent && e.getID() == 500) {
            Iterator<ActiveBox> it = this.getActiveBoxes();
            while (it.hasNext()) {
                ActiveBox ab = it.next();
                if (!ab.contains(((MouseEvent)e).getPoint()) || ab.getContent().mediaContent == null) continue;
                this.ps.stopMedia(ab.getContent().mediaContent.level);
                ab.playMedia(this.ps);
            }
        }
        super.processEvent(e);
    }

    protected Iterator<ActiveBox> getActiveBoxes() {
        ArrayList<ActiveBox> v = new ArrayList<ActiveBox>();
        if (this.msgBox != null) {
            v.add(this.msgBox);
        }
        return v.iterator();
    }

    @Override
    public void setProgressMax(int max) {
        this.progressMax = max;
    }

    @Override
    public void setProgressValue(int value) {
        this.progress = value;
    }

    public void setProgressName(String name) {
        this.setSystemMessage(null, name == null ? null : this.ps.getMsg("LOADING_FILE") + " " + FileSystem.getFileNameOf(name));
    }

    @Override
    public void startProgress(String name) {
        this.progressStartTime = System.currentTimeMillis();
        this.setProgressValue(0);
        this.progressActive = true;
    }

    @Override
    public void endProgress() {
        this.progressActive = false;
    }

    public InputStream getProgressInputStream(InputStream is, int expectedLength, String fName) {
        InputStream result;
        if (this.hasProgress && !this.progressActive) {
            ProgressInputStream pi = new ProgressInputStream(is, expectedLength, fName);
            pi.addProgressInputStreamListener(this);
            result = pi;
        } else {
            result = is;
        }
        return result;
    }

    public ActiveBox getMsgBox() {
        return this.msgBox;
    }

    public Counter getCounter(int counterId) {
        return counterId < 0 || counterId >= 3 ? null : this.counters[counterId];
    }

    public void enableCounter(int counterId, boolean bEnabled) {
        Counter counter = this.getCounter(counterId);
        if (counter != null) {
            counter.setEnabled(bEnabled);
        }
    }

    public void resetAllCounters(boolean bEnabled) {
        for (int i = 0; i < 3; ++i) {
            if (this.counters[i] == null) continue;
            this.counters[i].setValue(0);
            this.counters[i].setCountDown(0);
            this.counters[i].setEnabled(bEnabled);
        }
    }

    public AbstractButton getButton(int buttonId) {
        return buttonId < 0 || buttonId >= 8 ? null : this.buttons[buttonId];
    }

    public Object[] getCurrentSettings() {
        Object[] settings = new Object[]{this.buttons, this.msgBox, this.counters, new Integer(waitCursorCount)};
        return settings;
    }

    public void setCurrentSettings(Object[] settings) {
        int i;
        if (settings.length > 0 && settings[0] != null) {
            AbstractButton[] buttonSettings = (AbstractButton[])settings[0];
            for (i = 0; i < 8; ++i) {
                if (i >= buttonSettings.length || buttonSettings[i] == null || this.buttons[i] == null) continue;
                this.buttons[i].setVisible(buttonSettings[i].isVisible());
            }
        }
        if (settings.length > 1 && settings[1] != null && this.msgBox != null) {
            ActiveBox abSettings = (ActiveBox)settings[1];
            this.msgBox.copyContent(abSettings);
            this.msgBox.setBoxBase(abSettings.getBoxBaseResolve());
        }
        if (settings.length > 2 && settings[2] != null && this.counters != null) {
            Counter[] counterSettings = (Counter[])settings[2];
            for (i = 0; i < 3; ++i) {
                if (i >= counterSettings.length || counterSettings[i] == null || this.counters[i] == null) continue;
                this.counters[i].setEnabled(counterSettings[i].isEnabled());
                this.counters[i].setValue(counterSettings[i].getValue());
            }
        }
        if (settings.length > 3 && settings[3] != null) {
            waitCursorCount = (Integer)settings[3];
            this.setWaitCursor();
        }
    }

    protected void drawSlicedFrame(Graphics g, Rectangle dest, Rectangle source, Image img, int leftSlicer, int rightSlicer, int topSlicer, int bottomSlicer) {
        Rectangle rs = new Rectangle();
        Rectangle rd = new Rectangle();
        rs.setBounds(source.x, source.y, leftSlicer, topSlicer);
        rd.setBounds(dest.x, dest.y, rs.width, rs.height);
        Utils.drawImage(g, img, rd, rs, this);
        rs.x += leftSlicer;
        rs.width = rightSlicer - leftSlicer;
        rd.x += leftSlicer;
        rd.width = dest.width - leftSlicer - (source.width - rightSlicer);
        Utils.tileImage(g, img, rd, rs, this);
        rs.x = source.x + rightSlicer;
        rs.width = source.width - rightSlicer;
        rd.x = dest.x + dest.width - (source.width - rightSlicer);
        rd.width = rs.width;
        Utils.drawImage(g, img, rd, rs, this);
        rs.setBounds(source.x, source.y + topSlicer, leftSlicer, bottomSlicer - topSlicer);
        rd.setBounds(dest.x, dest.y + topSlicer, leftSlicer, dest.height - topSlicer - (source.height - bottomSlicer));
        Utils.tileImage(g, img, rd, rs, this);
        rs.x += leftSlicer;
        rs.width = rightSlicer - leftSlicer;
        rd.x += leftSlicer;
        rd.width = dest.width - leftSlicer - (source.width - rightSlicer);
        Utils.tileImage(g, img, rd, rs, this);
        rs.x = source.x + rightSlicer;
        rs.width = source.width - rightSlicer;
        rd.x = dest.x + dest.width - (source.width - rightSlicer);
        rd.width = rs.width;
        Utils.tileImage(g, img, rd, rs, this);
        rs.setBounds(source.x, source.y + bottomSlicer, leftSlicer, source.height - bottomSlicer);
        rd.setBounds(dest.x, dest.y + dest.height - (source.height - bottomSlicer), rs.width, rs.height);
        Utils.drawImage(g, img, rd, rs, this);
        rs.x += leftSlicer;
        rs.width = rightSlicer - leftSlicer;
        rd.x += leftSlicer;
        rd.width = dest.width - leftSlicer - (source.width - rightSlicer);
        Utils.tileImage(g, img, rd, rs, this);
        rs.x = source.x + rightSlicer;
        rs.width = source.width - rightSlicer;
        rd.x = dest.x + dest.width - (source.width - rightSlicer);
        rd.width = rs.width;
        Utils.drawImage(g, img, rd, rs, this);
    }

    public boolean hasMemMonitor() {
        return this.msgArea[2] != null;
    }

    public void setMem(long newMem) {
        this.mem = newMem;
        if (this.msgArea[2] != null) {
            String s = new StringBuilder(Long.toString(this.mem / 1000L)).append(" Kb").substring(0);
            this.msgArea[2].setTextContent(s);
        }
    }

    public void setSystemMessage(String msg1, String msg2) {
        if (!this.isVisible()) {
            return;
        }
        if (this.msgArea[0] != null && msg1 != null) {
            this.msgArea[0].setTextContent(msg1);
        }
        if (this.msgArea[1] != null) {
            this.msgArea[1].setTextContent(msg2 == null ? "" : msg2);
        }
    }

    public void startAnimation() {
    }

    public void stopAnimation() {
    }

    public void setWaitCursor(boolean status) {
        if (status) {
            ++waitCursorCount;
        } else if (--waitCursorCount < 0) {
            waitCursorCount = 0;
        }
        this.setWaitCursor();
    }

    public void setWaitCursor() {
        this.setCursor(waitCursorCount > 0 ? Cursor.getPredefinedCursor(3) : null);
    }

    public void showHelp(JComponent solution, String msg) {
        this.currentHelpWindow = new HelpWindow(this, solution, msg);
        this.currentHelpWindow.setVisible(true);
        this.currentHelpWindow = null;
        this.requestFocus();
    }

    public AboutWindow buildAboutWindow() {
        return new AboutWindow((Component)this, this.ps, new Dimension(500, 400));
    }

    public void showAboutWindow(AboutWindow aw) {
        this.currentAboutWindow = aw;
        this.currentAboutWindow.setVisible(true);
        this.currentAboutWindow = null;
        this.requestFocus();
    }

    @Override
    public void requestFocus() {
        if (this.player != null) {
            this.player.requestFocus();
        }
    }

    public static String[] getSystemSkinList(boolean withEmptyEntry) {
        ArrayList<String> v = new ArrayList<String>();
        Properties prop = new Properties();
        try {
            prop.load(ResourceManager.getResourceAsStream("skins/listskins.properties"));
        }
        catch (Exception e) {
            System.err.println("Unable to open /edu/xtec/resources/skins/listskins.properties:\n" + e);
        }
        if (withEmptyEntry) {
            v.add("");
        }
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = INTERNAL_SKIN_PREFIX + prop.getProperty(key).trim();
            v.add(value);
        }
        if (v.size() > 0) {
            return v.toArray(new String[v.size()]);
        }
        return new String[0];
    }

    static {
        skinStack = new HashSet();
    }

    class HelpWindow
    extends ExtendedJDialog {
        HelpWindow(Component parent, JComponent solution, String msg) {
            super(parent, Skin.this.ps.getMsg("help_window_caption"), true);
            this.getContentPane().setLayout(new BorderLayout());
            if (solution != null) {
                this.getContentPane().add((Component)solution, "Center");
            } else {
                JLabel lb = new JLabel(msg == null || msg.trim().length() == 0 ? "?" : msg.trim());
                this.getContentPane().add((Component)lb, "North");
            }
            JButton btClose = new JButton(Skin.this.ps.getMsg("help_window_close_button"), ResourceManager.getImageIcon("icons/exit_small.gif"));
            btClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HelpWindow.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)btClose, "South");
            this.pack();
            Point p = null;
            if (solution != null && (p = (Point)solution.getClientProperty("prefLoc")) != null) {
                p = new Point(p);
                int dx = (this.getWidth() - this.getContentPane().getWidth()) / 2;
                int dy = this.getHeight() - this.getContentPane().getHeight() - dx;
                p.translate(-dx, -dy);
            }
            if (p == null) {
                p = parent.getLocationOnScreen();
            }
            this.setLocation(p);
        }
    }
}

