/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.FontCheck;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class JDomUtility {
    private static SAXBuilder saxBuilder;
    private static XMLOutputter outputter;
    public static final String ID = "id";
    public static final String IMAGE = "image";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String BGCOLOR = "bgcolor";
    public static final String FORECOLOR = "forecolor";
    public static final String MARGIN = "margin";
    public static final String BORDER = "border";
    public static final String POSITION = "position";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String P = "p";
    public static final String CLASS = "class";
    public static final String FONT = "font";
    private static final String FAMILY = "family";
    private static final String SIZE = "size";
    private static final String BOLD = "bold";
    private static final String ITALIC = "italic";
    public static final String[] HTML_COLOR_NAMES;
    public static final Color[] HTML_COLORS;
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String UP = "up";
    public static final String DOWN = "down";
    public static final String RECTANGLE = "rectangle";
    public static final String POINT = "point";
    public static final String DIMENSION = "dimension";
    public static final String OFFSET = "offset";
    public static final String COLOR = "color";
    public static final String VALUE = "value";
    public static final String DIRECTION = "direction";
    public static final int DIRECTION_UP = 0;
    public static final int DIRECTION_DOWN = 1;
    public static final int DIRECTION_LEFT = 2;
    public static final int DIRECTION_RIGHT = 3;
    public static final String[] directionName;
    public static final String ALIGNMENT = "alignment";
    public static final String HALIGN = "hAlign";
    public static final String VALIGN = "vAlign";
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_MIDDLE = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_BOTTOM = 2;
    public static final String[] hAlignName;
    public static final String[] vAlignName;
    public static final int[] DEFAULT_ALIGNMENT;
    public static final String[] BOOL_STR;
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final int DEFAULT = 2;
    private static final int rare = -18634527;
    public static final String NEWLINE = "\n";
    public static final String BLANK = "";

    private JDomUtility() {
    }

    public static boolean addGenericAttribute(Element e, String key, Object v) {
        if (v == null) {
            return false;
        }
        Class<Object> cl = v.getClass();
        if (e.getAttribute(key) != null) {
            return false;
        }
        if (cl.isArray()) {
            return false;
        }
        if (cl.isAssignableFrom(String.class) || cl.isAssignableFrom(Integer.class) || cl.isAssignableFrom(Float.class) || cl.isAssignableFrom(Double.class) || cl.isAssignableFrom(Boolean.class)) {
            e.setAttribute(key, v.toString());
        } else if (cl.isAssignableFrom(Color.class)) {
            e.setAttribute(key, JDomUtility.colorToString((Color)v));
        } else {
            return false;
        }
        return true;
    }

    public static Element fontToElement(Font font) {
        Element e = new Element(FONT);
        e.setAttribute(FAMILY, font.getFamily());
        e.setAttribute(SIZE, Integer.toString(font.getSize()));
        if (font.isBold()) {
            e.setAttribute(BOLD, JDomUtility.boolString(font.isBold()));
        }
        if (font.isItalic()) {
            e.setAttribute(ITALIC, JDomUtility.boolString(font.isItalic()));
        }
        return e;
    }

    public static Font elementToFont(Element e) throws Exception {
        JDomUtility.checkName(e, FONT);
        String family = JDomUtility.getStringAttr(e, FAMILY, "default", false);
        int size = JDomUtility.getIntAttr(e, SIZE, 12);
        int style = (JDomUtility.getBoolAttr(e, BOLD, false) ? 1 : 0) | (JDomUtility.getBoolAttr(e, ITALIC, false) ? 2 : 0);
        return FontCheck.getValidFont(family, style, size);
    }

    public static String colorToString(Color color) {
        String s = Long.toHexString(0x100000000L | (long)color.getRGB()).toUpperCase();
        s = s.substring(s.length() - (color.getAlpha() == 255 ? 6 : 8));
        return "0x" + s;
    }

    public static Color stringToColor(String s) throws Exception {
        Color color = null;
        if (s.startsWith("0x")) {
            long v = Long.decode(s);
            color = new Color((int)v, s.length() > 8 || v >= 0x1000000L);
        } else {
            for (int i = 0; i < HTML_COLOR_NAMES.length; ++i) {
                if (!HTML_COLOR_NAMES[i].equalsIgnoreCase(s)) continue;
                color = HTML_COLORS[i];
                break;
            }
        }
        if (color == null) {
            throw new Exception("Invalid color: " + s);
        }
        return color;
    }

    public static Color getColorAttr(Element e, String attr, Color defaultValue) throws Exception {
        String s = e.getAttributeValue(attr);
        return s == null ? defaultValue : JDomUtility.stringToColor(s);
    }

    public static Element getChildWithId(Element e, String name, String id) {
        if (e != null && id != null && name != null) {
            for (Element result : e.getChildren(name)) {
                if (!id.equals(result.getAttributeValue(ID))) continue;
                return result;
            }
        }
        return null;
    }

    public static Rectangle getRectangle(Element e, String id, Rectangle defaultValue) {
        if (id != null) {
            e = JDomUtility.getChildWithId(e, RECTANGLE, id);
        } else if (e != null && !e.getName().equals(RECTANGLE)) {
            e = e.getChild(RECTANGLE);
        }
        if (e == null) {
            return defaultValue;
        }
        Rectangle r = defaultValue == null ? new Rectangle() : new Rectangle(defaultValue);
        r.setBounds(JDomUtility.getIntAttr(e, LEFT, r.x), JDomUtility.getIntAttr(e, TOP, r.y), JDomUtility.getIntAttr(e, WIDTH, r.width), JDomUtility.getIntAttr(e, HEIGHT, r.height));
        return r;
    }

    public static Point getPoint(Element e, String id, Point defaultValue) {
        if (id != null) {
            e = JDomUtility.getChildWithId(e, POINT, id);
        } else if (e != null && !e.getName().equals(POINT)) {
            e = e.getChild(POINT);
        }
        if (e == null) {
            return defaultValue;
        }
        Point p = defaultValue == null ? new Point() : new Point(defaultValue);
        p.setLocation(JDomUtility.getIntAttr(e, LEFT, p.x), JDomUtility.getIntAttr(e, TOP, p.y));
        return p;
    }

    public static Dimension getDimension(Element e, String id, Dimension defaultValue) {
        if (id != null) {
            e = JDomUtility.getChildWithId(e, DIMENSION, id);
        } else if (e != null && !e.getName().equals(DIMENSION)) {
            e = e.getChild(DIMENSION);
        }
        if (e == null) {
            return defaultValue;
        }
        Dimension d = defaultValue == null ? new Dimension() : new Dimension(defaultValue);
        d.setSize(JDomUtility.getIntAttr(e, WIDTH, d.width), JDomUtility.getIntAttr(e, HEIGHT, d.height));
        return d;
    }

    public static Point getOffset(Element e, String id, Point defaultValue) {
        if (id != null) {
            e = JDomUtility.getChildWithId(e, OFFSET, id);
        } else if (e != null && !e.getName().equals(OFFSET)) {
            e = e.getChild(OFFSET);
        }
        if (e == null) {
            return defaultValue;
        }
        Point p = defaultValue == null ? new Point() : new Point(defaultValue);
        p.setLocation(JDomUtility.getIntAttr(e, RIGHT, p.x), JDomUtility.getIntAttr(e, DOWN, p.y));
        return p;
    }

    public static Color getColorByPoint(Element e, String id, BufferedImage img, Color defaultValue) throws Exception {
        Element child;
        if (id != null) {
            e = JDomUtility.getChildWithId(e, COLOR, id);
        } else if (e != null && !e.getName().equals(COLOR)) {
            e = e.getChild(COLOR);
        }
        if (e == null) {
            return defaultValue;
        }
        Color result = JDomUtility.getColorAttr(e, VALUE, defaultValue);
        if (img != null && (child = e.getChild(POINT)) != null) {
            Point pt = JDomUtility.getPoint(child, null, new Point());
            result = new Color(img.getRGB(pt.x, pt.y));
        }
        return result;
    }

    public static int getDirection(Element e, int defaultValue) throws Exception {
        if (e == null) {
            return defaultValue;
        }
        return JDomUtility.getStrIndexAttr(e, DIRECTION, directionName, defaultValue);
    }

    public static int getHAlign(Element e, int defaultValue) throws Exception {
        if (e == null) {
            return defaultValue;
        }
        return JDomUtility.getStrIndexAttr(e, HALIGN, hAlignName, defaultValue);
    }

    public static int getVAlign(Element e, int defaultValue) throws Exception {
        if (e == null) {
            return defaultValue;
        }
        return JDomUtility.getStrIndexAttr(e, VALIGN, vAlignName, defaultValue);
    }

    public static int[] getAlignment(Element e, String id, int[] defaultValue) throws Exception {
        if (defaultValue == null) {
            defaultValue = DEFAULT_ALIGNMENT;
        }
        if (id != null) {
            e = JDomUtility.getChildWithId(e, ALIGNMENT, id);
        } else if (e != null && !e.getName().equals(ALIGNMENT)) {
            e = e.getChild(ALIGNMENT);
        }
        if (e == null) {
            return defaultValue;
        }
        int[] al = new int[]{JDomUtility.getHAlign(e, defaultValue == null ? defaultValue[0] : 1), JDomUtility.getVAlign(e, defaultValue == null ? defaultValue[1] : 1)};
        return al;
    }

    public static int[] getAlignProp(Element e, String id, int[] defaultValue) throws Exception {
        String s;
        int[] result = new int[2];
        if (defaultValue == null) {
            defaultValue = DEFAULT_ALIGNMENT;
        }
        result[0] = defaultValue[0];
        result[1] = defaultValue[1];
        if (id != null && (s = e.getAttributeValue(id)) != null && s.length() > 0) {
            StringTokenizer st = new StringTokenizer(s, ",");
            if (st.hasMoreTokens()) {
                result[0] = JDomUtility.getStrIndexAttr(st.nextToken(), hAlignName, defaultValue[0]);
            }
            if (st.hasMoreTokens()) {
                result[1] = JDomUtility.getStrIndexAttr(st.nextToken(), vAlignName, defaultValue[1]);
            }
        }
        return result;
    }

    public static void setAlignProp(Element e, String id, int[] align, boolean omitIfDefault) {
        if (!(e == null || id == null || align == null || align.length != 2 || omitIfDefault && JDomUtility.isDefaultAlign(align))) {
            e.setAttribute(id, hAlignName[align[0]] + "," + vAlignName[align[1]]);
        }
    }

    public static boolean isDefaultAlign(int[] align) {
        return align != null && align[0] == 1 && align[1] == 1;
    }

    public static void addParagraphs(Element parent, String childName, String text) {
        if (text != null) {
            Element child = new Element(childName);
            JDomUtility.setParagraphs(child, text);
            parent.addContent(child);
        }
    }

    public static void setParagraphs(Element e, String text) {
        if (text != null) {
            StringTokenizer st = new StringTokenizer(text, NEWLINE);
            while (st.hasMoreTokens()) {
                e.addContent(new Element(P).setText(st.nextToken()));
            }
        }
    }

    public static String getParagraphs(Element e) {
        StringBuilder sb = null;
        if (e != null) {
            Iterator itr = e.getChildren(P).iterator();
            while (itr.hasNext()) {
                String s = ((Element)itr.next()).getText();
                if (sb == null) {
                    sb = new StringBuilder(s);
                    continue;
                }
                sb.append(NEWLINE).append(s);
            }
        }
        return sb == null ? null : sb.substring(0);
    }

    public static String intArrayToString(int[] v) {
        return JDomUtility.intArrayToString(v, v.length);
    }

    public static String intArrayToString(int[] v, int numElements) {
        StringBuilder sb = new StringBuilder(numElements * 4);
        for (int i = 0; i < numElements; ++i) {
            sb.append(v[i]).append(' ');
        }
        return sb.substring(0).trim();
    }

    public static int[] stringToIntArray(String s) throws Exception {
        StringTokenizer st = new StringTokenizer(s, " ");
        int numTokens = st.countTokens();
        int[] result = new int[numTokens];
        for (int i = 0; i < numTokens; ++i) {
            result[i] = Integer.parseInt(st.nextToken());
        }
        return result;
    }

    public static int getIntAttr(Element e, String attr, int defaultValue) {
        String s = e.getAttributeValue(attr);
        int result = defaultValue;
        if (s != null) {
            result = Integer.parseInt(s);
        }
        return result;
    }

    public static long getLongAttr(Element e, String attr, long defaultValue) {
        String s = e.getAttributeValue(attr);
        long result = defaultValue;
        if (s != null) {
            result = Long.parseLong(s);
        }
        return result;
    }

    public static String triStateString(int state) {
        if (state < 0 || state >= 2) {
            state = 2;
        }
        return BOOL_STR[state];
    }

    public static int getTriStateAttr(Element e, String attr, int defaultValue) throws Exception {
        return JDomUtility.getStrIndexAttr(e, attr, BOOL_STR, defaultValue);
    }

    public static boolean checkTriState(int v) {
        return v >= 0 && v <= 2;
    }

    public static String boolString(boolean value) {
        return BOOL_STR[value ? 1 : 0];
    }

    public static boolean getBoolAttr(Element e, String attr, boolean defaultValue) {
        String s = e.getAttributeValue(attr);
        boolean result = defaultValue;
        if (s != null) {
            if (s.equalsIgnoreCase(BOOL_STR[1])) {
                result = true;
            } else if (s.equalsIgnoreCase(BOOL_STR[0])) {
                result = false;
            } else {
                throw new NumberFormatException("invalid boolean: " + s);
            }
        }
        return result;
    }

    public static Boolean getBooleanAttr(Element e, String attr, Boolean defaultValue) {
        String s = e.getAttributeValue(attr);
        Boolean result = defaultValue;
        if (s != null) {
            if (s.equalsIgnoreCase(BOOL_STR[1]) || s.equalsIgnoreCase(BOOL_STR[0])) {
                result = Boolean.valueOf(s);
            } else {
                throw new NumberFormatException("invalid boolean: " + s);
            }
        }
        return result;
    }

    public static float getFloatAttr(Element e, String attr, float defaultValue) {
        String s = e.getAttributeValue(attr);
        float result = defaultValue;
        if (s != null) {
            result = Float.parseFloat(s);
        }
        return result;
    }

    public static double getDoubleAttr(Element e, String attr, double defaultValue) {
        String s = e.getAttributeValue(attr);
        double result = defaultValue;
        if (s != null) {
            result = Double.parseDouble(s);
        }
        return result;
    }

    public static String getStringAttr(Element e, String attr, String defaultValue, boolean allowEmpty) {
        String s = e.getAttributeValue(attr);
        String result = defaultValue;
        if (s != null && (allowEmpty || s.length() > 0)) {
            result = s;
        }
        return result;
    }

    public static void setStringAttr(Element e, String key, String value, boolean allowEmpty) {
        String v;
        String string = v = allowEmpty && (value == null || value.length() == 0) ? BLANK : value;
        if (key != null && v != null) {
            e.setAttribute(key, v);
        }
    }

    public static int getStrIndexAttr(Element e, String attr, String[] values, int defaultValue) throws Exception {
        return JDomUtility.getStrIndexAttr(e.getAttributeValue(attr), values, defaultValue);
    }

    public static int getStrIndexAttr(String s, String[] values, int defaultValue) throws Exception {
        int result = defaultValue;
        if (s != null && s.length() > 0) {
            for (result = 0; result < values.length && !s.equalsIgnoreCase(values[result]); ++result) {
            }
            if (result == values.length) {
                throw new Exception("Unknown value: " + s);
            }
        }
        return result;
    }

    public static Dimension getDimensionAttr(Element e, String atrW, String atrH, Dimension defaultValue) {
        Dimension result = defaultValue;
        int w = JDomUtility.getIntAttr(e, atrW, -18634527);
        int h = JDomUtility.getIntAttr(e, atrH, -18634527);
        if (w != -18634527 && h != -18634527) {
            result = new Dimension(w, h);
        }
        return result;
    }

    public static Point getPointAttr(Element e, String atrX, String atrY, Point defaultValue) {
        Point result = defaultValue;
        int x = JDomUtility.getIntAttr(e, atrX, -18634527);
        int y = JDomUtility.getIntAttr(e, atrY, -18634527);
        if (x != -18634527 && y != -18634527) {
            result = new Point(x, y);
        }
        return result;
    }

    public static String dateToStringShortUS(Date date) {
        return DateFormat.getDateInstance(3, Locale.US).format(date);
    }

    public static Date getDateAttrShortUS(Element e, String attr, Date defaultValue) throws Exception {
        Date result = defaultValue;
        String s = JDomUtility.getStringAttr(e, attr, null, false);
        if (s != null) {
            result = DateFormat.getDateInstance(3, Locale.US).parse(s);
        }
        return result;
    }

    public static void clearNewLineElements(Element e) {
        if (e != null) {
            ArrayList<Text> toRemove = null;
            boolean hasChildren = !e.getChildren().isEmpty();
            List content = e.getContent();
            for (Object e2 : content) {
                if (e2 instanceof Element) {
                    JDomUtility.clearNewLineElements((Element)e2);
                    continue;
                }
                if (!hasChildren || !(e2 instanceof Text)) continue;
                if (toRemove == null) {
                    toRemove = new ArrayList<Text>();
                }
                toRemove.add((Text)e2);
            }
            if (toRemove != null) {
                for (Text text : toRemove) {
                    content.remove(text);
                }
            }
        }
    }

    public static SAXBuilder getSAXBuilder() {
        if (saxBuilder == null) {
            saxBuilder = new SAXBuilder();
        }
        return saxBuilder;
    }

    public static void saveDocument(OutputStream out, Element rootElement) throws Exception {
        JDomUtility.saveDocument(out, new Document(rootElement));
    }

    public static void saveDocument(OutputStream out, Document doc) throws Exception {
        JDomUtility.getXMLOutputter().output(doc, out);
        out.flush();
    }

    public static XMLOutputter getXMLOutputter() {
        if (outputter == null) {
            Format format = Format.getPrettyFormat();
            format.setIndent(" ");
            format.setEncoding("UTF-8");
            format.setTextMode(Format.TextMode.PRESERVE);
            outputter = new XMLOutputter(format);
        }
        return outputter;
    }

    public static void checkName(Element e, String expectedName) throws Exception {
        if (e == null) {
            throw new JDOMException("Null element passed as argument, expecting: \"" + expectedName + "\"");
        }
        if (!e.getName().equals(expectedName)) {
            throw new JDOMException("Find element \"" + e.getName() + "\" while expecting \"" + expectedName + "\"");
        }
    }

    public static String getClassName(Element e) throws Exception {
        if (e == null) {
            throw new JDOMException("Element without class name!");
        }
        return e.getAttributeValue(CLASS);
    }

    static {
        HTML_COLOR_NAMES = new String[]{"Black", "Silver", "Gray", "White", "Maroon", "Red", "Purple", "Fuchsia", "Green", "Lime", "Olive", "Yellow", "Navy", "Blue", "Teal", "Aqua", "Pink", "Orange", "DarkGray"};
        HTML_COLORS = new Color[]{Color.black, Color.lightGray, Color.gray, Color.white, new Color(128, 0, 0), Color.red, new Color(128, 0, 128), Color.magenta, new Color(0, 128, 0), Color.green, new Color(128, 128, 0), Color.yellow, new Color(0, 0, 128), Color.blue, new Color(0, 128, 128), Color.cyan, Color.pink, Color.orange, Color.darkGray};
        directionName = new String[]{UP, DOWN, LEFT, RIGHT};
        hAlignName = new String[]{LEFT, "middle", RIGHT};
        vAlignName = new String[]{TOP, "middle", BOTTOM};
        DEFAULT_ALIGNMENT = new int[]{1, 1};
        BOOL_STR = new String[]{"false", "true", "default"};
    }
}

