/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.ExtendedJDialog;
import edu.xtec.util.Options;
import edu.xtec.util.ProgressInputStream;
import edu.xtec.util.SwingWorker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressDialog
extends ExtendedJDialog
implements ProgressInputStream.ProgressInputStreamListener {
    protected Options options = null;
    protected SwingWorker worker = null;
    protected boolean progressActive = false;
    protected boolean cancellable = false;
    protected boolean saving = false;
    private JButton cancelButton;
    private JLabel fileLabel;
    private JLabel label;
    private JPanel mainPanel;
    private JProgressBar progressBar;

    public ProgressDialog(JComponent parent, Options options) {
        super(parent, "", true);
        this.options = options;
        this.initComponents();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.label = new JLabel();
        this.fileLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.mainPanel.setLayout(new GridBagLayout());
        this.label.setText(" ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 5, 0, 5);
        this.mainPanel.add((Component)this.label, gridBagConstraints);
        this.fileLabel.setText(" ");
        this.fileLabel.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mainPanel.add((Component)this.fileLabel, gridBagConstraints);
        this.progressBar.setPreferredSize(new Dimension(250, 22));
        this.progressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.progressBar, gridBagConstraints);
        this.cancelButton.setText(this.options.getMsg("CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (this.cancellable && this.worker != null) {
            this.worker.cancel();
        }
    }

    public void start(String titleKey, String msgKey, SwingWorker worker, boolean showProgressBar, boolean cancellable, boolean saving) {
        this.worker = worker;
        this.cancellable = cancellable;
        this.saving = saving;
        this.setTitle(titleKey != null ? this.options.getMsg(titleKey) : "");
        this.label.setText(this.options.getMsg(msgKey != null ? msgKey : "WORKING"));
        this.cancelButton.setVisible(cancellable && worker != null);
        this.progressBar.setVisible(showProgressBar);
        this.setProgressValue(0);
        this.mainPanel.revalidate();
        this.pack();
        this.centerOver(this.getParent());
        if (worker != null) {
            worker.startLater();
        }
        this.setVisible(true);
    }

    public void setText(String txt) {
        this.label.setText(txt);
        this.mainPanel.revalidate();
    }

    public void setFileLabel(String txt) {
        this.fileLabel.setText(txt == null ? "" : txt);
    }

    @Override
    public void startProgress(String name) {
        this.setProgressValue(0);
        name = name == null ? "" : name.replace('\\', '/');
        int i = name.lastIndexOf(47);
        if (i > 0) {
            name = name.substring(i + 1);
        }
        this.fileLabel.setText(name == null ? "" : this.options.getMsg(this.saving ? "SAVING_FILE" : "LOADING_FILE") + " " + name);
        this.progressActive = true;
    }

    @Override
    public void endProgress() {
        this.progressActive = false;
    }

    @Override
    public void setProgressMax(int max) {
        this.progressBar.setMaximum(max);
    }

    @Override
    public void setProgressValue(int value) {
        this.progressBar.setValue(value);
    }

    public InputStream getProgressInputStream(InputStream is, int expectedLength, String name) {
        InputStream result;
        if (!this.progressActive) {
            ProgressInputStream pi = new ProgressInputStream(is, expectedLength, name);
            pi.addProgressInputStreamListener(this);
            result = pi;
        } else {
            result = is;
        }
        return result;
    }
}

