/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.applet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.sampled.convert.jorbis.JorbisFormatConversionProvider;
import org.tritonus.sampled.file.jorbis.JorbisAudioFileReader;

public class AppletVorbisSPIWorkaround {
    public static boolean DEBUG = false;
    public static String useragent = null;

    public static AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        try {
            return AudioSystem.getAudioInputStream(targetFormat, sourceStream);
        }
        catch (IllegalArgumentException iae) {
            if (DEBUG) {
                System.err.println("Using AppletVorbisSPIWorkaround to get codec");
            }
            try {
                Class.forName("org.tritonus.sampled.convert.jorbis.JorbisFormatConversionProvider");
                return new JorbisFormatConversionProvider().getAudioInputStream(targetFormat, sourceStream);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("Vorbis codec not properly installed");
            }
        }
    }

    public static AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            if (DEBUG) {
                System.err.println("Using AppletVorbisSPIWorkaround to get codec (AudioFileFormat:file)");
            }
            AudioFileFormat audioFileFormat = AppletVorbisSPIWorkaround.getAudioFileFormat(inputStream);
            return audioFileFormat;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            if (DEBUG) {
                System.err.println("Using AppletVorbisSPIWorkaround to get codec (AudioInputStream:file)");
            }
            return AppletVorbisSPIWorkaround.getAudioInputStream(inputStream);
        }
        catch (UnsupportedAudioFileException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
        catch (IOException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
    }

    public static AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        BufferedInputStream inputStream = new BufferedInputStream(url.openStream());
        try {
            if (DEBUG) {
                System.err.println("Using AppletVorbisSPIWorkaround to get codec (AudioInputStream:url)");
            }
            return AppletVorbisSPIWorkaround.getAudioInputStream(inputStream);
        }
        catch (UnsupportedAudioFileException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
        catch (IOException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
    }

    public static AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        BufferedInputStream inputStream = null;
        if (useragent != null) {
            URLConnection myCon = url.openConnection();
            myCon.setUseCaches(false);
            myCon.setDoInput(true);
            myCon.setDoOutput(true);
            myCon.setAllowUserInteraction(false);
            myCon.setRequestProperty("User-Agent", useragent);
            myCon.setRequestProperty("Accept", "*/*");
            myCon.setRequestProperty("Icy-Metadata", "1");
            myCon.setRequestProperty("Connection", "close");
            inputStream = new BufferedInputStream(myCon.getInputStream());
        } else {
            inputStream = new BufferedInputStream(url.openStream());
        }
        try {
            if (DEBUG) {
                System.err.println("Using AppletVorbisSPIWorkaround to get codec AudioFileFormat(url)");
            }
            AudioFileFormat audioFileFormat = AppletVorbisSPIWorkaround.getAudioFileFormat(inputStream);
            return audioFileFormat;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public static AudioFileFormat getAudioFileFormat(InputStream is) throws UnsupportedAudioFileException, IOException {
        try {
            try {
                throw new Exception();
            }
            catch (Exception iae) {
                if (DEBUG) {
                    System.err.println("Using AppletVorbisSPIWorkaround to get codec");
                }
                try {
                    is.mark(4096);
                    Class.forName("org.tritonus.sampled.file.jorbis.JorbisAudioFileReader");
                    AudioFileFormat audioFileFormat = new JorbisAudioFileReader().getAudioFileFormat(is);
                    return audioFileFormat;
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalArgumentException("Vorbis codec not properly installed");
                }
            }
        }
        finally {
            is.reset();
        }
    }

    public static AudioInputStream getAudioInputStream(InputStream is) throws UnsupportedAudioFileException, IOException {
        try {
            throw new Exception();
        }
        catch (Exception iae) {
            if (DEBUG) {
                System.err.println("Using AppleVorbisSPIWorkaround to get codec");
            }
            try {
                Class.forName("org.tritonus.sampled.file.jorbis.JorbisAudioFileReader");
                return new JorbisAudioFileReader().getAudioInputStream(is);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("Vorbis codec not properly installed:" + cnfe.getMessage());
            }
        }
    }
}

