/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.applet;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.mpeg.sampled.file.IcyListener;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileReader;
import javazoom.spi.mpeg.sampled.file.tag.IcyInputStream;
import org.tritonus.share.TDebug;

public class MpegAudioFileReaderWorkaround
extends MpegAudioFileReader {
    public AudioInputStream getAudioInputStream(URL url, String userAgent) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("MpegAudioFileReaderWorkaround.getAudioInputStream(URL,String): begin");
        }
        long lFileLengthInBytes = -1L;
        URLConnection conn = url.openConnection();
        boolean isShout = false;
        int toRead = 4;
        byte[] head = new byte[toRead];
        if (userAgent != null) {
            conn.setRequestProperty("User-Agent", userAgent);
        }
        conn.setRequestProperty("Accept", "*/*");
        conn.setRequestProperty("Icy-Metadata", "1");
        conn.setRequestProperty("Connection", "close");
        BufferedInputStream bInputStream = new BufferedInputStream(conn.getInputStream());
        bInputStream.mark(toRead);
        int read = bInputStream.read(head, 0, toRead);
        if (read > 2 && head[0] == 73 | head[0] == 105 && head[1] == 67 | head[1] == 99 && head[2] == 89 | head[2] == 121) {
            isShout = true;
        }
        bInputStream.reset();
        BufferedInputStream inputStream = null;
        if (isShout) {
            IcyInputStream icyStream = new IcyInputStream(bInputStream);
            icyStream.addTagParseListener(IcyListener.getInstance());
            inputStream = icyStream;
        } else {
            String metaint = conn.getHeaderField("icy-metaint");
            if (metaint != null) {
                IcyInputStream icyStream = new IcyInputStream((InputStream)bInputStream, metaint);
                icyStream.addTagParseListener(IcyListener.getInstance());
                inputStream = icyStream;
            } else {
                inputStream = bInputStream;
            }
        }
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = this.getAudioInputStream(inputStream, lFileLengthInBytes);
        }
        catch (UnsupportedAudioFileException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
        catch (IOException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("MpegAudioFileReaderWorkaround.getAudioInputStream(URL,String): end");
        }
        return audioInputStream;
    }
}

