/*
 * Decompiled with CFR 0.152.
 */
package arcus.gui;

import arcus.I18N;
import arcus.gui.EditableGraphicsEngine;
import arcus.gui.Images;
import arcus.gui.MainFrame;
import arcus.gui.PatternGrabber;
import arcus.gui.PatternStore;
import arcus.gui.ToolBarPanel;
import arcus.model.GraphicsDescriptor;
import java.awt.event.ActionEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;

public class Editor
extends ToolBarPanel
implements Cloneable {
    private EditableGraphicsEngine grEngine;
    private MainFrame mainFrame;
    private String name = "";
    private boolean modified = false;
    private JToggleButton grabButton;

    public Editor(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.grEngine = new EditableGraphicsEngine();
        this.grEngine.setEditor(this);
        this.addButtons();
        this.add(this.grEngine);
    }

    protected Editor(boolean bl) {
        this.addButtons();
    }

    protected void addButtons() {
        this.addToolButton(new JButton(new AbstractAction(null, Images.getImageIcon("store")){

            public void actionPerformed(ActionEvent actionEvent) {
                PatternStore.instance.add(Editor.this.grEngine.getGraphicsDescriptor());
            }
        }){
            {
                this.setToolTipText(I18N.get("Editor.add.to.pattern.store"));
            }
        });
        this.addToolBarSeparator();
        this.addToolButton(new JButton(new AbstractAction(null, Images.getImageIcon("check")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Editor.this.grEngine.verifyPattern()) {
                    JOptionPane.showMessageDialog(Editor.this, I18N.get("Message.valid.pattern"), I18N.get("Dialog.title.info"), 1);
                } else {
                    JOptionPane.showMessageDialog(Editor.this, I18N.get("Message.invalid.pattern"), I18N.get("Dialog.title.info"), 1);
                }
            }
        }){
            {
                this.setToolTipText(I18N.get("Editor.validate"));
            }
        });
        this.grabButton = new JToggleButton();
        AbstractAction abstractAction = new AbstractAction(null, Images.getImageIcon("grab")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!Editor.this.grabButton.isSelected()) {
                    PatternGrabber.instance.delete();
                    return;
                }
                PatternGrabber.instance.activate(new AbstractAction(I18N.get("Editor.grab"), Images.getImageIcon("grab")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Editor.this.grEngine.setGraphicsDescriptor(PatternGrabber.instance.getGraphicsDescriptor());
                        PatternGrabber.instance.delete();
                        Editor.this.grabButton.setSelected(false);
                    }
                }, new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Editor.this.grabButton.setSelected(false);
                    }
                });
            }
        };
        this.grabButton.setAction(abstractAction);
        this.grabButton.setToolTipText(I18N.get("Editor.grab"));
        this.addToolButton(this.grabButton);
    }

    public Object clone() {
        Editor editor = new Editor(false);
        editor.mainFrame = this.mainFrame;
        editor.name = new String(this.name);
        editor.grEngine = (EditableGraphicsEngine)this.grEngine.clone();
        editor.add(editor.grEngine);
        return editor;
    }

    public void setName(String string) {
        this.name = string;
        this.setModified(true);
    }

    public String getName() {
        return this.name;
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
        if (this.modified) {
            this.mainFrame.setModified(true);
        }
    }

    public void save(XMLEncoder xMLEncoder) {
        xMLEncoder.writeObject(this.grEngine.getGraphicsDescriptor());
        xMLEncoder.writeObject(new Integer(this.grEngine.getPaintColorIdx()));
    }

    public void load(XMLDecoder xMLDecoder) {
        this.grEngine.setGraphicsDescriptor((GraphicsDescriptor)xMLDecoder.readObject());
        this.grEngine.setPaintColorIdx((Integer)xMLDecoder.readObject());
    }
}

