/*
 * Decompiled with CFR 0.152.
 */
package arcus.gui;

import arcus.I18N;
import arcus.Version;
import arcus.gui.CanceledException;
import arcus.gui.StoreGraphicsEngine;
import arcus.gui.ext.XFrame;
import arcus.model.ExtensionFileFilter;
import arcus.model.GraphicsDescriptor;
import arcus.model.Preferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;

public class PatternStore
extends XFrame {
    public static final PatternStore instance = new PatternStore();
    private Vector<StoreGraphicsEngine> patterns = new Vector();
    private File file = null;
    private boolean modified = false;
    private String path = (String)Preferences.instance.get("patternStorePath");
    private JPanel panel = new ScrPanel();
    private JScrollPane scrollPane;
    private SaveAction saveAction = new SaveAction();
    private JProgressBar progressBar;

    public void setPatternFile(File file) {
        this.file = file;
        this.path = this.file.getParent();
        Preferences.instance.set("patternStorePath", this.path);
        Preferences.instance.save();
        this.setTitle(this.file + " - Arcus " + I18N.get("PatternStore.title"));
    }

    public PatternStore() {
        super(I18N.get("PatternStore.title"));
        this.getContentPane().setLayout(new BorderLayout());
        this.progressBar = new JProgressBar();
        this.progressBar.setVisible(false);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(I18N.get("PatternStore.menu.file"));
        jMenu.add(new JMenuItem(new AbstractAction(I18N.get("PatternStore.menu.file.new")){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            PatternStore.this.close();
                        }
                        catch (CanceledException canceledException) {
                            // empty catch block
                        }
                    }
                };
                thread.start();
            }
        }));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(new AbstractAction(I18N.get("PatternStore.menu.file.open")){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            PatternStore.this.close();
                        }
                        catch (CanceledException canceledException) {
                            return;
                        }
                        JFileChooser jFileChooser = new JFileChooser(PatternStore.this.path);
                        jFileChooser.setFileFilter(new ExtensionFileFilter("arcsp", I18N.get("Extension.arcsp") + " (*.arcsp)"));
                        if (jFileChooser.showOpenDialog(PatternStore.this) == 0) {
                            if (!PatternStore.this.load(jFileChooser.getSelectedFile(), false)) {
                                JOptionPane.showMessageDialog(PatternStore.this, I18N.get("Message.error.fopen"), I18N.get("Dialog.title.error"), 0);
                            } else {
                                PatternStore.this.setPatternFile(jFileChooser.getSelectedFile());
                            }
                        }
                    }
                };
                thread.start();
            }
        }));
        jMenu.add(new JMenuItem(new AbstractAction(I18N.get("PatternStore.menu.file.append")){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(PatternStore.this.path);
                jFileChooser.setFileFilter(new ExtensionFileFilter("arcsp", I18N.get("Extension.arcsp") + " (*.arcsp)"));
                if (jFileChooser.showDialog(PatternStore.this, I18N.get("PatternStore.menu.file.append")) == 0) {
                    final File file = jFileChooser.getSelectedFile();
                    PatternStore.this.path = file.getParent();
                    Preferences.instance.set("patternStorePath", PatternStore.this.path);
                    Preferences.instance.save();
                    Thread thread = new Thread(){

                        public void run() {
                            if (!PatternStore.this.load(file, true)) {
                                JOptionPane.showMessageDialog(PatternStore.this, I18N.get("Message.error.fopen"), I18N.get("Dialog.title.error"), 0);
                            }
                        }
                    };
                    thread.start();
                }
            }
        }));
        jMenu.add(new JMenuItem(new AbstractAction(I18N.get("PatternStore.menu.file.close")){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            PatternStore.this.close();
                        }
                        catch (CanceledException canceledException) {
                            // empty catch block
                        }
                    }
                };
                thread.start();
            }
        }));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.saveAction));
        this.saveAction.setEnabled(false);
        jMenu.add(new JMenuItem(new AbstractAction(I18N.get("PatternStore.menu.file.saveas")){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            PatternStore.this.saveAs();
                        }
                        catch (CanceledException canceledException) {
                            // empty catch block
                        }
                    }
                };
                thread.start();
            }
        }));
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.scrollPane = new JScrollPane(this.panel);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.progressBar, "Last");
        this.setSize(new Dimension(410, 320));
    }

    public void add(GraphicsDescriptor graphicsDescriptor) {
        final StoreGraphicsEngine storeGraphicsEngine = new StoreGraphicsEngine();
        storeGraphicsEngine.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "remove");
        storeGraphicsEngine.getActionMap().put("remove", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PatternStore.this.remove(storeGraphicsEngine);
            }
        });
        storeGraphicsEngine.setGraphicsDescriptor(graphicsDescriptor);
        storeGraphicsEngine.setPreferredSize(new Dimension(120, 120));
        storeGraphicsEngine.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.patterns.addElement(storeGraphicsEngine);
        this.panel.add(storeGraphicsEngine);
        this.panel.revalidate();
        this.setModified(true);
    }

    private void remove(StoreGraphicsEngine storeGraphicsEngine) {
        Object[] objectArray = new Object[]{I18N.get("Button.yes"), I18N.get("Button.no")};
        if (JOptionPane.showOptionDialog(this, I18N.get("Message.confirm.remove.pattern"), I18N.get("PatternStore.menu.pattern.remove"), 0, 3, null, objectArray, objectArray[0]) == 0) {
            this.patterns.removeElement(storeGraphicsEngine);
            this.panel.remove(storeGraphicsEngine);
            this.panel.repaint();
            this.panel.revalidate();
            this.setModified(true);
        }
    }

    private void setModified(boolean bl) {
        this.modified = bl;
        this.saveAction.setEnabled(bl);
    }

    public void move(StoreGraphicsEngine storeGraphicsEngine, StoreGraphicsEngine storeGraphicsEngine2) {
        int n = this.patterns.indexOf(storeGraphicsEngine);
        int n2 = this.patterns.indexOf(storeGraphicsEngine2);
        GraphicsDescriptor graphicsDescriptor = storeGraphicsEngine.getGraphicsDescriptor();
        if (n < n2) {
            for (int i = n; i < n2; ++i) {
                this.patterns.get(i).setGraphicsDescriptor(this.patterns.get(i + 1).getGraphicsDescriptor());
            }
            this.setModified(true);
        } else if (n > n2) {
            for (int i = n; i > n2; --i) {
                this.patterns.get(i).setGraphicsDescriptor(this.patterns.get(i - 1).getGraphicsDescriptor());
            }
            this.setModified(true);
        }
        this.patterns.get(n2).setGraphicsDescriptor(graphicsDescriptor);
    }

    public void setCursor(Cursor cursor) {
        for (int i = 0; i < this.patterns.size(); ++i) {
            this.patterns.get(i).setCursor(cursor);
        }
    }

    public void close() throws CanceledException {
        Object[] objectArray = new Object[]{I18N.get("Button.save"), I18N.get("Button.dontsave"), I18N.get("Button.cancel")};
        if (this.modified) {
            int n = JOptionPane.showOptionDialog(this, I18N.get("Message.confirm.save.pattern"), I18N.get("PatternStore.menu.file.close"), 1, 3, null, objectArray, objectArray[0]);
            if (n == 0) {
                this.save(this.file);
            } else if (n == 2 || n == -1) {
                throw new CanceledException();
            }
        }
        this.patterns = new Vector();
        this.file = null;
        this.setTitle(I18N.get("PatternStore.title"));
        this.panel.removeAll();
        this.panel.repaint();
        this.panel.revalidate();
        this.setModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(File file, boolean bl) {
        try {
            XMLDecoder xMLDecoder = new XMLDecoder(new GZIPInputStream(new FileInputStream(file)));
            Vector vector = new Vector();
            boolean bl2 = false;
            Object object = xMLDecoder.readObject();
            if (object instanceof String) {
                if (!((String)object).startsWith("arcus.pattern")) {
                    xMLDecoder.close();
                    boolean bl3 = false;
                    return bl3;
                }
                object = xMLDecoder.readObject();
            } else {
                bl2 = true;
            }
            int n = (Integer)object;
            this.progressBar.setVisible(true);
            this.progressBar.setMaximum(n);
            this.progressBar.setValue(0);
            for (int i = 0; i < n; ++i) {
                GraphicsDescriptor graphicsDescriptor = (GraphicsDescriptor)xMLDecoder.readObject();
                this.add(graphicsDescriptor);
                this.progressBar.setValue(i + 1);
            }
            xMLDecoder.close();
            this.setModified(bl || bl2);
            if (bl2) {
                JOptionPane.showMessageDialog(this, I18N.get("Message.update.pattern"), I18N.get("Dialog.title.info"), 1);
            }
        }
        catch (Exception exception) {
            this.setModified(false);
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.progressBar.setVisible(false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(File file) throws CanceledException {
        if (file == null) {
            this.saveAs();
            return;
        }
        try {
            XMLEncoder xMLEncoder = new XMLEncoder(new GZIPOutputStream(new FileOutputStream(this.file)));
            xMLEncoder.writeObject(new String("arcus.pattern." + new Version()));
            xMLEncoder.writeObject(new Integer(this.patterns.size()));
            this.progressBar.setVisible(true);
            this.progressBar.setMaximum(this.patterns.size());
            this.progressBar.setValue(0);
            for (int i = 0; i < this.patterns.size(); ++i) {
                xMLEncoder.writeObject(this.patterns.get(i).getGraphicsDescriptor());
                this.progressBar.setValue(i + 1);
            }
            xMLEncoder.close();
            this.setModified(false);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, I18N.get("Message.error.fsave") + "\n" + exception, I18N.get("Dialog.title.error"), 0);
        }
        finally {
            this.progressBar.setVisible(false);
        }
    }

    private void saveAs() throws CanceledException {
        File file;
        JFileChooser jFileChooser = new JFileChooser(this.path);
        jFileChooser.setFileFilter(new ExtensionFileFilter("arcsp", I18N.get("Extension.arcsp") + " (*.arcsp)"));
        if (jFileChooser.showDialog(this, I18N.get("PatternStore.menu.file.save")) == 0) {
            file = jFileChooser.getSelectedFile();
            this.path = file.getParent();
            Preferences.instance.set("patternStorePath", this.path);
            Preferences.instance.save();
            if (!file.toString().endsWith(".arcsp")) {
                file = new File(file.toString() + ".arcsp");
            }
            if (file.exists()) {
                Object[] objectArray = new Object[]{I18N.get("Button.yes"), I18N.get("Button.no")};
                if (JOptionPane.showOptionDialog(this, I18N.get("Message.confirm.overwrite"), I18N.get("PatternStore.menu.file.saveas"), 0, 3, null, objectArray, objectArray[0]) != 0) {
                    throw new CanceledException();
                }
            }
        } else {
            throw new CanceledException();
        }
        this.file = file;
        this.setTitle(this.file + " - " + I18N.get("PatternStore.title"));
        this.save(this.file);
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super(I18N.get("PatternStore.menu.file.save"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Thread thread = new Thread(){

                public void run() {
                    try {
                        PatternStore.this.save(PatternStore.this.file);
                    }
                    catch (CanceledException canceledException) {
                        // empty catch block
                    }
                }
            };
            thread.start();
        }
    }

    private class ScrPanel
    extends JPanel
    implements Scrollable {
        public ScrPanel() {
            super(new FlowLayout(3, 5, 5));
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            if (this.getSize().width == 0) {
                return new Dimension(0, 0);
            }
            return new Dimension(0, 5 + 125 * (int)Math.ceil((double)PatternStore.this.patterns.size() / (double)(this.getSize().width / 125)));
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 625;
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 125;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }
    }
}

