/*
 * Decompiled with CFR 0.152.
 */
package arcus.gui;

import arcus.I18N;
import arcus.gui.ext.XFrame;
import arcus.gui.ext.XTabbedPane;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public class TabbedContainer
extends XFrame {
    public static TabbedContainer grEngineTabs = new TabbedContainer(I18N.get("View.title"));
    public static TabbedContainer consoleTabs = new TabbedContainer(I18N.get("Console.title"));
    public static TabbedContainer historyTabs = new TabbedContainer(I18N.get("History.title"));
    public static TabbedContainer editorTabs = new TabbedContainer(I18N.get("Editor.title"));
    private XTabbedPane tabbedPane;

    public TabbedContainer(String string) {
        super(string);
        this.tabbedPane = new XTabbedPane(string);
        this.tabbedPane.setName("COMPONENT_HOLDER");
        this.tabbedPane.addPropertyChangeListener(new TabManagerListener());
        this.add(this.tabbedPane);
    }

    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public void addComponent(JComponent jComponent) {
        this.tabbedPane.addTab(null, jComponent);
        if (this.tabbedPane.getTabCount() == 1) {
            this.pack();
        }
        this.setVisible(true);
    }

    public void removeComponent(JComponent jComponent) {
        this.tabbedPane.remove(jComponent);
        if (this.tabbedPane.getTabCount() == 0) {
            this.setVisible(false);
        }
    }

    public void removeAll() {
        this.tabbedPane.removeAll();
        this.setVisible(false);
    }

    private class TabManagerListener
    implements PropertyChangeListener {
        private TabManagerListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("zero_tab_count")) {
                TabbedContainer.this.setVisible(false);
            }
            if (propertyChangeEvent.getPropertyName().equals("nonzero_tab_count")) {
                TabbedContainer.this.setVisible(true);
            }
        }
    }
}

