/*
 * Decompiled with CFR 0.152.
 */
package arcus.model;

import arcus.gui.Console;
import arcus.gui.History;
import arcus.gui.MainFrame;
import arcus.gui.TurnableGraphicsEngine;
import arcus.model.CubeEvent;
import arcus.model.CubeStateDescriptor;
import arcus.model.GraphDataDescriptor;
import arcus.model.Notifiable;
import java.util.Vector;

public class CubeInstance
implements Notifiable,
Cloneable {
    public static final int READY = 0;
    public static final int PROCESSING = 1;
    public static final int STOPPED = 2;
    public TurnableGraphicsEngine graphicsEngine = new TurnableGraphicsEngine();
    public Console console = new Console(null);
    public History history = new History();
    private Vector<CubeEvent> eventQueue = new Vector();
    private MainFrame mainFrame;
    private String name = "";
    private CubeEvent currentEvent = null;
    private boolean modified = false;
    private boolean stop = false;
    private boolean flush = false;

    public CubeInstance(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.graphicsEngine.setInstance(this);
        this.console.setInstance(this);
        this.history.setInstance(this);
        this.history.init();
    }

    public CubeInstance(TurnableGraphicsEngine turnableGraphicsEngine, Console console, History history) {
        this.graphicsEngine = turnableGraphicsEngine;
        this.console = console;
        this.history = history;
        turnableGraphicsEngine.setInstance(this);
        console.setInstance(this);
        history.setInstance(this);
        history.init();
    }

    public Object clone() {
        CubeInstance cubeInstance = new CubeInstance(this.mainFrame);
        cubeInstance.graphicsEngine = (TurnableGraphicsEngine)this.graphicsEngine.clone();
        cubeInstance.history = (History)this.history.clone();
        cubeInstance.console = (Console)this.console.clone();
        cubeInstance.graphicsEngine.setInstance(cubeInstance);
        cubeInstance.history.setInstance(cubeInstance);
        cubeInstance.console.setInstance(cubeInstance);
        return cubeInstance;
    }

    public void setName(String string) {
        this.name = string;
        this.setModified(true);
    }

    public String getName() {
        return this.name;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
        if (this.modified) {
            this.mainFrame.setModified(true);
        }
    }

    public int getState() {
        if (this.graphicsEngine.isBusy()) {
            return 1;
        }
        if (!this.graphicsEngine.isBusy() && !this.eventQueue.isEmpty()) {
            return 2;
        }
        if (!this.graphicsEngine.isBusy() && this.eventQueue.isEmpty() && this.history.isCursorAtEnd()) {
            return 0;
        }
        return -1;
    }

    public boolean isCurrentEventNull() {
        return this.currentEvent == null;
    }

    public void stop() {
        if (this.getState() == 1 && this.currentEvent != null) {
            this.stop = true;
        }
    }

    public void flush() {
        if (this.getState() == 1) {
            this.flush = true;
        } else if (this.getState() == 2) {
            this.flushEventQueue();
        }
    }

    public int lockHolder() {
        if (!this.eventQueue.isEmpty()) {
            return this.eventQueue.get((int)(this.eventQueue.size() - 1)).type;
        }
        if (this.currentEvent != null) {
            return this.currentEvent.type;
        }
        return -1;
    }

    public void removeAllEvents() {
        this.eventQueue.removeAllElements();
        this.setModified(true);
    }

    public void flushEventQueue() {
        if (!this.history.isCursorAtEnd()) {
            this.history.seekToEnd();
        }
        while (!this.eventQueue.isEmpty()) {
            this.currentEvent = this.eventQueue.remove(0);
            this.graphicsEngine.jump(this.currentEvent, null);
            if (!this.currentEvent.addToHistory) continue;
            CubeStateDescriptor cubeStateDescriptor = new CubeStateDescriptor();
            cubeStateDescriptor.graphDataDesc = new GraphDataDescriptor(this.graphicsEngine.getEntropy());
            cubeStateDescriptor.graphicsDesc = this.graphicsEngine.getGraphicsDescriptor();
            cubeStateDescriptor.event = this.currentEvent;
            cubeStateDescriptor.event.addToHistory = false;
            this.history.addElement(cubeStateDescriptor);
        }
        this.graphicsEngine.repaint();
        this.flush = false;
        this.currentEvent = null;
    }

    public void optimizeEventQueue() {
        int n = 0;
        block6: while (n < this.eventQueue.size() - 1) {
            int n2;
            CubeEvent cubeEvent = this.eventQueue.get(n);
            for (n2 = n; n2 < this.eventQueue.size() && this.eventQueue.get((int)n2).axis == cubeEvent.axis; ++n2) {
            }
            if (n2 == n) {
                ++n;
                continue;
            }
            for (int i = n + 1; i < n2; ++i) {
                CubeEvent cubeEvent2 = this.eventQueue.get(i);
                if (cubeEvent.layer != cubeEvent2.layer) continue;
                int n3 = cubeEvent.dir + cubeEvent2.dir;
                switch (cubeEvent.dir + cubeEvent2.dir) {
                    case 0: {
                        this.eventQueue.remove(i);
                        this.eventQueue.remove(n);
                        n = 0;
                        continue block6;
                    }
                    case -1: {
                        this.eventQueue.remove(i);
                        this.eventQueue.get((int)n).dir = 1;
                        n = 0;
                        continue block6;
                    }
                    case 1: {
                        this.eventQueue.remove(i);
                        this.eventQueue.get((int)n).dir = -1;
                        n = 0;
                        continue block6;
                    }
                    case -2: 
                    case 2: {
                        this.eventQueue.remove(i);
                        this.eventQueue.get((int)n).dir = 0;
                        n = 0;
                        continue block6;
                    }
                }
            }
            ++n;
        }
        this.history.setBufferSize(this.eventQueue.size());
    }

    public void addEvent(CubeEvent cubeEvent) {
        this.setModified(true);
        if (this.getState() == 0) {
            this.dispatchEvent(cubeEvent);
        } else {
            this.storeEvent(cubeEvent);
        }
    }

    public int getBufferSize() {
        return this.eventQueue.size();
    }

    public void graphicsEngineReadyNotification() {
        if (this.currentEvent.addToHistory) {
            CubeStateDescriptor cubeStateDescriptor = new CubeStateDescriptor();
            cubeStateDescriptor.graphDataDesc = new GraphDataDescriptor(this.graphicsEngine.getEntropy());
            cubeStateDescriptor.graphicsDesc = this.graphicsEngine.getGraphicsDescriptor();
            cubeStateDescriptor.event = this.currentEvent;
            cubeStateDescriptor.event.addToHistory = false;
            this.history.addElement(cubeStateDescriptor);
        }
        this.currentEvent = null;
        if (this.stop) {
            this.stop = false;
            return;
        }
        if (this.flush) {
            this.flush = false;
            this.flushEventQueue();
            return;
        }
        this.dispatchNextEvent();
    }

    public void dispatchNextEvent() {
        if (!this.eventQueue.isEmpty()) {
            this.dispatchEvent(this.eventQueue.remove(0));
        }
    }

    private void dispatchEvent(CubeEvent cubeEvent) {
        this.currentEvent = cubeEvent;
        this.graphicsEngine.turn(cubeEvent, this);
    }

    public void storeEvent(CubeEvent cubeEvent) {
        this.setModified(true);
        this.eventQueue.addElement(cubeEvent);
        this.history.setBufferSize(this.eventQueue.size());
    }
}

