/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;

interface Actions {
    public static final ImageIcon exitIcon = new ImageIcon(Jetris.getConfig().getClass().getClassLoader().getResource("images/exit.gif"));
    public static final ImageIcon newIcon = new ImageIcon(Jetris.getConfig().getClass().getClassLoader().getResource("images/new.gif"));
    public static final ImageIcon startIcon = new ImageIcon(Jetris.getConfig().getClass().getClassLoader().getResource("images/start.gif"));
    public static final ImageIcon stopIcon = new ImageIcon(Jetris.getConfig().getClass().getClassLoader().getResource("images/stop.gif"));
    public static final ImageIcon leftIcon = new ImageIcon(Jetris.getConfig().getClass().getClassLoader().getResource("images/left.gif"));
    public static final ImageIcon rightIcon = new ImageIcon(Jetris.getConfig().getClass().getClassLoader().getResource("images/right.gif"));
    public static final ImageIcon aboutIcon = new ImageIcon(Jetris.getConfig().getClass().getClassLoader().getResource("images/about.gif"));
    public static final ImageIcon closeIcon = new ImageIcon(Jetris.getConfig().getClass().getClassLoader().getResource("images/close.gif"));
    public static final AbstractAction newAction = new AbstractAction("New", newIcon){

        public void actionPerformed(ActionEvent actionEvent) {
            if (Jetris.getGame() == null) {
                Jetris.getGamePanel().reset();
                Jetris.getGamePanel().repaint();
                Jetris.setGame(new JetrisGame());
                Jetris.getScoreBoard().setScore(Jetris.getGame().getScore());
            }
        }
    };
    public static final AbstractAction startAction = new AbstractAction("Start", startIcon){

        public void actionPerformed(ActionEvent actionEvent) {
            if (Jetris.getGame() != null) {
                Jetris.getGame().start();
            }
        }
    };
    public static final AbstractAction stopAction = new AbstractAction("Stop", stopIcon){

        public void actionPerformed(ActionEvent actionEvent) {
            if (Jetris.getGame() != null) {
                Jetris.getGame().stop();
            }
        }
    };
    public static final AbstractAction exitAction = new AbstractAction("Exit", exitIcon){

        public void actionPerformed(ActionEvent actionEvent) {
            Jetris.getGameFrame().writeConfig();
            Jetris.getPreviewWindow().writeConfig();
            Jetris.getScoreKeeper().writeConfig();
            Jetris.getConfig().writeKey("previewvisible", Jetris.getPreviewWindow().isVisible());
            Jetris.getConfig().writeKey("highscoresvisible", Jetris.getScoreKeeper().isVisible());
            Jetris.getGameFrame().dispose();
            System.exit(0);
        }
    };
    public static final AbstractAction leftAction = new AbstractAction("Left", leftIcon){

        public void actionPerformed(ActionEvent actionEvent) {
            if (Jetris.getGame() != null && Jetris.getGame().getBlock() != null && !Jetris.getGame().getBlock().isLeft()) {
                Jetris.getGame().getBlock().goLeft();
                Jetris.getGamePanel().repaint();
            }
        }
    };
    public static final AbstractAction rightAction = new AbstractAction("Right", rightIcon){

        public void actionPerformed(ActionEvent actionEvent) {
            if (Jetris.getGame() != null && Jetris.getGame().getBlock() != null && !Jetris.getGame().getBlock().isRight()) {
                Jetris.getGame().getBlock().goRight();
                Jetris.getGamePanel().repaint();
            }
        }
    };
    public static final AbstractAction scoreBoardAction = new AbstractAction("Scoreboard"){

        public void actionPerformed(ActionEvent actionEvent) {
            Jetris.getScoreBoard().setVisible(!Jetris.getScoreBoard().isVisible());
        }
    };
    public static final AbstractAction previewAction = new AbstractAction("Preview"){

        public void actionPerformed(ActionEvent actionEvent) {
            if (Jetris.getPreviewWindow().isVisible()) {
                Jetris.getPreviewWindow().setVisible(false);
                Jetris.getMenuBar().getPreviewCheckBox().setSelected(false);
            } else {
                Jetris.getPreviewWindow().setVisible(true);
                Jetris.getMenuBar().getPreviewCheckBox().setSelected(true);
            }
        }
    };
    public static final AbstractAction highScoresAction = new AbstractAction("Highscores"){

        public void actionPerformed(ActionEvent actionEvent) {
            if (Jetris.getScoreKeeper().isVisible()) {
                Jetris.getScoreKeeper().setVisible(false);
                Jetris.getMenuBar().getHighScoresCheckBox().setSelected(false);
            } else {
                Jetris.getScoreKeeper().setVisible(true);
                Jetris.getMenuBar().getHighScoresCheckBox().setSelected(true);
            }
        }
    };
    public static final AbstractAction gridAction = new AbstractAction("Grid"){

        public void actionPerformed(ActionEvent actionEvent) {
            Jetris.getGamePanel().setGrid(!Jetris.getGamePanel().isGrid());
            Jetris.getGamePanel().repaint();
        }
    };
    public static final AbstractAction backgroundColorAction = new AbstractAction("Background color..."){

        public void actionPerformed(ActionEvent actionEvent) {
            Jetris.getGamePanel().setBackgroundColor(JColorChooser.showDialog(Jetris.getGameFrame(), "Select color", Jetris.getGamePanel().getBackgroundColor()));
        }
    };
    public static final AbstractAction aboutAction = new AbstractAction("About Jetris", aboutIcon){

        public void actionPerformed(ActionEvent actionEvent) {
            Jetris.getAboutDialog().show();
        }
    };
    public static final AbstractAction closeAboutAction = new AbstractAction("Close", closeIcon){

        public void actionPerformed(ActionEvent actionEvent) {
            Jetris.getAboutDialog().setVisible(false);
            Jetris.getAboutDialog().writeConfig();
        }
    };
}

