/*
 * Decompiled with CFR 0.152.
 */
package puzzle.edge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.Map;
import puzzle.GameCommander;
import puzzle.edge.AbstractEdgeProducer;
import puzzle.edge.Edge;
import puzzle.storeage.JigsawPuzzleException;

public class EdgeDisposer {
    private final Map<Integer, GeneralPath> edgePaths = new HashMap<Integer, GeneralPath>();

    public void reset() {
        this.edgePaths.clear();
    }

    public GeneralPath generateNewEdgeShape(int n, Edge.Type type) throws JigsawPuzzleException {
        AbstractEdgeProducer abstractEdgeProducer = GameCommander.getInstance().getPreferences().getEdgeProducer();
        abstractEdgeProducer.init(GameCommander.getInstance().getPreferences().getSideLength());
        abstractEdgeProducer.produce();
        this.edgePaths.put(n, new GeneralPath(abstractEdgeProducer.getBothShapes()[0]));
        GeneralPath generalPath = new GeneralPath(abstractEdgeProducer.getBothShapes()[1]);
        this.turnToType(type, generalPath);
        return generalPath;
    }

    public GeneralPath findContraryEdgeShape(int n, Edge.Type type) throws JigsawPuzzleException {
        if (!this.edgePaths.containsKey(n)) {
            throw new JigsawPuzzleException("error in shape list occured: no shape");
        }
        if (this.edgePaths.get(n) == null) {
            throw new JigsawPuzzleException("error in shape list occured: shape null");
        }
        Shape shape = this.edgePaths.get(n);
        this.edgePaths.remove(n);
        GeneralPath generalPath = new GeneralPath(shape);
        this.turnToType(type, generalPath);
        return generalPath;
    }

    private void turnToType(Edge.Type type, GeneralPath generalPath) throws JigsawPuzzleException {
        switch (type) {
            case TOP: {
                break;
            }
            case BOTTOM: {
                generalPath.transform(AffineTransform.getRotateInstance(Math.toRadians(180.0), 0.0, 0.0));
                break;
            }
            case LEFT: {
                generalPath.transform(AffineTransform.getRotateInstance(Math.toRadians(270.0), 0.0, 0.0));
                break;
            }
            case RIGHT: {
                generalPath.transform(AffineTransform.getRotateInstance(Math.toRadians(90.0), 0.0, 0.0));
                break;
            }
            default: {
                throw new JigsawPuzzleException("Invalid Type");
            }
        }
    }
}

