/*
 * Decompiled with CFR 0.152.
 */
package puzzle.pieces;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import puzzle.GameCommander;
import puzzle.Offset;
import puzzle.edge.Edge;
import puzzle.pieces.PuzzlePiece;
import puzzle.storeage.JigsawPuzzleException;
import puzzle.storeage.LoadGameException;
import puzzle.storeage.SaveGameException;
import puzzle.storeage.StorageUtil;

public class SinglePiece
extends PuzzlePiece {
    private static final Logger logger = Logger.getLogger(SinglePiece.class);
    private BufferedImage image;
    private Point center;
    private TexturePaint pieceContent;
    private Edge topEdge;
    private Edge bottomEdge;
    private Edge rightEdge;
    private Edge leftEdge;

    public SinglePiece(Edge[] edgeArray, BufferedImage bufferedImage, Point point) throws JigsawPuzzleException {
        if (edgeArray == null) {
            throw new NullPointerException("edge null");
        }
        if (edgeArray.length != 4) {
            throw new IllegalArgumentException("only 4 field arrays are allowd...");
        }
        if (point == null) {
            throw new NullPointerException("center null");
        }
        if (bufferedImage == null) {
            throw new NullPointerException("null image");
        }
        if (edgeArray[0] == null && edgeArray[1] == null) {
            throw new IllegalArgumentException("no top and no bottom edge - the puzzle is one dimensional ?");
        }
        if (edgeArray[2] == null && edgeArray[3] == null) {
            throw new IllegalArgumentException("no right and no left edges - the puzzle is one dimensional?");
        }
        this.topEdge = edgeArray[0];
        this.bottomEdge = edgeArray[1];
        this.rightEdge = edgeArray[2];
        this.leftEdge = edgeArray[3];
        this.image = bufferedImage;
        this.center = point;
        this.puzzleShape = new GeneralPath();
        this.initEdges();
        this.buildShape();
        this.initEdgeList();
        this.recalculateTexture();
    }

    public SinglePiece() {
    }

    private void initEdgeList() {
        this.edges = new ArrayList();
        this.edges.add(this.topEdge);
        this.edges.add(this.bottomEdge);
        this.edges.add(this.rightEdge);
        this.edges.add(this.leftEdge);
    }

    private void initEdges() throws JigsawPuzzleException {
        Object object;
        int n = GameCommander.getInstance().getPreferences().getSideLength();
        if (this.topEdge == null) {
            object = new GeneralPath();
            ((Path2D.Float)object).moveTo(-(n / 2), 0.0f);
            ((Path2D.Float)object).lineTo(n / 2, 0.0f);
            this.topEdge = new Edge(Edge.Type.NULL, -1, (GeneralPath)object);
        }
        this.topEdge.setOwnerPiece(this);
        Offset offset = new Offset(0, -(n / 2));
        this.topEdge.setOffset(offset);
        this.topEdge.move(new Offset(this.center.x + offset.getX(), this.center.y + offset.getY()));
        if (this.rightEdge == null) {
            object = new GeneralPath();
            ((Path2D.Float)object).moveTo(0.0f, -n / 2);
            ((Path2D.Float)object).lineTo(0.0f, n / 2);
            this.rightEdge = new Edge(Edge.Type.NULL, -1, (GeneralPath)object);
        }
        this.rightEdge.setOwnerPiece(this);
        offset = new Offset(n / 2, 0);
        this.rightEdge.setOffset(offset);
        this.rightEdge.move(new Offset(this.center.x + offset.getX(), this.center.y + offset.getY()));
        if (this.bottomEdge == null) {
            object = new GeneralPath();
            ((Path2D.Float)object).moveTo(-(n / 2), 0.0f);
            ((Path2D.Float)object).lineTo(n / 2, 0.0f);
            this.bottomEdge = new Edge(Edge.Type.NULL, -1, (GeneralPath)object);
        }
        this.bottomEdge.setOwnerPiece(this);
        offset = new Offset(0, n / 2);
        this.bottomEdge.setOffset(offset);
        this.bottomEdge.move(new Offset(this.center.x + offset.getX(), this.center.y + offset.getY()));
        if (this.leftEdge == null) {
            object = new GeneralPath();
            ((Path2D.Float)object).moveTo(0.0f, n / 2);
            ((Path2D.Float)object).lineTo(0.0f, -(n / 2));
            this.leftEdge = new Edge(Edge.Type.NULL, -1, (GeneralPath)object);
        }
        this.leftEdge.setOwnerPiece(this);
        object = new Offset(-(n / 2), 0);
        this.leftEdge.setOffset((Offset)object);
        this.leftEdge.move(new Offset(this.center.x + ((Offset)object).getX(), this.center.y + ((Offset)object).getY()));
    }

    @Override
    protected void buildShape() throws JigsawPuzzleException {
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(this.topEdge.getShape(), true);
        generalPath.append(this.rightEdge.getShape(), true);
        generalPath.append(this.bottomEdge.getShape(), true);
        generalPath.append(this.leftEdge.getShape(), true);
        this.puzzleShape = generalPath;
    }

    @Override
    protected void renderFaceInClip(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setPaint(this.pieceContent);
        graphics2D.fill(this.puzzleShape);
    }

    private void recalculateTexture() {
        Rectangle rectangle = new Rectangle(this.center.x - this.image.getWidth() / 2, this.center.y - this.image.getHeight() / 2, this.image.getWidth(), this.image.getHeight());
        this.pieceContent = new TexturePaint(this.image, rectangle);
    }

    @Override
    public boolean isHit(Point point) {
        return this.puzzleShape.contains(point);
    }

    @Override
    public void move(Offset offset) {
        this.center.x += offset.getX();
        this.center.y += offset.getY();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(offset.getX(), offset.getY());
        for (Edge edge : this.edges) {
            edge.move(offset);
        }
        this.puzzleShape = affineTransform.createTransformedShape(this.puzzleShape);
        this.recalculateTexture();
    }

    @Override
    public List<Edge> getEdges(Edge.Type type) {
        List<Edge> list = this.getEdges();
        Vector<Edge> vector = new Vector<Edge>();
        for (Edge edge : list) {
            if (edge.getType() != type) continue;
            vector.add(edge);
            return vector;
        }
        return vector;
    }

    @Override
    public int getPieceCount() {
        return 1;
    }

    public Point getPoint() {
        int n = this.center.x;
        int n2 = this.center.y;
        return new Point(n, n2);
    }

    @Override
    public void turnDegrees(Point point, int n) {
        logger.debug("rotating singlePiece");
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(n), point.x, point.y);
        this.puzzleShape = affineTransform.createTransformedShape(this.puzzleShape);
        this.topEdge.turnDegrees(point, n);
        this.leftEdge.turnDegrees(point, n);
        this.bottomEdge.turnDegrees(point, n);
        this.rightEdge.turnDegrees(point, n);
        Edge edge = this.topEdge;
        this.topEdge = this.leftEdge;
        this.leftEdge = this.bottomEdge;
        this.bottomEdge = this.rightEdge;
        this.rightEdge = edge;
        if (point != this.center) {
            Point point2;
            Point2D point2D = affineTransform.transform(this.center, null);
            this.center = point2 = new Point((int)point2D.getX(), (int)point2D.getY());
        }
        this.rotateImage(n);
        this.recalculateTexture();
    }

    @Override
    public boolean isWithinRectangle(Rectangle rectangle) {
        Rectangle rectangle2 = this.getBoundingRectangle();
        if (rectangle.contains(rectangle2)) {
            return true;
        }
        return rectangle.intersects(rectangle2);
    }

    @Override
    public Rectangle getBoundingRectangle() {
        Rectangle rectangle = this.puzzleShape.getBounds();
        return new Rectangle(rectangle.x - 5, rectangle.y - 5, rectangle.width + 10, rectangle.height + 10);
    }

    private void rotateImage(int n) {
        double d;
        int n2 = this.image.getWidth();
        int n3 = this.image.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n3, n2, this.image.getType());
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(n), bufferedImage.getWidth() / 2, bufferedImage.getHeight() / 2);
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        Point2D point2D = affineTransform.transform(double_, null);
        double d2 = d = point2D.getY();
        AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(-d2, -d);
        affineTransform.preConcatenate(affineTransform2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)this.image, 0, 0, null);
        graphics2D.dispose();
        this.image = bufferedImage;
    }

    @Override
    public void restore(Node node) throws LoadGameException {
        Node node2;
        Node node3;
        Node node4;
        Node node5 = StorageUtil.findDirectChildNode(node, "SinglePiece");
        byte[] byArray = StorageUtil.restoreBinaryData(node5, "PieceImage");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            this.image = ImageIO.read(byteArrayInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LoadGameException(iOException);
        }
        NamedNodeMap namedNodeMap = node5.getAttributes();
        Node node6 = namedNodeMap.getNamedItem("centerX");
        int n = Integer.parseInt(node6.getNodeValue());
        node6 = namedNodeMap.getNamedItem("centerY");
        int n2 = Integer.parseInt(node6.getNodeValue());
        this.center = new Point(n, n2);
        Node node7 = StorageUtil.findDirectChildNode(node5, "TopEdge");
        if (node7.hasChildNodes()) {
            this.topEdge = new Edge();
            this.topEdge.restore(node7);
            try {
                this.topEdge.setOwnerPiece(this);
            }
            catch (JigsawPuzzleException jigsawPuzzleException) {
                throw new LoadGameException(jigsawPuzzleException);
            }
        }
        if ((node4 = StorageUtil.findDirectChildNode(node5, "BottomEdge")).hasChildNodes()) {
            this.bottomEdge = new Edge();
            this.bottomEdge.restore(node4);
            try {
                this.bottomEdge.setOwnerPiece(this);
            }
            catch (JigsawPuzzleException jigsawPuzzleException) {
                throw new LoadGameException(jigsawPuzzleException);
            }
        }
        if ((node3 = StorageUtil.findDirectChildNode(node5, "RightEdge")).hasChildNodes()) {
            this.rightEdge = new Edge();
            this.rightEdge.restore(node3);
            try {
                this.rightEdge.setOwnerPiece(this);
            }
            catch (JigsawPuzzleException jigsawPuzzleException) {
                throw new LoadGameException(jigsawPuzzleException);
            }
        }
        if ((node2 = StorageUtil.findDirectChildNode(node5, "LeftEdge")).hasChildNodes()) {
            this.leftEdge = new Edge();
            this.leftEdge.restore(node2);
            try {
                this.leftEdge.setOwnerPiece(this);
            }
            catch (JigsawPuzzleException jigsawPuzzleException) {
                throw new LoadGameException(jigsawPuzzleException);
            }
        }
        try {
            this.buildShape();
        }
        catch (JigsawPuzzleException jigsawPuzzleException) {
            throw new LoadGameException(jigsawPuzzleException);
        }
        this.initEdgeList();
        this.recalculateTexture();
    }

    @Override
    public void store(Node node) throws SaveGameException {
        Document document = node.getOwnerDocument();
        Element element = document.createElement("SinglePiece");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)this.image, "png", byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SaveGameException(iOException);
        }
        StorageUtil.storeBinaryData(element, "PieceImage", byteArrayOutputStream.toByteArray());
        element.setAttribute("centerX", "" + this.center.x);
        element.setAttribute("centerY", "" + this.center.y);
        Element element2 = document.createElement("TopEdge");
        if (this.topEdge != null) {
            this.topEdge.store(element2);
        }
        element.appendChild(element2);
        Element element3 = document.createElement("BottomEdge");
        if (this.bottomEdge != null) {
            this.bottomEdge.store(element3);
        }
        element.appendChild(element3);
        Element element4 = document.createElement("RightEdge");
        if (this.rightEdge != null) {
            this.rightEdge.store(element4);
        }
        element.appendChild(element4);
        Element element5 = document.createElement("LeftEdge");
        if (this.leftEdge != null) {
            this.leftEdge.store(element5);
        }
        element.appendChild(element5);
        node.appendChild(element);
    }
}

