/*
 * Decompiled with CFR 0.152.
 */
package datarep.common;

import java.applet.Applet;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class Util {
    public static Frame getFrame(Component component) {
        Component component2 = component;
        try {
            while (!(component2 instanceof Frame)) {
                component2 = component2.getParent();
            }
            return (Frame)component2;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static Window getWindow(Component component) {
        Component component2 = component;
        try {
            while (!(component2 instanceof Window)) {
                component2 = component2.getParent();
            }
            return (Window)component2;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static Applet getApplet(Component component) {
        Component component2 = component;
        try {
            while (!(component2 instanceof Applet)) {
                component2 = component2.getParent();
            }
            return (Applet)component2;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static Component getTopPanel(Component component) {
        Component component2 = component;
        try {
            while (!(component2 instanceof Window) && !(component2 instanceof Applet)) {
                component2 = component2.getParent();
            }
            return component2;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static void drawCenteredString(Graphics graphics, String string, int n, int n2) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = n - fontMetrics.stringWidth(string) / 2;
        int n4 = n2 - fontMetrics.getAscent() + (fontMetrics.getAscent() + fontMetrics.getDescent()) / 2;
        graphics.drawString(string, n3, n4);
    }

    public static boolean fileCopy(File file, File file2) {
        if (file2.equals(file)) {
            return true;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            boolean bl = Util.fileCopy(fileInputStream, file2);
            fileInputStream.close();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean fileCopy(URL uRL, File file) {
        try {
            InputStream inputStream = uRL.openConnection().getInputStream();
            boolean bl = Util.fileCopy(inputStream, file);
            inputStream.close();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean fileCopy(InputStream inputStream, File file) {
        try {
            int n;
            if (file.exists()) {
                file.delete();
            }
            byte[] byArray = new byte[1024];
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            while ((n = inputStream.read(byArray, 0, 1024)) >= 1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String changeDirectory(String string) {
        return Util.changeProperty("user.dir", string);
    }

    public static String changeProperty(String string, String string2) {
        Properties properties = System.getProperties();
        String string3 = ((Hashtable)properties).put(string, string2);
        try {
            System.setProperties(properties);
            return string3;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static String readln() {
        String string = "";
        try {
            while (System.in.available() > 0) {
                int n = System.in.read();
                if (n != -1 && n != 10 && n != 13) {
                    string = String.valueOf(string) + String.valueOf((char)n);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        return string;
    }

    public static String readln(boolean bl) {
        if (!bl) {
            return Util.readln();
        }
        String string = "";
        try {
            int n;
            while ((n = System.in.read()) != -1 && n != 10 && n != 13) {
                string = String.valueOf(string) + String.valueOf((char)n);
            }
        }
        catch (IOException iOException) {}
        return string;
    }

    public static void copyToClipboard(Component component, String string) {
        try {
            Clipboard clipboard = component.getToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, stringSelection);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static String copyFromClipboard(Component component) {
        try {
            Clipboard clipboard = component.getToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(component);
            return (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void bubbleSort(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            boolean bl = false;
            int n2 = stringArray.length - 2;
            while (n2 >= n) {
                if (stringArray[n2].compareTo(stringArray[n2 + 1]) > 0) {
                    String string = stringArray[n2];
                    stringArray[n2] = stringArray[n2 + 1];
                    stringArray[n2 + 1] = string;
                    bl = true;
                }
                --n2;
            }
            if (!bl) {
                return;
            }
            ++n;
        }
    }

    public static void backup(File file) {
        if (file.exists()) {
            try {
                File file2;
                File file3 = new File(file.getParent(), "Backup");
                if (!file3.isDirectory()) {
                    file3.mkdirs();
                }
                if ((file2 = new File(file3, file.getName())).exists() && file2.isFile()) {
                    file2.delete();
                }
                if (!file.renameTo(file2)) {
                    System.out.println("Warning: Failed to backup " + file);
                    return;
                }
            }
            catch (Exception exception) {
                System.out.println("Warning: Failed to backup " + file);
                System.out.println(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
                return;
            }
        }
    }

    public static String stripLF(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r\u0000", true);
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("\n")) {
                if (!bl) {
                    stringBuffer.append("\n");
                }
                bl = false;
                continue;
            }
            if (string2.equals("\r")) {
                stringBuffer.append("\n");
                bl = true;
                continue;
            }
            if (string2.equals("\u0000")) {
                bl = false;
                continue;
            }
            stringBuffer.append(string2);
            bl = false;
        }
        return stringBuffer.toString();
    }
}

