/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AuswahlBildschirm
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel labelSchwierigkeitsgrad = new JLabel("Difficulty: ");
    private JButton buttonAktualisieren = new JButton("refresh");
    private JRadioButton radioEinfach = new JRadioButton("Beginner (10x10) - 10 mines");
    private JRadioButton radioFortgeschritten = new JRadioButton("Intermediate (16x16) - 40 mines");
    private JRadioButton radioProfi = new JRadioButton("Expert (22x22) - 80 mines");
    private JPanel panelGesamt = new JPanel();
    private JPanel panelRadio = new JPanel();
    private JCheckBox checkboxSounds = new JCheckBox("sounds");
    private static int gridSpalten = 10;
    private static int gridZeilen = 10;
    private static int maxMinen = 10;
    private static int boundX = 330;
    private static int boundY = 430;
    private static StatistikGUI gewaehlteStatistik = MainMinesweeper.statistikEinfach;
    private static boolean soundsOn = true;

    public static int getSpalten() {
        return gridSpalten;
    }

    public static int getZeilen() {
        return gridZeilen;
    }

    public static int getMinen() {
        return maxMinen;
    }

    public AuswahlBildschirm(StatistikGUI aktuelleStatistik) {
        this.setLayout(new BorderLayout());
        this.panelGesamt.setLayout(new BoxLayout(this.panelGesamt, 1));
        ButtonGroup radioGroup = new ButtonGroup();
        radioGroup.add(this.radioEinfach);
        radioGroup.add(this.radioFortgeschritten);
        radioGroup.add(this.radioProfi);
        if (maxMinen == 10) {
            this.radioEinfach.setSelected(true);
        } else if (maxMinen == 40) {
            this.radioFortgeschritten.setSelected(true);
        } else if (maxMinen == 80) {
            this.radioProfi.setSelected(true);
        }
        this.radioEinfach.setBackground(Color.WHITE);
        this.radioFortgeschritten.setBackground(Color.WHITE);
        this.radioProfi.setBackground(Color.WHITE);
        this.panelRadio.setLayout(new BoxLayout(this.panelRadio, 1));
        this.panelRadio.add(this.labelSchwierigkeitsgrad);
        JPanel panelRahmen = new JPanel();
        panelRahmen.setLayout(new BoxLayout(panelRahmen, 1));
        panelRahmen.add(this.radioEinfach);
        panelRahmen.add(this.radioFortgeschritten);
        panelRahmen.add(this.radioProfi);
        panelRahmen.add(this.buttonAktualisieren);
        panelRahmen.setBackground(Color.WHITE);
        panelRahmen.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelRadio.add(panelRahmen);
        JPanel panelOptionen = new JPanel();
        panelOptionen.add(this.panelRadio);
        panelOptionen.add(this.checkboxSounds);
        if (soundsOn) {
            this.checkboxSounds.setSelected(true);
        } else {
            this.checkboxSounds.setSelected(false);
        }
        this.checkboxSounds.addItemListener(new MyItemListener());
        RadioListener myRadioListener = new RadioListener();
        this.radioEinfach.addActionListener(myRadioListener);
        this.radioFortgeschritten.addActionListener(myRadioListener);
        this.radioProfi.addActionListener(myRadioListener);
        this.buttonAktualisieren.addActionListener(new NeustartActionListener());
        this.panelGesamt.add(panelOptionen);
        this.add((Component)this.panelGesamt, "Center");
        this.add((Component)aktuelleStatistik, "Last");
    }

    public static boolean getSoundOn() {
        return soundsOn;
    }

    class MyItemListener
    implements ItemListener {
        MyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (soundsOn) {
                soundsOn = false;
            } else {
                soundsOn = true;
            }
        }
    }

    class NeustartActionListener
    implements ActionListener {
        NeustartActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainMinesweeper.starteSpielNeu(gewaehlteStatistik);
        }
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == AuswahlBildschirm.this.radioEinfach) {
                gridSpalten = 10;
                gridZeilen = 10;
                maxMinen = 10;
                boundX = 335;
                boundY = 457;
                gewaehlteStatistik = MainMinesweeper.statistikEinfach;
            } else if (e.getSource() == AuswahlBildschirm.this.radioFortgeschritten) {
                gridSpalten = 16;
                gridZeilen = 16;
                maxMinen = 40;
                boundX = 489;
                boundY = 600;
                gewaehlteStatistik = MainMinesweeper.statistikFortgeschritten;
            } else if (e.getSource() == AuswahlBildschirm.this.radioProfi) {
                gridSpalten = 22;
                gridZeilen = 22;
                maxMinen = 80;
                boundX = 707;
                boundY = 815;
                gewaehlteStatistik = MainMinesweeper.statistikProfi;
                MainMinesweeper.statistikProfi.abspeichern();
                MainMinesweeper.statistikAktualisieren();
            }
            MainMinesweeper.setNewBounds(boundX, boundY);
        }
    }
}

