/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.GeneticCode;
import biogenesis.Messages;
import biogenesis.VisibleWorld;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class GeneticCodePanel
extends JPanel {
    private static final long serialVersionUID = 700L;
    private static final Dimension defaultSize = new Dimension(100, 100);
    protected GeneticCode code;
    protected VisibleWorld visible;
    protected JPopupMenu popup;

    public GeneticCodePanel(GeneticCode geneticCode, VisibleWorld visibleWorld) {
        this.setBackground(Color.BLACK);
        this.setPreferredSize(defaultSize);
        this.code = geneticCode;
        this.visible = visibleWorld;
        this.popup = new JPopupMenu();
        JMenuItem menuCopy = new JMenuItem(Messages.getString("T_COPY"));
        menuCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneticCodePanel.this.visible.setClippedGeneticCode(GeneticCodePanel.this.code);
            }
        });
        this.popup.add(menuCopy);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    GeneticCodePanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    GeneticCodePanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public void setGeneticCode(GeneticCode geneticCode) {
        this.code = geneticCode;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.code != null) {
            this.code.draw(g, this.getWidth(), this.getHeight());
        }
    }
}

