/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.MainWindow;
import biogenesis.Messages;
import biogenesis.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NetConfigWindow
extends JDialog {
    private static final long serialVersionUID = 700L;
    protected JCheckBox acceptConnectionsCheck;
    protected boolean acceptConnections;
    protected JTextField localPortText;
    protected JTextField remotePortText;
    protected JTextField remoteAddressText;
    protected JTextField maxConnectionsText;
    protected JButton cancelButton;
    protected JButton okButton;
    protected MainWindow mainWindow;

    public NetConfigWindow(MainWindow parent) {
        super(parent, Messages.getString("T_NETWORK_CONFIGURATION"), true);
        this.mainWindow = parent;
        this.acceptConnections = this.mainWindow.isAcceptingConnections();
        this.setDefaultCloseOperation(2);
        this.setComponents();
        this.pack();
        this.setResizable(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetConfigWindow.this.dispose();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int oldPort = Utils.LOCAL_PORT;
                NetConfigWindow.this.checkParams();
                Utils.savePreferences();
                if (oldPort != Utils.LOCAL_PORT) {
                    NetConfigWindow.this.mainWindow.stopServer();
                    if (NetConfigWindow.this.mainWindow.isAcceptingConnections()) {
                        NetConfigWindow.this.mainWindow.startServer();
                    }
                }
                NetConfigWindow.this.dispose();
            }
        });
        this.setVisible(true);
    }

    protected void setComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel buttonsPanel = new JPanel();
        this.okButton = new JButton(Messages.getString("T_OK"));
        this.cancelButton = new JButton(Messages.getString("T_CANCEL"));
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        this.getContentPane().add((Component)buttonsPanel, "South");
        JPanel generalPanel = new JPanel();
        generalPanel.setLayout(new BoxLayout(generalPanel, 1));
        JPanel panel = new JPanel();
        this.acceptConnectionsCheck = new JCheckBox(Messages.getString("T_ALLOW_CONNECTIONS_FROM_OTHER_USERS"), this.acceptConnections);
        this.acceptConnectionsCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                NetConfigWindow.this.acceptConnections = arg0.getStateChange() == 1;
            }
        });
        panel.add(this.acceptConnectionsCheck);
        generalPanel.add(panel);
        panel = new JPanel();
        JLabel label = new JLabel(Messages.getString("T_MAXIMUM_NUMBER_OF_ALLOWED_CONNECTIONS"));
        panel.add(label);
        this.maxConnectionsText = new JTextField(String.valueOf(Utils.MAX_CONNECTIONS), 4);
        panel.add(this.maxConnectionsText);
        generalPanel.add(panel);
        panel = new JPanel();
        label = new JLabel(Messages.getString("T_LOCAL_PORT_TO_RECEIVE_CONNECTIONS"));
        panel.add(label);
        this.localPortText = new JTextField(String.valueOf(Utils.LOCAL_PORT), 6);
        panel.add(this.localPortText);
        generalPanel.add(panel);
        this.getContentPane().add((Component)generalPanel, "Center");
    }

    void checkParams() {
        int i;
        this.mainWindow.setAcceptConnections(this.acceptConnections);
        try {
            i = Integer.parseInt(this.localPortText.getText());
            if (i >= 0) {
                Utils.LOCAL_PORT = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this.maxConnectionsText.getText());
            if (i >= 0) {
                Utils.MAX_CONNECTIONS = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

