/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.MainWindow;
import biogenesis.Messages;
import biogenesis.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ParamDialog
extends JDialog {
    private static final long serialVersionUID = 700L;
    private JComboBox localeCombo = null;
    private JTextField widthText = null;
    private JTextField heightText = null;
    private JTextField delayText = null;
    protected JRadioButton hardwareNoneRadio = null;
    protected JRadioButton hardwareOpenGLRadio = null;
    private ButtonGroup hardwareGroup = null;
    protected JCheckBox hardwareFBObjectCheck = null;
    private JTextField rubbingText = null;
    private JTextField elasticityText = null;
    private JTextField initialnumberText = null;
    private JTextField initialenergyText = null;
    private JTextField initialO2Text = null;
    private JTextField initialCO2Text = null;
    private JTextField maxageText = null;
    private JTextField mutationrateText = null;
    private JTextField redcostText = null;
    private JTextField greencostText = null;
    private JTextField bluecostText = null;
    private JTextField cyancostText = null;
    private JTextField whitecostText = null;
    private JTextField graycostText = null;
    private JTextField yellowcostText = null;
    private JTextField segmentcostText = null;
    private JTextField drainText = null;
    private JTextField greenenergyText = null;
    private JTextField organicenergyText = null;
    private JTextField organicsubsText = null;
    private JTextField redprobText = null;
    private JTextField greenprobText = null;
    private JTextField blueprobText = null;
    private JTextField cyanprobText = null;
    private JTextField whiteprobText = null;
    private JTextField grayprobText = null;
    private JTextField yellowprobText = null;
    private JTextField decayenergyText = null;
    private JButton OKButton = null;
    private JButton cancelButton = null;
    private JButton defaultButton = null;
    protected MainWindow mainWindow;

    public ParamDialog(MainWindow parent) {
        super(parent, Messages.getString("T_PARAMETERS_CONFIGURATION"), true);
        this.mainWindow = parent;
        this.setDefaultCloseOperation(2);
        this.setComponents();
        this.pack();
        this.setResizable(false);
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParamDialog.this.checkParams();
                Utils.savePreferences();
                ParamDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParamDialog.this.dispose();
            }
        });
        this.defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParamDialog.this.defaultPreferences();
            }
        });
        this.setVisible(true);
    }

    protected void defaultPreferences() {
        this.widthText.setText(String.valueOf(1000));
        this.heightText.setText(String.valueOf(1000));
        this.delayText.setText(String.valueOf(50));
        this.rubbingText.setText(String.valueOf(0.98));
        this.elasticityText.setText(String.valueOf(0.8));
        this.initialnumberText.setText(String.valueOf(15));
        this.initialenergyText.setText(String.valueOf(50));
        this.initialO2Text.setText(String.valueOf(0.0));
        this.initialCO2Text.setText(String.valueOf(5000.0));
        this.maxageText.setText(String.valueOf(30));
        this.mutationrateText.setText(String.valueOf(0.05));
        this.segmentcostText.setText(String.valueOf(5000));
        this.drainText.setText(String.valueOf(5000));
        this.greenenergyText.setText(String.valueOf(500));
        this.organicenergyText.setText(String.valueOf(0.5));
        this.organicsubsText.setText(String.valueOf(0.1));
        this.redcostText.setText(String.valueOf(0.0));
        this.greencostText.setText(String.valueOf(0.0));
        this.bluecostText.setText(String.valueOf(0.0));
        this.cyancostText.setText(String.valueOf(0.0));
        this.whitecostText.setText(String.valueOf(1.0));
        this.graycostText.setText(String.valueOf(1.0));
        this.yellowcostText.setText(String.valueOf(0.0));
        this.redprobText.setText(String.valueOf(10));
        this.greenprobText.setText(String.valueOf(30));
        this.blueprobText.setText(String.valueOf(10));
        this.cyanprobText.setText(String.valueOf(20));
        this.whiteprobText.setText(String.valueOf(10));
        this.grayprobText.setText(String.valueOf(10));
        this.yellowprobText.setText(String.valueOf(10));
        this.decayenergyText.setText(String.valueOf(0.1));
        switch (0) {
            case 0: 
            case 2: 
            case 5: {
                this.hardwareNoneRadio.setSelected(true);
                this.hardwareFBObjectCheck.setSelected(false);
                this.hardwareFBObjectCheck.setEnabled(false);
                break;
            }
            case 1: 
            case 3: {
                this.hardwareOpenGLRadio.setSelected(true);
                this.hardwareFBObjectCheck.setSelected(false);
                break;
            }
            case 6: {
                this.hardwareOpenGLRadio.setSelected(true);
                this.hardwareFBObjectCheck.setSelected(true);
            }
        }
    }

    protected void setComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel buttonsPanel = new JPanel();
        this.OKButton = new JButton(Messages.getString("T_OK"));
        this.cancelButton = new JButton(Messages.getString("T_CANCEL"));
        this.defaultButton = new JButton(Messages.getString("T_DEFAULT_VALUES"));
        buttonsPanel.add(this.OKButton);
        buttonsPanel.add(this.cancelButton);
        buttonsPanel.add(this.defaultButton);
        this.getContentPane().add((Component)buttonsPanel, "South");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(Messages.getString("T_GENERAL"), this.setGeneralTab());
        tabbedPane.addTab(Messages.getString("T_WORLD"), this.setWorldTab());
        tabbedPane.addTab(Messages.getString("T_ORGANISMS"), this.setOrganismsTab());
        tabbedPane.addTab(Messages.getString("T_METABOLISM"), this.setMetabolismTab());
        tabbedPane.addTab(Messages.getString("T_GENES"), this.setGenesTab());
        this.getContentPane().add((Component)tabbedPane, "Center");
    }

    protected JPanel setGeneralTab() {
        JPanel generalPanel = new JPanel();
        generalPanel.setLayout(new BoxLayout(generalPanel, 1));
        JPanel panel = new JPanel();
        JLabel label = new JLabel(Messages.getString("T_LANGUAGE"));
        panel.add(label);
        this.localeCombo = new JComboBox<String>(Messages.getSupportedLocalesNames());
        this.localeCombo.setSelectedIndex(Messages.getLocaleIndex());
        panel.add(this.localeCombo);
        generalPanel.add(panel);
        panel = new JPanel();
        label = new JLabel(Messages.getString("T_TIME_PER_FRAME"));
        panel.add(label);
        this.delayText = new JTextField(Integer.toString(Utils.DELAY), 6);
        panel.add(this.delayText);
        label = new JLabel(Messages.getString("T_MILLISECONDS"));
        panel.add(label);
        generalPanel.add(panel);
        panel = new JPanel();
        panel.setLayout(new GridLayout(5, 1));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("T_HARDWARE_ACCELERATION")));
        this.hardwareNoneRadio = new JRadioButton(Messages.getString("T_NONE"));
        this.hardwareOpenGLRadio = new JRadioButton(Messages.getString("T_OPENGL"));
        this.hardwareFBObjectCheck = new JCheckBox(Messages.getString("T_DISABLE_FBOBJECT"));
        switch (Utils.HARDWARE_ACCELERATION) {
            case 0: {
                this.hardwareNoneRadio.setSelected(true);
                this.hardwareFBObjectCheck.setEnabled(false);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.hardwareOpenGLRadio.setSelected(true);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.hardwareOpenGLRadio.setSelected(true);
                this.hardwareFBObjectCheck.setSelected(true);
            }
        }
        this.hardwareGroup = new ButtonGroup();
        this.hardwareGroup.add(this.hardwareNoneRadio);
        this.hardwareGroup.add(this.hardwareOpenGLRadio);
        this.hardwareNoneRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ParamDialog.this.hardwareNoneRadio.isSelected()) {
                    ParamDialog.this.hardwareFBObjectCheck.setEnabled(false);
                } else {
                    ParamDialog.this.hardwareFBObjectCheck.setEnabled(true);
                }
            }
        });
        panel.add(this.hardwareNoneRadio);
        panel.add(this.hardwareOpenGLRadio);
        panel.add(this.hardwareFBObjectCheck);
        panel.add(new JLabel(Messages.getString("T_DIRECTX_IS_AUTOMATICALLY_DETECTED_AND_INITIALIZED")));
        panel.add(new JLabel(Messages.getString("T_APPLICATION_MUST_BE_RESTARTED_TO_APPLY_CHANGES")));
        generalPanel.add(panel);
        return generalPanel;
    }

    protected JPanel setWorldTab() {
        JPanel worldPanel = new JPanel();
        worldPanel.setLayout(new BoxLayout(worldPanel, 1));
        JPanel panel = new JPanel();
        JLabel label = new JLabel(Messages.getString("T_WIDTH"));
        panel.add(label);
        this.widthText = new JTextField(Integer.toString(Utils.WORLD_WIDTH), 6);
        panel.add(this.widthText);
        label = new JLabel(Messages.getString("T_HEIGHT"));
        panel.add(label);
        this.heightText = new JTextField(Integer.toString(Utils.WORLD_HEIGHT), 6);
        panel.add(this.heightText);
        worldPanel.add(panel);
        panel = new JPanel();
        label = new JLabel(Messages.getString("T_INITIAL_OXYGEN"));
        panel.add(label);
        this.initialO2Text = new JTextField(Double.toString(Utils.INITIAL_O2), 6);
        panel.add(this.initialO2Text);
        label = new JLabel(Messages.getString("T_INITIAL_CARBON_DIOXIDE"));
        panel.add(label);
        this.initialCO2Text = new JTextField(Double.toString(Utils.INITIAL_CO2), 6);
        panel.add(this.initialCO2Text);
        worldPanel.add(panel);
        panel = new JPanel();
        label = new JLabel(Messages.getString("T_RUBBING_COEFFICIENT"));
        panel.add(label);
        this.rubbingText = new JTextField(Double.toString(Utils.RUBBING), 6);
        panel.add(this.rubbingText);
        worldPanel.add(panel);
        panel = new JPanel();
        label = new JLabel(Messages.getString("T_ELASTICITY_COEFFICIENT"));
        panel.add(label);
        this.elasticityText = new JTextField(Double.toString(Utils.ELASTICITY), 6);
        panel.add(this.elasticityText);
        worldPanel.add(panel);
        return worldPanel;
    }

    protected JPanel setOrganismsTab() {
        JPanel organismsPanel = new JPanel();
        organismsPanel.setLayout(new BoxLayout(organismsPanel, 1));
        JPanel panel = new JPanel();
        JLabel label = new JLabel(Messages.getString("T_INITIAL_NUMBER"));
        panel.add(label);
        this.initialnumberText = new JTextField(Integer.toString(Utils.INITIAL_ORGANISMS), 6);
        panel.add(this.initialnumberText);
        label = new JLabel(Messages.getString("T_INITIAL_ENERGY"));
        panel.add(label);
        this.initialenergyText = new JTextField(Integer.toString(Utils.INITIAL_ENERGY), 6);
        panel.add(this.initialenergyText);
        organismsPanel.add(panel);
        panel = new JPanel();
        label = new JLabel(Messages.getString("T_LIFE_EXPECTANCY"));
        panel.add(label);
        this.maxageText = new JTextField(Integer.toString(Utils.MAX_AGE), 6);
        panel.add(this.maxageText);
        label = new JLabel(Messages.getString("T_MUTATION_PERCENTAGE"));
        panel.add(label);
        this.mutationrateText = new JTextField(Double.toString(Utils.MUTATION_RATE), 6);
        panel.add(this.mutationrateText);
        organismsPanel.add(panel);
        panel = new JPanel();
        label = new JLabel(Messages.getString("T_UPKEEP_COST_DIVISOR"));
        panel.add(label);
        this.segmentcostText = new JTextField(Integer.toString(Utils.SEGMENT_COST_DIVISOR), 6);
        panel.add(this.segmentcostText);
        organismsPanel.add(panel);
        panel = new JPanel();
        label = new JLabel(Messages.getString("T_SUBSTANCE_DRAINAGE_DIVISOR"));
        panel.add(label);
        this.drainText = new JTextField(Integer.toString(Utils.DRAIN_SUBS_DIVISOR), 6);
        panel.add(this.drainText);
        organismsPanel.add(panel);
        panel = new JPanel();
        label = new JLabel(Messages.getString("T_DECAY_ENERGY"));
        panel.add(label);
        this.decayenergyText = new JTextField(Double.toString(Utils.DECAY_ENERGY), 6);
        panel.add(this.decayenergyText);
        organismsPanel.add(panel);
        return organismsPanel;
    }

    protected JPanel setMetabolismTab() {
        JPanel metabolismPanel = new JPanel();
        metabolismPanel.setLayout(new BoxLayout(metabolismPanel, 1));
        JPanel panel = new JPanel();
        JLabel label = new JLabel(Messages.getString("T_PHOTOSYNTHETIC_METABOLISM"));
        label.setAlignmentX(0.5f);
        metabolismPanel.add(label);
        metabolismPanel.add(Box.createVerticalStrut(10));
        label = new JLabel(Messages.getString("T_OBTAINED_ENERGY_DIVISOR"));
        panel.add(label);
        this.greenenergyText = new JTextField(Integer.toString(Utils.GREEN_OBTAINED_ENERGY_DIVISOR), 6);
        panel.add(this.greenenergyText);
        metabolismPanel.add(panel);
        label = new JLabel(Messages.getString("T_CHEMOORGANOTROPHIC_METABOLISM"));
        label.setAlignmentX(0.5f);
        metabolismPanel.add(Box.createVerticalStrut(10));
        metabolismPanel.add(label);
        metabolismPanel.add(Box.createVerticalStrut(10));
        panel = new JPanel();
        label = new JLabel(Messages.getString("T_OBTAINED_ENERGY"));
        panel.add(label);
        this.organicenergyText = new JTextField(Double.toString(Utils.ORGANIC_OBTAINED_ENERGY), 6);
        panel.add(this.organicenergyText);
        metabolismPanel.add(panel);
        panel = new JPanel();
        label = new JLabel(Messages.getString("T_RELEASED_ENERGY_PROPORTION"));
        panel.add(label);
        this.organicsubsText = new JTextField(Double.toString(Utils.ORGANIC_SUBS_PRODUCED), 6);
        panel.add(this.organicsubsText);
        metabolismPanel.add(panel);
        return metabolismPanel;
    }

    protected JPanel setGenesTab() {
        JPanel genesPanel = new JPanel();
        genesPanel.setLayout(new GridLayout(8, 3));
        genesPanel.add(new JLabel(Messages.getString("T_COLOR2"), 0));
        genesPanel.add(new JLabel(Messages.getString("T_PROBABILITY"), 0));
        genesPanel.add(new JLabel(Messages.getString("T_COST"), 0));
        JLabel label = new JLabel(Messages.getString("T_RED"), 0);
        genesPanel.add(label);
        this.redprobText = new JTextField(Integer.toString(Utils.RED_PROB));
        genesPanel.add(this.redprobText);
        this.redcostText = new JTextField(Double.toString(Utils.RED_ENERGY_CONSUMPTION));
        genesPanel.add(this.redcostText);
        label = new JLabel(Messages.getString("T_GREEN"), 0);
        genesPanel.add(label);
        this.greenprobText = new JTextField(Integer.toString(Utils.GREEN_PROB));
        genesPanel.add(this.greenprobText);
        this.greencostText = new JTextField(Double.toString(Utils.GREEN_ENERGY_CONSUMPTION));
        genesPanel.add(this.greencostText);
        label = new JLabel(Messages.getString("T_BLUE"), 0);
        genesPanel.add(label);
        this.blueprobText = new JTextField(Integer.toString(Utils.BLUE_PROB));
        genesPanel.add(this.blueprobText);
        this.bluecostText = new JTextField(Double.toString(Utils.BLUE_ENERGY_CONSUMPTION));
        genesPanel.add(this.bluecostText);
        label = new JLabel(Messages.getString("T_CYAN"), 0);
        genesPanel.add(label);
        this.cyanprobText = new JTextField(Integer.toString(Utils.CYAN_PROB));
        genesPanel.add(this.cyanprobText);
        this.cyancostText = new JTextField(Double.toString(Utils.CYAN_ENERGY_CONSUMPTION));
        genesPanel.add(this.cyancostText);
        label = new JLabel(Messages.getString("T_WHITE"), 0);
        genesPanel.add(label);
        this.whiteprobText = new JTextField(Integer.toString(Utils.WHITE_PROB));
        genesPanel.add(this.whiteprobText);
        this.whitecostText = new JTextField(Double.toString(Utils.WHITE_ENERGY_CONSUMPTION));
        genesPanel.add(this.whitecostText);
        label = new JLabel(Messages.getString("T_GRAY"), 0);
        genesPanel.add(label);
        this.grayprobText = new JTextField(Integer.toString(Utils.GRAY_PROB));
        genesPanel.add(this.grayprobText);
        this.graycostText = new JTextField(Double.toString(Utils.GRAY_ENERGY_CONSUMPTION));
        genesPanel.add(this.graycostText);
        label = new JLabel(Messages.getString("T_YELLOW"), 0);
        genesPanel.add(label);
        this.yellowprobText = new JTextField(Integer.toString(Utils.YELLOW_PROB));
        genesPanel.add(this.yellowprobText);
        this.yellowcostText = new JTextField(Double.toString(Utils.YELLOW_ENERGY_CONSUMPTION));
        genesPanel.add(this.yellowcostText);
        return genesPanel;
    }

    void checkParams() {
        double d;
        int i;
        if (Messages.getLocaleIndex() != this.localeCombo.getSelectedIndex()) {
            Messages.setLocale(this.localeCombo.getSelectedIndex());
            this.mainWindow.changeLocale();
        }
        try {
            i = Integer.parseInt(this.widthText.getText());
            if (i > 0) {
                Utils.WORLD_WIDTH = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this.heightText.getText());
            if (i > 0) {
                Utils.WORLD_HEIGHT = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this.delayText.getText());
            if (i > 0) {
                Utils.DELAY = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            d = Double.parseDouble(this.initialO2Text.getText());
            if (d >= 0.0) {
                Utils.INITIAL_O2 = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            d = Double.parseDouble(this.initialCO2Text.getText());
            if (d >= 0.0) {
                Utils.INITIAL_CO2 = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            d = Double.parseDouble(this.rubbingText.getText());
            if (d >= 0.0 && d <= 1.0) {
                Utils.RUBBING = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            d = Double.parseDouble(this.elasticityText.getText());
            if (d >= 0.0 && d <= 1.0) {
                Utils.ELASTICITY = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this.initialnumberText.getText());
            if (i >= 0) {
                Utils.INITIAL_ORGANISMS = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this.initialenergyText.getText());
            if (i > 0) {
                Utils.INITIAL_ENERGY = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this.maxageText.getText());
            if (i > 0) {
                Utils.MAX_AGE = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            d = Double.parseDouble(this.mutationrateText.getText());
            if (d >= 0.0 && d <= 100.0) {
                Utils.MUTATION_RATE = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            d = Double.parseDouble(this.redcostText.getText());
            if (d >= 0.0) {
                Utils.RED_ENERGY_CONSUMPTION = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            d = Double.parseDouble(this.greencostText.getText());
            if (d >= 0.0) {
                Utils.GREEN_ENERGY_CONSUMPTION = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            d = Double.parseDouble(this.bluecostText.getText());
            if (d >= 0.0) {
                Utils.BLUE_ENERGY_CONSUMPTION = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            d = Double.parseDouble(this.cyancostText.getText());
            if (d >= 0.0) {
                Utils.CYAN_ENERGY_CONSUMPTION = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            d = Double.parseDouble(this.whitecostText.getText());
            if (d >= 0.0) {
                Utils.WHITE_ENERGY_CONSUMPTION = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            d = Double.parseDouble(this.graycostText.getText());
            if (d >= 0.0) {
                Utils.GRAY_ENERGY_CONSUMPTION = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            d = Double.parseDouble(this.yellowcostText.getText());
            if (d >= 0.0) {
                Utils.YELLOW_ENERGY_CONSUMPTION = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this.redprobText.getText());
            if (i >= 0) {
                Utils.RED_PROB = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this.greenprobText.getText());
            if (i > 0) {
                Utils.GREEN_PROB = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this.blueprobText.getText());
            if (i >= 0) {
                Utils.BLUE_PROB = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this.cyanprobText.getText());
            if (i >= 0) {
                Utils.CYAN_PROB = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this.whiteprobText.getText());
            if (i >= 0) {
                Utils.WHITE_PROB = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this.grayprobText.getText());
            if (i >= 0) {
                Utils.GRAY_PROB = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this.yellowprobText.getText());
            if (i >= 0) {
                Utils.YELLOW_PROB = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this.segmentcostText.getText());
            if (i > 0) {
                Utils.SEGMENT_COST_DIVISOR = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this.drainText.getText());
            if (i > 0) {
                Utils.DRAIN_SUBS_DIVISOR = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this.greenenergyText.getText());
            if (i > 0) {
                Utils.GREEN_OBTAINED_ENERGY_DIVISOR = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            d = Double.parseDouble(this.organicenergyText.getText());
            if (d >= 0.0) {
                Utils.ORGANIC_OBTAINED_ENERGY = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            d = Double.parseDouble(this.organicsubsText.getText());
            if (d >= 0.0 && d <= 1.0) {
                Utils.ORGANIC_SUBS_PRODUCED = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.hardwareNoneRadio.isSelected()) {
            Utils.setHardwareAcceleration(0);
        }
        if (this.hardwareOpenGLRadio.isSelected()) {
            if (this.hardwareFBObjectCheck.isSelected()) {
                if (Utils.HARDWARE_ACCELERATION < 4) {
                    Utils.setHardwareAcceleration(4);
                }
            } else if (Utils.HARDWARE_ACCELERATION != 0 && Utils.HARDWARE_ACCELERATION > 3) {
                Utils.setHardwareAcceleration(1);
            }
        }
    }
}

