/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.Gene;
import biogenesis.ThetaSpinnerModel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

class ThetaSpinner
extends JSpinner {
    private static final long serialVersionUID = 800L;
    private Gene _gene;

    public ThetaSpinner(Gene gene) {
        this._gene = gene;
        int initialValue = (int)Math.round(this._gene.getTheta() * 180.0 / Math.PI);
        while (initialValue < 0) {
            initialValue += 360;
        }
        while (initialValue > 359) {
            initialValue -= 360;
        }
        this.setModel(new ThetaSpinnerModel(initialValue, 0, 359, 1));
        this.setEditor(new JSpinner.NumberEditor((JSpinner)this, "##0"));
    }

    public Gene getGene() {
        return this._gene;
    }

    public void setGene(Gene gene) {
        this._gene = gene;
    }

    public double getTheta() {
        return ((SpinnerNumberModel)this.getModel()).getNumber().doubleValue() * Math.PI / 180.0;
    }
}

