/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import micropolisj.engine.CityDimension;
import micropolisj.engine.CityRect;
import micropolisj.engine.Micropolis;
import micropolisj.engine.MicropolisTool;
import micropolisj.engine.Sound;
import micropolisj.engine.TileConstants;
import micropolisj.engine.ToolEffectIfc;
import micropolisj.engine.ToolStroke;
import micropolisj.engine.TranslatedToolEffect;

class Bulldozer
extends ToolStroke {
    Bulldozer(Micropolis city, int xpos, int ypos) {
        super(city, MicropolisTool.BULLDOZER, xpos, ypos);
    }

    @Override
    protected void applyArea(ToolEffectIfc eff) {
        int x;
        int y;
        CityRect b = this.getBounds();
        for (y = 0; y < b.height; ++y) {
            for (x = 0; x < b.width; ++x) {
                TranslatedToolEffect subEff = new TranslatedToolEffect(eff, b.x + x, b.y + y);
                if (!this.city.isTileDozeable(subEff)) continue;
                this.dozeField(subEff);
            }
        }
        for (y = 0; y < b.height; ++y) {
            for (x = 0; x < b.width; ++x) {
                if (!TileConstants.isZoneCenter(eff.getTile(b.x + x, b.y + y))) continue;
                this.dozeZone(new TranslatedToolEffect(eff, b.x + x, b.y + y));
            }
        }
    }

    void dozeZone(ToolEffectIfc eff) {
        int currTile = eff.getTile(0, 0);
        assert (TileConstants.isZoneCenter(currTile));
        CityDimension dim = TileConstants.getZoneSizeFor(currTile);
        assert (dim != null);
        assert (dim.width >= 3);
        assert (dim.height >= 3);
        eff.spend(1);
        if (dim.width * dim.height < 16) {
            eff.makeSound(0, 0, Sound.EXPLOSION_HIGH);
        } else if (dim.width * dim.height < 36) {
            eff.makeSound(0, 0, Sound.EXPLOSION_LOW);
        } else {
            eff.makeSound(0, 0, Sound.EXPLOSION_BOTH);
        }
        this.putRubble(new TranslatedToolEffect(eff, -1, -1), dim.width, dim.height);
    }

    void dozeField(ToolEffectIfc eff) {
        int tile = eff.getTile(0, 0);
        if (TileConstants.isOverWater(tile)) {
            eff.setTile(0, 0, 2);
        } else {
            eff.setTile(0, 0, 0);
        }
        this.fixZone(eff);
        eff.spend(1);
    }

    void putRubble(ToolEffectIfc eff, int w, int h) {
        for (int yy = 0; yy < h; ++yy) {
            for (int xx = 0; xx < w; ++xx) {
                int tile = eff.getTile(xx, yy);
                if (tile == -1 || tile == 52 || tile == 0) continue;
                int z = this.inPreview ? 0 : this.city.PRNG.nextInt(3);
                int nTile = 860 + z;
                eff.setTile(xx, yy, nTile);
            }
        }
        this.fixBorder(eff, w, h);
    }
}

