/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import java.util.Random;
import micropolisj.engine.Micropolis;
import micropolisj.engine.TileConstants;

public class MapGenerator {
    Micropolis engine;
    char[][] map;
    Random PRNG;
    CreateIsland createIsland = CreateIsland.SELDOM;
    int treeLevel = -1;
    int curveLevel = -1;
    int lakeLevel = -1;
    int xStart;
    int yStart;
    int mapX;
    int mapY;
    int dir;
    int lastDir;
    static final char[][] BRMatrix = new char[][]{{'\u0000', '\u0000', '\u0000', '\u0003', '\u0003', '\u0003', '\u0000', '\u0000', '\u0000'}, {'\u0000', '\u0000', '\u0003', '\u0002', '\u0002', '\u0002', '\u0003', '\u0000', '\u0000'}, {'\u0000', '\u0003', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0003', '\u0000'}, {'\u0003', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0003'}, {'\u0003', '\u0002', '\u0002', '\u0002', '\u0004', '\u0002', '\u0002', '\u0002', '\u0003'}, {'\u0003', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0003'}, {'\u0000', '\u0003', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0003', '\u0000'}, {'\u0000', '\u0000', '\u0003', '\u0002', '\u0002', '\u0002', '\u0003', '\u0000', '\u0000'}, {'\u0000', '\u0000', '\u0000', '\u0003', '\u0003', '\u0003', '\u0000', '\u0000', '\u0000'}};
    static final char[][] SRMatrix = new char[][]{{'\u0000', '\u0000', '\u0003', '\u0003', '\u0000', '\u0000'}, {'\u0000', '\u0003', '\u0002', '\u0002', '\u0003', '\u0000'}, {'\u0003', '\u0002', '\u0002', '\u0002', '\u0002', '\u0003'}, {'\u0003', '\u0002', '\u0002', '\u0002', '\u0002', '\u0003'}, {'\u0000', '\u0003', '\u0002', '\u0002', '\u0003', '\u0000'}, {'\u0000', '\u0000', '\u0003', '\u0003', '\u0000', '\u0000'}};
    static final char[] REdTab = new char[]{'\r', '\r', '\u0011', '\u000f', '\u0005', '\u0002', '\u0013', '\u0011', '\t', '\u000b', '\u0002', '\r', '\u0007', '\t', '\u0005', '\u0002'};
    static final int[] DIRECTION_TABX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    static final int[] DIRECTION_TABY = new int[]{-1, -1, 0, 1, 1, 1, 0, -1};
    static final int[] DX = new int[]{-1, 0, 1, 0};
    static final int[] DY = new int[]{0, 1, 0, -1};
    static final char[] TEdTab = new char[]{'\u0000', '\u0000', '\u0000', '\"', '\u0000', '\u0000', '$', '#', '\u0000', ' ', '\u0000', '!', '\u001e', '\u001f', '\u001d', '%'};

    public MapGenerator(Micropolis engine) {
        assert (engine != null);
        this.engine = engine;
        this.map = engine.map;
    }

    private int getWidth() {
        return this.map[0].length;
    }

    private int getHeight() {
        return this.map.length;
    }

    public void generateNewCity() {
        long r = Micropolis.DEFAULT_PRNG.nextLong();
        this.generateSomeCity(r);
    }

    public void generateSomeCity(long r) {
        this.generateMap(r);
        this.engine.fireWholeMapChanged();
    }

    void generateMap(long r) {
        this.PRNG = new Random(r);
        if (this.createIsland == CreateIsland.SELDOM && this.PRNG.nextInt(100) < 10) {
            this.makeIsland();
            return;
        }
        if (this.createIsland == CreateIsland.ALWAYS) {
            this.makeNakedIsland();
        } else {
            this.clearMap();
        }
        this.getRandStart();
        if (this.curveLevel != 0) {
            this.doRivers();
        }
        if (this.lakeLevel != 0) {
            this.makeLakes();
        }
        this.smoothRiver();
        if (this.treeLevel != 0) {
            this.doTrees();
        }
    }

    private void makeIsland() {
        this.makeNakedIsland();
        this.smoothRiver();
        this.doTrees();
    }

    private int erand(int limit) {
        return Math.min(this.PRNG.nextInt(limit), this.PRNG.nextInt(limit));
    }

    private void makeNakedIsland() {
        int x;
        int y;
        int ISLAND_RADIUS = 18;
        int WORLD_X = this.getWidth();
        int WORLD_Y = this.getHeight();
        for (y = 0; y < WORLD_Y; ++y) {
            for (x = 0; x < WORLD_X; ++x) {
                this.map[y][x] = 2;
            }
        }
        for (y = 5; y < WORLD_Y - 5; ++y) {
            for (x = 5; x < WORLD_X - 5; ++x) {
                this.map[y][x] = '\u0000';
            }
        }
        for (int x2 = 0; x2 < WORLD_X - 5; x2 += 2) {
            this.mapX = x2;
            this.mapY = this.erand(19);
            this.BRivPlop();
            this.mapY = WORLD_Y - 10 - this.erand(19);
            this.BRivPlop();
            this.mapY = 0;
            this.SRivPlop();
            this.mapY = WORLD_Y - 6;
            this.SRivPlop();
        }
        for (y = 0; y < WORLD_Y - 5; y += 2) {
            this.mapY = y;
            this.mapX = this.erand(19);
            this.BRivPlop();
            this.mapX = WORLD_X - 10 - this.erand(19);
            this.BRivPlop();
            this.mapX = 0;
            this.SRivPlop();
            this.mapX = WORLD_X - 6;
            this.SRivPlop();
        }
    }

    private void clearMap() {
        for (int y = 0; y < this.map.length; ++y) {
            for (int x = 0; x < this.map[y].length; ++x) {
                this.map[y][x] = '\u0000';
            }
        }
    }

    private void getRandStart() {
        this.xStart = 40 + this.PRNG.nextInt(this.getWidth() - 79);
        this.yStart = 33 + this.PRNG.nextInt(this.getHeight() - 66);
        this.mapX = this.xStart;
        this.mapY = this.yStart;
    }

    private void makeLakes() {
        int lim1 = this.lakeLevel < 0 ? this.PRNG.nextInt(11) : this.lakeLevel / 2;
        for (int t = 0; t < lim1; ++t) {
            int x = this.PRNG.nextInt(this.getWidth() - 20) + 10;
            int y = this.PRNG.nextInt(this.getHeight() - 19) + 10;
            int lim2 = this.PRNG.nextInt(13) + 2;
            for (int z = 0; z < lim2; ++z) {
                this.mapX = x - 6 + this.PRNG.nextInt(13);
                this.mapY = y - 6 + this.PRNG.nextInt(13);
                if (this.PRNG.nextInt(5) != 0) {
                    this.SRivPlop();
                    continue;
                }
                this.BRivPlop();
            }
        }
    }

    private void doRivers() {
        this.dir = this.lastDir = this.PRNG.nextInt(4);
        this.doBRiv();
        this.mapX = this.xStart;
        this.mapY = this.yStart;
        this.dir = this.lastDir ^= 4;
        this.doBRiv();
        this.mapX = this.xStart;
        this.mapY = this.yStart;
        this.lastDir = this.PRNG.nextInt(4);
        this.doSRiv();
    }

    private void doBRiv() {
        int r2;
        int r1;
        if (this.curveLevel < 0) {
            r1 = 100;
            r2 = 200;
        } else {
            r1 = this.curveLevel + 10;
            r2 = this.curveLevel + 100;
        }
        while (this.engine.testBounds(this.mapX + 4, this.mapY + 4)) {
            this.BRivPlop();
            if (this.PRNG.nextInt(r1 + 1) < 10) {
                this.dir = this.lastDir;
            } else {
                if (this.PRNG.nextInt(r2 + 1) > 90) {
                    ++this.dir;
                }
                if (this.PRNG.nextInt(r2 + 1) > 90) {
                    --this.dir;
                }
            }
            this.moveMap(this.dir);
        }
    }

    private void doSRiv() {
        int r2;
        int r1;
        if (this.curveLevel < 0) {
            r1 = 100;
            r2 = 200;
        } else {
            r1 = this.curveLevel + 10;
            r2 = this.curveLevel + 100;
        }
        while (this.engine.testBounds(this.mapX + 3, this.mapY + 3)) {
            this.SRivPlop();
            if (this.PRNG.nextInt(r1 + 1) < 10) {
                this.dir = this.lastDir;
            } else {
                if (this.PRNG.nextInt(r2 + 1) > 90) {
                    ++this.dir;
                }
                if (this.PRNG.nextInt(r2 + 1) > 90) {
                    --this.dir;
                }
            }
            this.moveMap(this.dir);
        }
    }

    private void BRivPlop() {
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 9; ++y) {
                this.putOnMap(BRMatrix[y][x], x, y);
            }
        }
    }

    private void SRivPlop() {
        for (int x = 0; x < 6; ++x) {
            for (int y = 0; y < 6; ++y) {
                this.putOnMap(SRMatrix[y][x], x, y);
            }
        }
    }

    private void putOnMap(char mapChar, int xoff, int yoff) {
        if (mapChar == '\u0000') {
            return;
        }
        int xloc = this.mapX + xoff;
        int yloc = this.mapY + yoff;
        if (!this.engine.testBounds(xloc, yloc)) {
            return;
        }
        char tmp = this.map[yloc][xloc];
        if (tmp != '\u0000') {
            if ((tmp = (char)(tmp & 0x3FF)) == '\u0002' && mapChar != '\u0004') {
                return;
            }
            if (tmp == '\u0004') {
                return;
            }
        }
        this.map[yloc][xloc] = mapChar;
    }

    private void smoothRiver() {
        for (int mapY = 0; mapY < this.map.length; ++mapY) {
            for (int mapX = 0; mapX < this.map[mapY].length; ++mapX) {
                if (this.map[mapY][mapX] != '\u0003') continue;
                int bitindex = 0;
                for (int z = 0; z < 4; ++z) {
                    bitindex <<= 1;
                    int xtem = mapX + DX[z];
                    int ytem = mapY + DY[z];
                    if (!this.engine.testBounds(xtem, ytem) || (this.map[ytem][xtem] & 0x3FF) == 0 || (this.map[ytem][xtem] & 0x3FF) >= 21 && (this.map[ytem][xtem] & 0x3FF) <= 39) continue;
                    bitindex |= 1;
                }
                char temp = REdTab[bitindex & 0xF];
                if (temp != '\u0002' && this.PRNG.nextInt(2) != 0) {
                    temp = (char)(temp + '\u0001');
                }
                this.map[mapY][mapX] = temp;
            }
        }
    }

    private void doTrees() {
        int amount = this.treeLevel < 0 ? this.PRNG.nextInt(101) + 50 : this.treeLevel + 3;
        for (int x = 0; x < amount; ++x) {
            int xloc = this.PRNG.nextInt(this.getWidth());
            int yloc = this.PRNG.nextInt(this.getHeight());
            this.treeSplash(xloc, yloc);
        }
        this.smoothTrees();
        this.smoothTrees();
    }

    private void treeSplash(int xloc, int yloc) {
        int dis = this.treeLevel < 0 ? this.PRNG.nextInt(151) + 50 : this.PRNG.nextInt(101 + this.treeLevel * 2) + 50;
        this.mapX = xloc;
        this.mapY = yloc;
        for (int z = 0; z < dis; ++z) {
            int dir = this.PRNG.nextInt(8);
            this.moveMap(dir);
            if (!this.engine.testBounds(this.mapX, this.mapY)) {
                return;
            }
            if ((this.map[this.mapY][this.mapX] & 0x3FF) != 0) continue;
            this.map[this.mapY][this.mapX] = 37;
        }
    }

    private void moveMap(int dir) {
        this.mapX += DIRECTION_TABX[dir &= 7];
        this.mapY += DIRECTION_TABY[dir];
    }

    private void smoothTrees() {
        for (int mapY = 0; mapY < this.map.length; ++mapY) {
            for (int mapX = 0; mapX < this.map[mapY].length; ++mapX) {
                if (!TileConstants.isTree(this.map[mapY][mapX])) continue;
                int bitindex = 0;
                for (int z = 0; z < 4; ++z) {
                    bitindex <<= 1;
                    int xtem = mapX + DX[z];
                    int ytem = mapY + DY[z];
                    if (!this.engine.testBounds(xtem, ytem) || !TileConstants.isTree(this.map[ytem][xtem])) continue;
                    bitindex |= 1;
                }
                char temp = TEdTab[bitindex & 0xF];
                if (temp != '\u0000') {
                    if (temp != '%' && (mapX + mapY & 1) != 0) {
                        temp = (char)(temp - 8);
                    }
                    this.map[mapY][mapX] = temp;
                    continue;
                }
                this.map[mapY][mapX] = temp;
            }
        }
    }

    static enum CreateIsland {
        NEVER,
        ALWAYS,
        SELDOM;

    }
}

