/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import micropolisj.engine.CityLocation;
import micropolisj.engine.Micropolis;
import micropolisj.engine.MicropolisMessage;
import micropolisj.engine.Sound;
import micropolisj.engine.SpriteKind;
import micropolisj.engine.TileConstants;

public abstract class Sprite {
    Micropolis city;
    public SpriteKind kind;
    public int offx;
    public int offy;
    public int width = 32;
    public int height = 32;
    public int frame;
    public int x;
    public int y;
    public int lastX;
    public int lastY;
    int dir;

    protected Sprite(Micropolis engine, SpriteKind kind) {
        this.city = engine;
        this.kind = kind;
    }

    protected final int getChar(int x, int y) {
        int xpos = x / 16;
        int ypos = y / 16;
        if (this.city.testBounds(xpos, ypos)) {
            return this.city.getTile(xpos, ypos);
        }
        return -1;
    }

    protected abstract void moveImpl();

    public final void move() {
        this.lastX = this.x;
        this.lastY = this.y;
        this.moveImpl();
        this.city.fireSpriteMoved(this);
    }

    public final boolean isVisible() {
        return this.frame != 0;
    }

    static final int getDir(int orgX, int orgY, int desX, int desY) {
        int[] Gdtab = new int[]{0, 3, 2, 1, 3, 4, 5, 7, 6, 5, 7, 8, 1};
        int dispX = desX - orgX;
        int dispY = desY - orgY;
        int z = dispX < 0 ? (dispY < 0 ? 11 : 8) : (dispY < 0 ? 2 : 5);
        dispX = Math.abs(dispX);
        dispY = Math.abs(dispY);
        int absDist = dispX + dispY;
        if (dispX * 2 < dispY) {
            ++z;
        } else if (dispY * 2 < dispX) {
            --z;
        }
        if (z >= 1 && z <= 12) {
            return Gdtab[z];
        }
        assert (false);
        return 0;
    }

    static final int getDis(int x0, int y0, int x1, int y1) {
        return Math.abs(x0 - x1) + Math.abs(y0 - y1);
    }

    final void explodeSprite() {
        this.frame = 0;
        this.city.makeExplosionAt(this.x, this.y);
        int xpos = this.x / 16;
        int ypos = this.y / 16;
        switch (this.kind) {
            case AIR: {
                this.city.crashLocation = new CityLocation(xpos, ypos);
                this.city.sendMessageAt(MicropolisMessage.PLANECRASH_REPORT, xpos, ypos);
                break;
            }
            case SHI: {
                this.city.crashLocation = new CityLocation(xpos, ypos);
                this.city.sendMessageAt(MicropolisMessage.SHIPWRECK_REPORT, xpos, ypos);
                break;
            }
            case TRA: 
            case BUS: {
                this.city.crashLocation = new CityLocation(xpos, ypos);
                this.city.sendMessageAt(MicropolisMessage.TRAIN_CRASH_REPORT, xpos, ypos);
                break;
            }
            case COP: {
                this.city.crashLocation = new CityLocation(xpos, ypos);
                this.city.sendMessageAt(MicropolisMessage.COPTER_CRASH_REPORT, xpos, ypos);
            }
        }
        this.city.makeSound(xpos, ypos, Sound.EXPLOSION_HIGH);
    }

    final boolean checkSpriteCollision(Sprite otherSprite) {
        if (!this.isVisible()) {
            return false;
        }
        if (!otherSprite.isVisible()) {
            return false;
        }
        return Sprite.getDis(this.x, this.y, otherSprite.x, otherSprite.y) < 30;
    }

    final void destroyTile(int xpos, int ypos) {
        if (!this.city.testBounds(xpos, ypos)) {
            return;
        }
        char t = this.city.getTile(xpos, ypos);
        if (t >= '\u0015') {
            if (TileConstants.isBridge(t)) {
                this.city.setTile(xpos, ypos, '\u0002');
                return;
            }
            if (!TileConstants.isCombustible(t)) {
                return;
            }
            if (TileConstants.isZoneCenter(t)) {
                this.city.killZone(xpos, ypos, t);
                if (t > '\u0109') {
                    this.city.makeExplosion(xpos, ypos);
                }
            }
            if (TileConstants.checkWet(t)) {
                this.city.setTile(xpos, ypos, '\u0002');
            } else {
                this.city.setTile(xpos, ypos, '\u035c');
            }
        }
    }

    static final int turnTo(int p, int d) {
        if (p == d) {
            return p;
        }
        p = p < d ? (d - p < 4 ? ++p : --p) : (p - d < 4 ? --p : ++p);
        if (p > 8) {
            return 1;
        }
        if (p < 1) {
            return 8;
        }
        return p;
    }
}

