/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import micropolisj.engine.CityRect;
import micropolisj.engine.Sound;
import micropolisj.engine.ToolEffectIfc;
import micropolisj.engine.ToolResult;

public class ToolPreview
implements ToolEffectIfc {
    public int offsetX;
    public int offsetY;
    public short[][] tiles = new short[0][0];
    public int cost;
    public ToolResult toolResult;
    public List<SoundInfo> sounds = new ArrayList<SoundInfo>();

    ToolPreview() {
        this.toolResult = ToolResult.NONE;
    }

    @Override
    public int getTile(int dx, int dy) {
        if (this.inRange(dx, dy)) {
            return this.tiles[this.offsetY + dy][this.offsetX + dx];
        }
        return -1;
    }

    public CityRect getBounds() {
        return new CityRect(-this.offsetX, -this.offsetY, this.getWidth(), this.getHeight());
    }

    int getWidth() {
        return this.tiles.length != 0 ? this.tiles[0].length : 0;
    }

    int getHeight() {
        return this.tiles.length;
    }

    boolean inRange(int dx, int dy) {
        return this.offsetY + dy >= 0 && this.offsetY + dy < this.getHeight() && this.offsetX + dx >= 0 && this.offsetX + dx < this.getWidth();
    }

    void expandTo(int dx, int dy) {
        int newLen;
        if (this.tiles == null || this.tiles.length == 0) {
            this.tiles = new short[1][1];
            this.tiles[0][0] = -1;
            this.offsetX = -dx;
            this.offsetY = -dy;
            return;
        }
        for (int i = 0; i < this.tiles.length; ++i) {
            short[] A = this.tiles[i];
            if (this.offsetX + dx >= A.length) {
                newLen = this.offsetX + dx + 1;
                short[] AA = new short[newLen];
                System.arraycopy(A, 0, AA, 0, A.length);
                Arrays.fill(AA, A.length, newLen, (short)-1);
                this.tiles[i] = AA;
                continue;
            }
            if (this.offsetX + dx >= 0) continue;
            int addl = -(this.offsetX + dx);
            int newLen2 = A.length + addl;
            short[] AA = new short[newLen2];
            System.arraycopy(A, 0, AA, addl, A.length);
            Arrays.fill(AA, 0, addl, (short)-1);
            this.tiles[i] = AA;
        }
        if (this.offsetX + dx < 0) {
            int addl = -(this.offsetX + dx);
            this.offsetX += addl;
        }
        int width = this.tiles[0].length;
        if (this.offsetY + dy >= this.tiles.length) {
            int newLen3 = this.offsetY + dy + 1;
            short[][] newTiles = new short[newLen3][width];
            System.arraycopy(this.tiles, 0, newTiles, 0, this.tiles.length);
            for (int i = this.tiles.length; i < newLen3; ++i) {
                Arrays.fill(newTiles[i], (short)-1);
            }
            this.tiles = newTiles;
        } else if (this.offsetY + dy < 0) {
            int addl = -(this.offsetY + dy);
            newLen = this.tiles.length + addl;
            short[][] newTiles = new short[newLen][width];
            System.arraycopy(this.tiles, 0, newTiles, addl, this.tiles.length);
            for (int i = 0; i < addl; ++i) {
                Arrays.fill(newTiles[i], (short)-1);
            }
            this.tiles = newTiles;
            this.offsetY += addl;
        }
    }

    @Override
    public void makeSound(int dx, int dy, Sound sound) {
        this.sounds.add(new SoundInfo(dx, dy, sound));
    }

    @Override
    public void setTile(int dx, int dy, int tileValue) {
        this.expandTo(dx, dy);
        this.tiles[this.offsetY + dy][this.offsetX + dx] = (short)tileValue;
    }

    @Override
    public void spend(int amount) {
        this.cost += amount;
    }

    @Override
    public void toolResult(ToolResult tr) {
        this.toolResult = tr;
    }

    public static class SoundInfo {
        public int x;
        public int y;
        public Sound sound;

        SoundInfo(int x, int y, Sound sound) {
            this.x = x;
            this.y = y;
            this.sound = sound;
        }
    }
}

