/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;

class StringsModel
extends AbstractTableModel {
    StringInfo[] strings;
    ArrayList<MyLocaleInfo> locales = new ArrayList();
    static final String[] FILES = new String[]{"CityMessages", "CityStrings", "GuiStrings", "StatusMessages"};
    File workingDirectory = new File(new File(System.getProperty("user.home")), "micropolis-translations");

    StringsModel() throws IOException {
        ArrayList<StringInfo> ss = new ArrayList<StringInfo>();
        for (String f : FILES) {
            StringsModel.loadStrings(f, ss);
        }
        this.strings = ss.toArray(new StringInfo[0]);
    }

    static void loadStrings(String file, ArrayList<StringInfo> ss) throws IOException {
        Properties p = new Properties();
        p.load(StringsModel.class.getResourceAsStream("/micropolisj/" + file + ".properties"));
        Object[] propNames = p.keySet().toArray(new String[0]);
        Arrays.sort(propNames);
        for (Object propName : propNames) {
            StringInfo si = new StringInfo(file, (String)propName);
            ss.add(si);
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        StringInfo si = this.strings[row];
        if (col == 0) {
            return si.id;
        }
        MyLocaleInfo l = this.locales.get(col - 1);
        Properties p = l.propsMap.get(si.file);
        return p.getProperty(si.id);
    }

    @Override
    public int getRowCount() {
        return this.strings.length;
    }

    @Override
    public int getColumnCount() {
        return 1 + this.locales.size();
    }

    public Class getColumnClass(int col) {
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "String";
        }
        MyLocaleInfo l = this.locales.get(col - 1);
        return l.code != null ? l.code : "C";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        MyLocaleInfo l = this.locales.get(col - 1);
        return l.code != null;
    }

    @Override
    public void setValueAt(Object aValue, int row, int col) {
        StringInfo si = this.strings[row];
        if (col == 0) {
            return;
        }
        MyLocaleInfo l = this.locales.get(col - 1);
        Properties p = l.propsMap.get(si.file);
        p.setProperty(si.id, (String)aValue);
        l.dirty = true;
    }

    File getPFile(String file, String localeCode) {
        File d = new File(this.workingDirectory, "micropolisj");
        return new File(d, file + (localeCode != null ? "_" + localeCode : "") + ".properties");
    }

    void addLocale(String localeCode) throws IOException {
        MyLocaleInfo li = new MyLocaleInfo(localeCode);
        for (String file : FILES) {
            File f;
            Properties p = new Properties();
            String s = "/micropolisj/" + file + (localeCode != null ? "_" + localeCode : "") + ".properties";
            InputStream in = this.getClass().getResourceAsStream(s);
            if (in != null) {
                p.load(in);
            }
            if ((f = this.getPFile(file, localeCode)).exists()) {
                p.load(new FileInputStream(f));
            }
            li.propsMap.put(file, p);
        }
        this.locales.add(li);
        this.fireTableStructureChanged();
    }

    String[] getAllLocaleCodes() {
        String[] rv = new String[this.locales.size()];
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = this.locales.get((int)i).code;
        }
        return rv;
    }

    void removeLocale(String localeCode) {
        assert (localeCode != null);
        boolean found = false;
        for (int i = this.locales.size() - 1; i >= 0; --i) {
            String loc = this.locales.get((int)i).code;
            if (!localeCode.equals(loc)) continue;
            this.locales.remove(i);
            found = true;
        }
        if (found) {
            this.fireTableStructureChanged();
        }
    }

    void makeDirectories(File f) throws IOException {
        File d = f.getParentFile();
        if (d != null) {
            d.mkdirs();
        }
    }

    void save() throws IOException {
        for (MyLocaleInfo l : this.locales) {
            if (!l.dirty) continue;
            for (String file : FILES) {
                Properties p = l.propsMap.get(file);
                File f = this.getPFile(file, l.code);
                this.makeDirectories(f);
                p.store(new FileOutputStream(f), l.code);
            }
            l.dirty = false;
        }
    }

    static class StringInfo {
        String file;
        String id;

        StringInfo(String file, String id) {
            this.file = file;
            this.id = id;
        }
    }

    static class MyLocaleInfo {
        String code;
        HashMap<String, Properties> propsMap = new HashMap();
        boolean dirty;

        MyLocaleInfo(String code) {
            this.code = code;
        }
    }
}

