/*
 * Decompiled with CFR 0.152.
 */
package solarex.ship;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import solarex.galaxy.Galaxy;
import solarex.quest.Delivery;
import solarex.quest.Quest;
import solarex.ship.Ship;
import solarex.system.Solar;

public class Player {
    private String name = "";
    private final HashMap<String, Long> explorationTable = new HashMap();
    private boolean explorerMode = true;
    private final ArrayList<Quest> quests = new ArrayList();

    public void setExplorerMode(boolean yesno) {
        this.explorerMode = yesno;
    }

    public boolean canInspect(Solar body) {
        return !this.explorerMode;
    }

    public boolean isExplored(Solar body) {
        if (this.explorerMode) {
            boolean explored;
            if (body.btype == Solar.BodyType.SUN) {
                return true;
            }
            String key = this.makeKey(body);
            Long o = this.explorationTable.get(key);
            boolean bl = explored = o != null;
            if (!explored && body.society != null) {
                int i = body.loca.galacticSectorI;
                int j = body.loca.galacticSectorJ;
                double dist = Math.sqrt(i * i + j * j);
                int pop = body.society.population;
                if (body.children.size() > 0) {
                    Solar station = body.children.get(body.children.size() - 1);
                    if (station.btype == Solar.BodyType.STATION) {
                        pop += station.society.population;
                    }
                }
                if ((double)(pop + 1000000) > dist * 100000.0) {
                    explored = true;
                }
            }
            return explored;
        }
        return true;
    }

    public void setExplored(Solar body, int bit) {
        if (bit >= 0 && bit <= 63) {
            String key = this.makeKey(body);
            Long exploredBits = this.explorationTable.get(key);
            exploredBits = exploredBits == null ? new Long(1L << bit) : Long.valueOf(exploredBits | 1L << bit);
            System.err.printf("Grid %d, bits %x\n", bit, exploredBits);
            this.explorationTable.put(key, exploredBits);
        }
    }

    public void addQuest(Quest quest) {
        this.quests.add(quest);
    }

    public void removeQuest(Quest quest) {
        this.quests.remove(quest);
    }

    public ArrayList<Quest> getQuests() {
        return this.quests;
    }

    private String makeKey(Solar body) {
        String key = body.name + ":" + body.seed + ":" + body.loca.galacticSectorI + ":" + body.loca.galacticSectorJ + ":" + body.loca.systemNumber + ":" + body.loca.systemSeed;
        return key;
    }

    public void save(Writer writer) throws IOException {
        writer.write("<Player>\n");
        writer.write("<version>1</version>\n");
        writer.write("<name>" + this.name + "</name>\n");
        writer.write("<i>" + this.quests.size() + "</i>\n");
        for (Quest quest : this.quests) {
            writer.write("<questType>" + quest.getClass().getName() + "</questType>\n");
            quest.save(writer);
        }
        Set<String> keys = this.explorationTable.keySet();
        for (String key : keys) {
            Long value = this.explorationTable.get(key);
            writer.write("<exploration key='" + key + "'>" + value + "</exploration>\n");
        }
        writer.write("</Player>\n");
    }

    public void load(BufferedReader reader) throws IOException {
        reader.readLine();
        reader.readLine();
        this.name = reader.readLine();
        String tmp = reader.readLine();
        int questCount = Integer.parseInt(tmp.substring(3, tmp.length() - 4));
        for (int i = 0; i < questCount; ++i) {
            tmp = reader.readLine();
            if (!tmp.contains("Delivery")) {
                throw new IOException("Unknown quest type: " + tmp);
            }
            Delivery delivery = new Delivery(reader);
            this.quests.add(delivery);
        }
        tmp = reader.readLine();
        while (!"</Player>".equals(tmp)) {
            int p1 = tmp.indexOf("key='") + 5;
            int p2 = tmp.indexOf("'", p1);
            String key = tmp.substring(p1, p2);
            int p3 = p2 + 2;
            int p4 = tmp.indexOf(60, p3);
            String value = tmp.substring(p3, p4);
            System.err.println("Exploration key=" + key + " value=" + value);
            this.explorationTable.put(key, Long.parseLong(value));
            tmp = reader.readLine();
        }
        reader.readLine();
    }

    void testQuests(Galaxy galaxy, Solar station, Ship ship) {
        ArrayList<Quest> killList = new ArrayList<Quest>();
        for (Quest quest : this.quests) {
            boolean ok = quest.testSolved(galaxy, station, ship);
            if (!ok) continue;
            quest.showSuccessMessage(null);
            killList.add(quest);
        }
        this.quests.removeAll(killList);
    }
}

