/*
 * Decompiled with CFR 0.152.
 */
package solarex.ship.components;

import solarex.ship.components.Equipment;
import solarex.ship.components.EquipmentAspect;
import solarex.ship.components.EquipmentType;
import solarex.ship.components.ShipComponent;

public class EquipmentFactory {
    public ShipComponent create(Component what) {
        Equipment equipment = new Equipment();
        switch (what) {
            case SINGLE_PASSENGER_CABIN: {
                equipment.setAspect(EquipmentAspect.NAME, "<Living in a Box> Single Passenger Cabin");
                equipment.setAspect(EquipmentAspect.WEIGHT, 2);
                equipment.setAspect(EquipmentAspect.CARGO_CAPACITY, 0);
                equipment.setAspect(EquipmentAspect.PASSENGER_CAPACITY, 1);
                equipment.setAspect(EquipmentAspect.HYPERJUMP_RANGE, 0);
                equipment.setAspect(EquipmentAspect.BASE_PRICE, 1000);
                equipment.setAspect(EquipmentAspect.TYPE, (Object)EquipmentType.OTHER);
                break;
            }
            case DOUBLE_PASSENGER_CABIN: {
                equipment.setAspect(EquipmentAspect.NAME, "<A Box for Two> Double Passenger Cabin");
                equipment.setAspect(EquipmentAspect.WEIGHT, 3);
                equipment.setAspect(EquipmentAspect.CARGO_CAPACITY, 0);
                equipment.setAspect(EquipmentAspect.PASSENGER_CAPACITY, 2);
                equipment.setAspect(EquipmentAspect.HYPERJUMP_RANGE, 0);
                equipment.setAspect(EquipmentAspect.BASE_PRICE, 1500);
                equipment.setAspect(EquipmentAspect.TYPE, (Object)EquipmentType.OTHER);
                break;
            }
            case LUXURY_PASSENGER_CABIN: {
                equipment.setAspect(EquipmentAspect.NAME, "<Eden II> Luxurous Passenger Cabin");
                equipment.setAspect(EquipmentAspect.WEIGHT, 3);
                equipment.setAspect(EquipmentAspect.CARGO_CAPACITY, 0);
                equipment.setAspect(EquipmentAspect.PASSENGER_CAPACITY, 1);
                equipment.setAspect(EquipmentAspect.HYPERJUMP_RANGE, 0);
                equipment.setAspect(EquipmentAspect.BASE_PRICE, 2000);
                equipment.setAspect(EquipmentAspect.TYPE, (Object)EquipmentType.OTHER);
                break;
            }
            case STANDARD_DRIVE: {
                equipment.setAspect(EquipmentAspect.NAME, "<Tenclon Motors Standard> Jump Drive");
                equipment.setAspect(EquipmentAspect.WEIGHT, 10);
                equipment.setAspect(EquipmentAspect.CARGO_CAPACITY, 0);
                equipment.setAspect(EquipmentAspect.PASSENGER_CAPACITY, 0);
                equipment.setAspect(EquipmentAspect.HYPERJUMP_RANGE, 10);
                equipment.setAspect(EquipmentAspect.BASE_PRICE, 23000);
                equipment.setAspect(EquipmentAspect.TYPE, (Object)EquipmentType.MACHINE);
                break;
            }
            case TROMPETECHOS: {
                equipment.setAspect(EquipmentAspect.NAME, "<Trompetechos Dual> Gas Filtration Drone");
                equipment.setAspect(EquipmentAspect.WEIGHT, 5);
                equipment.setAspect(EquipmentAspect.CARGO_CAPACITY, 0);
                equipment.setAspect(EquipmentAspect.PASSENGER_CAPACITY, 0);
                equipment.setAspect(EquipmentAspect.HYPERJUMP_RANGE, 0);
                equipment.setAspect(EquipmentAspect.BASE_PRICE, 8000);
                equipment.setAspect(EquipmentAspect.TYPE, (Object)EquipmentType.DRONE);
                equipment.setAspect(EquipmentAspect.MIN_OPERATING_TEMP, 100);
                equipment.setAspect(EquipmentAspect.MAX_OPERATING_TEMP, 800);
                break;
            }
            case FANFOSTAR: {
                equipment.setAspect(EquipmentAspect.NAME, "<Fanfostar Chorus-12> Gas Filtration Drone");
                equipment.setAspect(EquipmentAspect.WEIGHT, 5);
                equipment.setAspect(EquipmentAspect.CARGO_CAPACITY, 0);
                equipment.setAspect(EquipmentAspect.PASSENGER_CAPACITY, 0);
                equipment.setAspect(EquipmentAspect.HYPERJUMP_RANGE, 0);
                equipment.setAspect(EquipmentAspect.BASE_PRICE, 10000);
                equipment.setAspect(EquipmentAspect.TYPE, (Object)EquipmentType.DRONE);
                equipment.setAspect(EquipmentAspect.MIN_OPERATING_TEMP, 150);
                equipment.setAspect(EquipmentAspect.MAX_OPERATING_TEMP, 1000);
                break;
            }
            case SUPERSCOOPER: {
                equipment.setAspect(EquipmentAspect.NAME, "<Super Scooper> Mining Drone");
                equipment.setAspect(EquipmentAspect.WEIGHT, 10);
                equipment.setAspect(EquipmentAspect.CARGO_CAPACITY, 0);
                equipment.setAspect(EquipmentAspect.PASSENGER_CAPACITY, 0);
                equipment.setAspect(EquipmentAspect.HYPERJUMP_RANGE, 0);
                equipment.setAspect(EquipmentAspect.BASE_PRICE, 12000);
                equipment.setAspect(EquipmentAspect.TYPE, (Object)EquipmentType.DRONE);
                equipment.setAspect(EquipmentAspect.MIN_OPERATING_TEMP, 80);
                equipment.setAspect(EquipmentAspect.MAX_OPERATING_TEMP, 400);
                break;
            }
            case DRILLDOWN_DYNAMOS: {
                equipment.setAspect(EquipmentAspect.NAME, "<Drilldown Dynamos> Mining Drone");
                equipment.setAspect(EquipmentAspect.WEIGHT, 10);
                equipment.setAspect(EquipmentAspect.CARGO_CAPACITY, 0);
                equipment.setAspect(EquipmentAspect.PASSENGER_CAPACITY, 0);
                equipment.setAspect(EquipmentAspect.HYPERJUMP_RANGE, 0);
                equipment.setAspect(EquipmentAspect.BASE_PRICE, 15000);
                equipment.setAspect(EquipmentAspect.TYPE, (Object)EquipmentType.DRONE);
                equipment.setAspect(EquipmentAspect.MIN_OPERATING_TEMP, 120);
                equipment.setAspect(EquipmentAspect.MAX_OPERATING_TEMP, 1200);
                break;
            }
            case INO_SLUURP: {
                equipment.setAspect(EquipmentAspect.NAME, "<Ino SLUURP> Fluid Distillation Drone");
                equipment.setAspect(EquipmentAspect.WEIGHT, 2);
                equipment.setAspect(EquipmentAspect.CARGO_CAPACITY, 0);
                equipment.setAspect(EquipmentAspect.PASSENGER_CAPACITY, 0);
                equipment.setAspect(EquipmentAspect.HYPERJUMP_RANGE, 0);
                equipment.setAspect(EquipmentAspect.BASE_PRICE, 1500);
                equipment.setAspect(EquipmentAspect.TYPE, (Object)EquipmentType.DRONE);
                equipment.setAspect(EquipmentAspect.MIN_OPERATING_TEMP, 180);
                equipment.setAspect(EquipmentAspect.MAX_OPERATING_TEMP, 300);
                break;
            }
            default: {
                equipment.setAspect(EquipmentAspect.NAME, "Unset");
                equipment.setAspect(EquipmentAspect.WEIGHT, 1);
                equipment.setAspect(EquipmentAspect.CARGO_CAPACITY, 0);
                equipment.setAspect(EquipmentAspect.PASSENGER_CAPACITY, 0);
                equipment.setAspect(EquipmentAspect.HYPERJUMP_RANGE, 0);
                equipment.setAspect(EquipmentAspect.BASE_PRICE, 0);
            }
        }
        equipment.setAspect(EquipmentAspect.KEY, what.name());
        return equipment;
    }

    public static enum Component {
        SINGLE_PASSENGER_CABIN,
        DOUBLE_PASSENGER_CABIN,
        LUXURY_PASSENGER_CABIN,
        STANDARD_DRIVE,
        FANFOSTAR,
        TROMPETECHOS,
        SUPERSCOOPER,
        DRILLDOWN_DYNAMOS,
        INO_SLUURP;

    }
}

