/*
 * Decompiled with CFR 0.152.
 */
package solarex.system;

import solarex.system.Solar;

public class PlanetMiningData {
    private Surface[] earth = new Surface[]{Surface.FLUID_ICE, Surface.FLUID_ICE, Surface.FLUID_ICE, Surface.FLUID_ICE, Surface.FLUID_ICE, Surface.FLUID_ICE, Surface.FLUID_ROCKS, Surface.FLUID_ROCKS, Surface.FLUID, Surface.FLUID_ROCKS, Surface.FLUID_ROCKS, Surface.FLUID, Surface.ROCKS, Surface.FLUID_ROCKS, Surface.FLUID_ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.FLUID_ROCKS, Surface.FLUID, Surface.FLUID, Surface.FLUID, Surface.FLUID_ROCKS, Surface.FLUID, Surface.FLUID, Surface.FLUID, Surface.FLUID, Surface.FLUID_ROCKS, Surface.FLUID_ROCKS, Surface.FLUID, Surface.FLUID, Surface.FLUID_ICE, Surface.FLUID_ICE_ROCKS, Surface.FLUID_ICE_ROCKS, Surface.FLUID_ICE, Surface.FLUID_ICE, Surface.FLUID_ICE};
    private Surface[] cloud = new Surface[]{Surface.ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.FLUID_ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.FLUID_ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.FLUID_ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.FLUID_ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.FLUID, Surface.FLUID_ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.FLUID_ROCKS, Surface.FLUID_ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.FLUID_ROCKS, Surface.ROCKS, Surface.ROCKS, Surface.ROCKS};

    public Surface getSurfaceData(Solar planet, int gx, int gy) {
        Surface result = Surface.NONE;
        if (gx >= 0 && gx < 6 && gy >= 0 & gy < 6) {
            switch (planet.ptype) {
                case ATM_ROCK: {
                    if (gy < 1 || gy > 4) {
                        result = Surface.ICE_ROCKS;
                        break;
                    }
                    result = Surface.ROCKS;
                    break;
                }
                case BARE_ROCK: {
                    result = Surface.ROCKS;
                    break;
                }
                case GRAPHITE_ROCK: {
                    result = Surface.ROCKS;
                    break;
                }
                case CLOUD: {
                    result = this.cloud[gy * 6 + gx];
                    break;
                }
                case EARTH: {
                    result = this.earth[gy * 6 + gx];
                    break;
                }
                case ICE: {
                    result = Surface.ICE;
                    break;
                }
                case SMALL_GAS: {
                    if (gy < 1 || gy > 4) {
                        result = Surface.FLUID_ICE;
                        break;
                    }
                    result = Surface.FLUID;
                    break;
                }
                default: {
                    result = Surface.NONE;
                }
            }
        }
        return result;
    }

    public static enum Surface {
        FLUID,
        FLUID_ROCKS,
        FLUID_ICE,
        FLUID_ICE_ROCKS,
        ICE,
        ICE_ROCKS,
        ROCKS,
        NONE;

    }
}

