/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui.panels;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import solarex.galaxy.Galaxy;
import solarex.galaxy.SystemLocation;
import solarex.ship.Ship;
import solarex.system.Solar;
import solarex.system.Vec3;
import solarex.ui.ImageCache;
import solarex.ui.components.HyperjumpPainter;
import solarex.ui.components.StardrivePainter;
import solarex.ui.interfaces.ShowPlanetCallback;
import solarex.ui.interfaces.ShowSystemCallback;
import solarex.util.ClockCallback;
import solarex.util.ComponentFactory;
import solarex.util.FontFactory;

public class NavigationPanel
extends JPanel
implements ClockCallback {
    private final JButton jumpButton;
    private final JButton driveButton;
    private final HyperjumpPainter hyperjumpPainter;
    private final StardrivePainter stardrivePainter;
    private double scale;
    private int zoom;
    private double viewX;
    private double viewY;
    private double dragStartX;
    private double dragStartY;
    private double dragCenterX;
    private double dragCenterY;
    private String destString = "Not set";
    private String speedString = "0.0";
    private Solar destBody;
    private Solar system;
    private ImageCache imageCache;
    private ShowSystemCallback showSystemCallback;
    private double currentSpeed = 0.0;
    private ShowPlanetCallback showPlanetCallback;
    private Ship ship;
    private final Galaxy galaxy;

    public NavigationPanel(Galaxy galaxy, final Ship ship, ImageCache imageCache, ShowPlanetCallback showPlanetCallback, ShowSystemCallback showSystemCallback) {
        this.galaxy = galaxy;
        this.showPlanetCallback = showPlanetCallback;
        this.imageCache = imageCache;
        this.ship = ship;
        this.showSystemCallback = showSystemCallback;
        this.hyperjumpPainter = new HyperjumpPainter(imageCache);
        this.stardrivePainter = new StardrivePainter();
        this.zoom = 10;
        this.rescale();
        this.setLayout(null);
        this.jumpButton = new JButton("Engage Jumpdrive");
        this.jumpButton.setSize(140, 24);
        this.jumpButton.setLocation(840, 600);
        ComponentFactory.customizeButton(this.jumpButton);
        this.add(this.jumpButton);
        this.driveButton = new JButton("Engage Stardrive");
        this.driveButton.setSize(140, 24);
        this.driveButton.setLocation(840, 628);
        ComponentFactory.customizeButton(this.driveButton);
        this.add(this.driveButton);
        this.updateControls();
        this.jumpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ship.hyperjumpDestination != null) {
                    ship.loca = ship.hyperjumpDestination;
                    ship.hyperjumpDestination = null;
                    ship.setState(Ship.State.FLIGHT);
                    ship.spaceBodySeed = 0L;
                    ship.destination.x = ship.position.x;
                    ship.destination.y = ship.position.y;
                    NavigationPanel.this.currentSpeed = 0.0;
                    NavigationPanel.this.updateControls();
                    NavigationPanel.this.hyperjumpPainter.start();
                }
            }
        });
        this.driveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NavigationPanel.this.stardrivePainter.start();
                    }
                });
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ship.loca.equals(((NavigationPanel)NavigationPanel.this).system.loca)) {
                    NavigationPanel.this.setDestination(e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                NavigationPanel.this.dragStartX = e.getX();
                NavigationPanel.this.dragStartY = e.getY();
                NavigationPanel.this.dragCenterX = NavigationPanel.this.viewX;
                NavigationPanel.this.dragCenterY = NavigationPanel.this.viewY;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                double dx = NavigationPanel.this.dragStartX - (double)x;
                double dy = NavigationPanel.this.dragStartY - (double)y;
                NavigationPanel.this.viewX = NavigationPanel.this.dragCenterX - dx / NavigationPanel.this.scale;
                NavigationPanel.this.viewY = NavigationPanel.this.dragCenterY - dy / NavigationPanel.this.scale;
                NavigationPanel.this.repaint(50L);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int u = e.getWheelRotation();
                NavigationPanel.this.zoom += u * (1 + NavigationPanel.this.zoom / 9);
                if (NavigationPanel.this.zoom < 1) {
                    NavigationPanel.this.zoom = 1;
                }
                if (NavigationPanel.this.zoom > 4000) {
                    NavigationPanel.this.zoom = 4000;
                }
                NavigationPanel.this.rescale();
                NavigationPanel.this.repaint();
            }
        });
    }

    public final void updateControls() {
        SystemLocation there = this.ship.hyperjumpDestination;
        boolean ok = false;
        if (there != null) {
            SystemLocation here = this.ship.loca;
            double sectorDistance = there.distance(here);
            ok = (double)this.ship.equipment.getHyperjumpRange() >= sectorDistance;
        }
        this.jumpButton.setEnabled(ok);
    }

    private void rescale() {
        this.scale = (double)(this.zoom * this.zoom) * 1.0E-8;
    }

    private void paintOrbit(Graphics gr, int xpos, int ypos, int rad) {
        for (double u = 0.0; u <= Math.PI * 2; u += 0.02454369260617026) {
            gr.fillRect(xpos + (int)(Math.cos(u) * (double)rad), ypos + (int)(Math.sin(u) * (double)rad), 1, 1);
        }
    }

    private void paintSystem(Graphics gr, double xoff, double yoff, Solar sys) {
        int centerX = this.getWidth() / 2;
        int centerY = this.getHeight() / 2;
        int w = 2 + (int)((double)sys.radius * this.scale);
        Image img = null;
        if (sys.btype == Solar.BodyType.PLANET) {
            img = this.imageCache.planets[sys.ptype.ordinal()].getImage();
        } else if (sys.btype == Solar.BodyType.STATION) {
            img = this.imageCache.station.getImage();
        } else if (sys.btype == Solar.BodyType.SPACEPORT) {
            img = this.imageCache.spaceport.getImage();
        } else if (sys.btype == Solar.BodyType.SUN) {
            img = this.imageCache.suns[sys.stype.ordinal()].getImage();
        }
        if (img != null) {
            gr.drawImage(img, centerX - w / 2 + (int)(xoff * this.scale), centerY - w / 2 + (int)(yoff * this.scale), w, w, null);
        }
        if (sys.btype == Solar.BodyType.SPACEPORT) {
            gr.setColor(Color.ORANGE);
            gr.drawString(sys.name, centerX + (int)(xoff * this.scale) + 4, centerY + (int)(yoff * this.scale) + 8);
        } else {
            if (sys.btype == Solar.BodyType.STATION) {
                gr.setColor(Color.ORANGE);
            } else {
                gr.setColor(Color.WHITE);
            }
            gr.drawString(sys.name, centerX + (int)(xoff * this.scale), centerY + (int)(yoff * this.scale) - 4);
        }
        for (int i = 0; i < sys.children.size(); ++i) {
            Solar body = sys.children.get(i);
            if (body.btype != Solar.BodyType.SUN && !(body.orbit * this.scale > 10.0) && body.btype != Solar.BodyType.SPACEPORT) continue;
            if (body.btype != Solar.BodyType.SPACEPORT) {
                gr.setColor(Color.GRAY);
                this.paintOrbit(gr, centerX + (int)(xoff * this.scale), centerY + (int)(yoff * this.scale), (int)(body.orbit * this.scale));
            }
            this.paintSystem(gr, xoff + body.pos.x, yoff + body.pos.y, body);
        }
    }

    private void paintShip(Graphics gr) {
        int centerX = this.getWidth() / 2;
        int centerY = this.getHeight() / 2;
        if (this.ship.destination.x != this.ship.position.x || this.ship.destination.y != this.ship.position.y) {
            gr.setColor(Color.PINK);
            gr.drawRect(centerX + (int)((this.viewX + this.ship.destination.x) * this.scale) - 3, centerY + (int)((this.viewY + this.ship.destination.y) * this.scale) - 3, 6, 6);
            gr.setColor(Color.GREEN);
            gr.drawString("Current destination", centerX + (int)((this.viewX + this.ship.destination.x) * this.scale) + 8, centerY + (int)((this.viewY + this.ship.destination.y) * this.scale));
        }
        gr.setColor(Color.CYAN);
        gr.drawRect(centerX + (int)((this.viewX + this.ship.position.x) * this.scale) - 3, centerY + (int)((this.viewY + this.ship.position.y) * this.scale) - 3, 6, 6);
        gr.setColor(Color.GREEN);
        gr.drawString("Your ship", centerX + (int)((this.viewX + this.ship.position.x) * this.scale) + 8, centerY + (int)((this.viewY + this.ship.position.y) * this.scale));
    }

    @Override
    public void paint(Graphics gr) {
        if (this.hyperjumpPainter.isActive()) {
            this.hyperjumpPainter.paint(gr, this.getWidth(), this.getHeight());
        } else if (this.stardrivePainter.isActive()) {
            this.stardrivePainter.paint(gr, this.getWidth(), this.getHeight());
        } else {
            super.paint(gr);
        }
    }

    @Override
    public void paintComponent(Graphics gr) {
        int width = this.getWidth();
        int height = this.getHeight();
        gr.drawImage(this.imageCache.metalBand.getImage(), 0, 0, width, height, null);
        gr.setColor(Color.GRAY);
        gr.drawRect(10, 11, 410, 48);
        gr.setColor(Color.BLACK);
        gr.fillRect(11, 12, 408, 46);
        gr.setColor(Color.WHITE);
        gr.setFont(FontFactory.getPanelHeading());
        gr.drawString("Navigation Map", 130, 43);
        int left = width / 2;
        gr.setColor(Color.GRAY);
        gr.drawRect(left + 10, 11, 410, 48);
        gr.setColor(Color.BLACK);
        gr.fillRect(left + 11, 12, 408, 46);
        gr.setColor(Color.GRAY);
        gr.drawRect(10, height - 61, 410, 42);
        gr.setColor(Color.BLACK);
        gr.fillRect(11, height - 60, 408, 40);
        gr.setClip(100, 75, width - 200, height - 150);
        gr.drawImage(this.imageCache.backdrops[1].getImage(), 100, 75, null);
        gr.setClip(0, 0, width, height);
        gr.setFont(FontFactory.getNormal());
        gr.setColor(Color.CYAN);
        gr.drawString("Drag map by mouse. Zoom with mouse wheel.", 18, height - 36);
        gr.setColor(Color.GREEN);
        gr.setFont(FontFactory.getLabelHeading());
        gr.drawString("Destination:", left + 18, 30);
        gr.setColor(Color.WHITE);
        gr.setFont(FontFactory.getLarger());
        gr.drawString(this.destString, left + 100, 30);
        gr.setColor(Color.GREEN);
        gr.setFont(FontFactory.getLabelHeading());
        gr.drawString("Speed:", left + 18, 50);
        gr.setColor(Color.WHITE);
        gr.setFont(FontFactory.getLarger());
        gr.drawString(this.speedString, left + 100, 50);
        gr.setFont(FontFactory.getNormal());
        gr.setColor(Color.GRAY);
        gr.drawRect(99, 74, width - 200 + 2, height - 150 + 2);
        Shape clip = gr.getClip();
        gr.setClip(100, 75, width - 200, height - 150);
        this.paintSystem(gr, this.viewX, this.viewY, this.system);
        if (this.ship.loca.equals(this.system.loca)) {
            this.paintShip(gr);
        }
        gr.setClip(clip);
    }

    private void setDestination(int x, int y) {
        Solar body;
        int w = this.getWidth();
        int h = this.getHeight();
        this.ship.destination.x = -this.viewX + (double)(x - w / 2) / this.scale;
        this.ship.destination.y = -this.viewY + (double)(y - h / 2) / this.scale;
        this.ship.depart();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        this.destString = "X=" + nf.format(this.ship.destination.x) + " Y=" + nf.format(this.ship.destination.y);
        double range = 27.0 / this.scale;
        this.destBody = body = this.system.findInRange(this.ship.destination, range);
        if (this.destBody != null) {
            this.destString = this.destBody.name;
            Vec3 pos = this.destBody.getAbsolutePosition();
            this.viewX = -pos.x;
            this.viewY = -pos.y;
            this.ship.destination.x = pos.x;
            this.ship.destination.y = pos.y;
        }
        this.repaint();
    }

    public void setSystem(Solar system) {
        this.system = system;
        this.viewX = 0.0;
        this.viewY = 0.0;
        this.zoom = 10;
        this.rescale();
        this.repaint();
    }

    @Override
    public void ping100(int deltaT) {
        if (this.hyperjumpPainter.isActive()) {
            this.moveJump(deltaT);
        } else if (this.stardrivePainter.isActive()) {
            this.driveShip(deltaT);
        } else {
            this.moveShip(deltaT);
        }
    }

    private void moveJump(int deltaT) {
        this.hyperjumpPainter.moveJump(deltaT);
        this.repaint(50L);
        if (this.hyperjumpPainter.isDone()) {
            this.hyperjumpPainter.stop();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Solar system = NavigationPanel.this.showSystemCallback.makeSystem(((NavigationPanel)NavigationPanel.this).ship.loca);
                }
            });
        }
    }

    private void driveShip(int deltaT) {
        this.stardrivePainter.moveJump(deltaT);
        this.repaint(50L);
        if (this.stardrivePainter.isDone()) {
            this.stardrivePainter.stop();
            this.ship.position.x = this.ship.destination.x;
            this.ship.position.y = this.ship.destination.y;
            this.currentSpeed = 0.0;
            this.speedString = "" + this.currentSpeed + " (arrived)";
            this.arrived();
            this.repaint(10L);
        }
    }

    private void moveShip(int deltaT) {
        double dx = this.ship.destination.x - this.ship.position.x;
        double dy = this.ship.destination.y - this.ship.position.y;
        double dist = Math.sqrt(dx * dx + dy * dy);
        double accel = 1500.0;
        if (dist > 0.0) {
            dx /= dist;
            dy /= dist;
            double breakingDistance = this.currentSpeed * this.currentSpeed / 3000.0;
            if (breakingDistance * 1.4 < dist) {
                this.currentSpeed += 1500.0;
                this.speedString = "" + this.currentSpeed / 100.0 + " (accelerating)";
            } else if (breakingDistance * 1.2 > dist) {
                this.currentSpeed -= 1500.0;
                this.speedString = "" + this.currentSpeed / 100.0 + " (decelerating)";
            } else {
                this.speedString = "" + this.currentSpeed / 100.0 + " (floating)";
            }
            if (this.currentSpeed < 1000.0) {
                this.currentSpeed = 1000.0;
                this.speedString = "" + this.currentSpeed / 100.0 + " (approaching)";
            }
            this.ship.position.x += dx * this.currentSpeed;
            this.ship.position.y += dy * this.currentSpeed;
            double dxLeft = this.ship.destination.x - this.ship.position.x;
            double dyLeft = this.ship.destination.y - this.ship.position.y;
            if (Math.abs(dxLeft) < this.currentSpeed && Math.abs(dyLeft) < this.currentSpeed) {
                this.ship.position.x = this.ship.destination.x;
                this.ship.position.y = this.ship.destination.y;
                this.currentSpeed = 0.0;
                this.speedString = "" + this.currentSpeed + " (arrived)";
                this.arrived();
            }
            this.repaint(10L);
        }
    }

    private void arrived() {
        if (this.destBody != null && this.destBody.btype != Solar.BodyType.SUN) {
            Solar chosenBody = this.destBody;
            if (chosenBody.btype == Solar.BodyType.PLANET || chosenBody.btype == Solar.BodyType.STATION || chosenBody.btype == Solar.BodyType.SPACEPORT) {
                this.ship.arrive(this.galaxy, chosenBody);
            } else {
                this.ship.spaceBodySeed = 0L;
                this.ship.loca.name = "";
                this.ship.setState(Ship.State.FLIGHT);
            }
            this.showPlanetCallback.showSpaceBody(chosenBody);
        }
    }
}

