/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import solarex.ship.Ship;
import solarex.ship.components.EquipmentType;
import solarex.ship.components.ShipComponent;
import solarex.system.PlanetResources;
import solarex.system.Solar;
import solarex.ui.ImageCache;
import solarex.ui.components.BodyInfoLabel;
import solarex.ui.components.EquipmentWrapper;
import solarex.ui.components.PlanetDetailLabel;
import solarex.ui.panels.MiningPanel;
import solarex.util.ComponentFactory;
import solarex.util.FontFactory;

public class PlanetViewPanel
extends JPanel {
    private Ship ship;
    private Random rng;
    private ImageCache imageCache;
    private BodyInfoLabel bodyInfoLabel;
    private PlanetDetailLabel planetDetailLabel;
    private Font font = FontFactory.getNormal();
    private Solar planet;
    public static final String[] richness = new String[]{"Trace deposits of <font color=\"%2\">%1</font> detected.", "Minor <font color=\"%2\">%1</font> deposits detected.", "Small deposits of <font color=\"%2\">%1</font> detected.", "Rich <font color=\"%2\">%1</font> deposits detected.", "Abundant <font color=\"%2\">%1</font> deposits detected."};
    private MiningPanel miningPanel;
    private JLabel activeDronesLabel;
    private JList activeDronesList;
    private JScrollPane activeDronesScroll;
    private JLabel availableDronesLabel;
    private JButton deployButton;
    private JList dockedDronesList;
    private JScrollPane dronesScroll;
    private JPanel fluidsPanel;
    private JPanel gasesPanel;
    private JButton haulDroneButton;
    private JPanel innerPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTabbedPane jTabbedPane1;
    private JPanel metalsPanel;
    private JPanel mineralsPanel;
    private JPanel miscPanel;
    private JLabel planetIconLabel;
    private JLabel planetNameLabel;
    private JPanel planetPanel;
    private JLabel resourcesLabel;
    private JPanel resourcesPanel;

    public PlanetViewPanel(Ship ship, ImageCache imageCache) {
        this.initComponents();
        this.ship = ship;
        this.imageCache = imageCache;
        this.planetNameLabel.setText("My Planet");
        this.planetNameLabel.setFont(FontFactory.getPanelHeading());
        this.planetIconLabel.setIcon(imageCache.planets[Solar.PlanetType.EARTH.ordinal()]);
        this.planetIconLabel.setText("      ");
        JPanel helper = new JPanel();
        helper.setLayout(new FlowLayout(0, 0, 0));
        helper.setBackground(Color.DARK_GRAY);
        helper.setBorder(new LineBorder(Color.GRAY));
        this.bodyInfoLabel = new BodyInfoLabel();
        this.planetDetailLabel = new PlanetDetailLabel();
        helper.add(new JLabel(" "));
        helper.add(this.bodyInfoLabel);
        helper.add(new JLabel("     "));
        helper.add(this.planetDetailLabel);
        this.planetPanel.add((Component)helper, "South");
        this.createTabs();
        this.dockedDronesList.setFont(FontFactory.getNormal());
        this.activeDronesList.setFont(FontFactory.getNormal());
        this.fillDronesLists(ship);
        ComponentFactory.customizeButton(this.deployButton);
        ComponentFactory.customizeButton(this.haulDroneButton);
    }

    private void createTabs() {
        JList list = this.createResourcesList(new String[]{"A", "B", "C"});
        JScrollPane scrolly = new JScrollPane(list);
        scrolly.setBorder(null);
        this.gasesPanel.add(scrolly);
        list = this.createResourcesList(new String[]{"Unprobed."});
        scrolly = new JScrollPane(list);
        scrolly.setBorder(null);
        this.fluidsPanel.add(scrolly);
        list = this.createResourcesList(new String[]{"Unprobed."});
        scrolly = new JScrollPane(list);
        scrolly.setBorder(null);
        this.mineralsPanel.add(scrolly);
        list = this.createResourcesList(new String[]{"Unprobed."});
        scrolly = new JScrollPane(list);
        scrolly.setBorder(null);
        this.metalsPanel.add(scrolly);
        list = this.createResourcesList(new String[]{"Unprobed."});
        scrolly = new JScrollPane(list);
        scrolly.setBorder(null);
        this.miscPanel.add(scrolly);
    }

    private void calculateMetals(Solar planet) {
        String[] items;
        int[] deposits = new int[PlanetResources.Metals.values().length];
        long[] positions = new long[PlanetResources.Metals.values().length];
        PlanetResources.calculateMetals(planet, this.rng, deposits, positions);
        ArrayList<String> alist = new ArrayList<String>();
        PlanetResources.Metals[] values = PlanetResources.Metals.values();
        for (int i = 0; i < deposits.length; ++i) {
            if (deposits[i] == 0) continue;
            String s = richness[Math.min(deposits[i], richness.length - 1)];
            s = s.replaceFirst("%1", values[i].toString().toLowerCase());
            s = s.replaceFirst("%2", values[i].color);
            char hint = (char)(122 - deposits[i]);
            alist.add("" + hint + s);
        }
        Collections.sort(alist);
        if (alist.isEmpty()) {
            items = new String[]{"No recoverable metal deposits found."};
        } else {
            items = new String[alist.size()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = ((String)alist.get(i)).substring(1);
            }
        }
        JList list = this.createResourcesList(items);
        JScrollPane scrolly = (JScrollPane)this.metalsPanel.getComponent(0);
        scrolly.setViewportView(list);
    }

    private void calculateMinerals(Solar planet) {
        String[] items;
        int[] deposits = PlanetResources.calculateMinerals(planet, this.rng);
        ArrayList<String> alist = new ArrayList<String>();
        PlanetResources.Minerals[] values = PlanetResources.Minerals.values();
        for (int i = 0; i < deposits.length; ++i) {
            if (deposits[i] == 0) continue;
            String s = richness[Math.min(deposits[i], richness.length - 1)];
            s = s.replaceFirst("%1", values[i].toString().toLowerCase());
            s = s.replaceFirst("%2", values[i].color);
            char hint = (char)(122 - deposits[i]);
            alist.add("" + hint + s);
        }
        Collections.sort(alist);
        if (alist.isEmpty()) {
            items = new String[]{"No recoverable mineral deposits found."};
        } else {
            items = new String[alist.size()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = ((String)alist.get(i)).substring(1);
            }
        }
        JList list = this.createResourcesList(items);
        JScrollPane scrolly = (JScrollPane)this.mineralsPanel.getComponent(0);
        scrolly.setViewportView(list);
    }

    private void calculateOtherResources(Solar planet) {
        String[] items;
        int[] otherResources = PlanetResources.calculateOtherResources(planet, this.rng);
        ArrayList<String> alist = new ArrayList<String>();
        PlanetResources.OtherResource[] values = PlanetResources.OtherResource.values();
        for (int i = 0; i < otherResources.length; ++i) {
            if (otherResources[i] == 0) continue;
            String s = richness[Math.min(otherResources[i], richness.length - 1)];
            s = s.replaceFirst("%1", values[i].toString().toLowerCase());
            s = s.replaceFirst("%2", values[i].color);
            alist.add("" + (9 - otherResources[i]) + s);
        }
        Collections.sort(alist);
        if (alist.isEmpty()) {
            items = new String[]{"No other resources found"};
        } else {
            items = new String[alist.size()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = ((String)alist.get(i)).substring(1);
            }
        }
        JList list = this.createResourcesList(items);
        JScrollPane scrolly = (JScrollPane)this.miscPanel.getComponent(0);
        scrolly.setViewportView(list);
    }

    private int[] calculateAtmosphere(Solar planet) {
        String[] items;
        int[] weights = PlanetResources.calculateAtmosphere(planet, this.rng);
        int sum = 0;
        for (int i = 0; i < weights.length; ++i) {
            sum += weights[i];
        }
        PlanetResources.Gases[] values = PlanetResources.Gases.values();
        ArrayList<String> alist = new ArrayList<String>();
        if (sum > 0) {
            for (int i = 0; i < values.length; ++i) {
                int percent = weights[i] * 100 / sum;
                char sortOrder = (char)(200 - percent);
                if (percent > 0) {
                    alist.add("" + sortOrder + "<font color=\"" + values[i].color + "\">" + values[i].toString() + "</font> " + percent + "%");
                    continue;
                }
                alist.add("" + sortOrder + "<font color=\"" + values[i].color + "\">" + values[i].toString() + "</font> &lt;1%");
            }
        }
        Collections.sort(alist);
        if (sum == 0) {
            items = new String[]{"No significant atmosphere detected."};
        } else {
            items = new String[alist.size()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = ((String)alist.get(i)).substring(1);
            }
        }
        JList list = this.createResourcesList(items);
        JScrollPane scrolly = (JScrollPane)this.gasesPanel.getComponent(0);
        scrolly.setViewportView(list);
        return weights;
    }

    private void calculateFluids(Solar planet, int[] gases) {
        String[] items;
        int[] deposits = new int[PlanetResources.Fluids.values().length];
        long[] positions = new long[PlanetResources.Fluids.values().length];
        PlanetResources.calculateFluids(planet, gases, this.rng, deposits, positions);
        ArrayList<String> alist = new ArrayList<String>();
        PlanetResources.Fluids[] values = PlanetResources.Fluids.values();
        for (int i = 0; i < deposits.length; ++i) {
            if (deposits[i] == 0) continue;
            String s = richness[Math.min(deposits[i], richness.length - 1)];
            s = s.replaceFirst("%1", values[i].toString().toLowerCase());
            s = s.replaceFirst("%2", values[i].color);
            char hint = (char)(122 - deposits[i]);
            alist.add("" + hint + s);
        }
        Collections.sort(alist);
        if (alist.isEmpty()) {
            items = new String[]{"No recoverable fluids found."};
        } else {
            items = new String[alist.size()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = ((String)alist.get(i)).substring(1);
            }
        }
        JList list = this.createResourcesList(items);
        JScrollPane scrolly = (JScrollPane)this.fluidsPanel.getComponent(0);
        scrolly.setViewportView(list);
    }

    public void switchToPlanetView() {
        if (this.miningPanel != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(12, 0, 16, 0);
            this.remove(this.miningPanel);
            this.add((Component)this.innerPanel, gridBagConstraints);
            this.validate();
            this.miningPanel = null;
        }
        this.repaint(50L);
    }

    public void update(Solar planet) {
        this.planet = planet;
        this.switchToPlanetView();
        this.fillDronesLists(this.ship);
        this.rng = PlanetResources.getPlanetRng(planet);
        this.bodyInfoLabel.update(planet, this.ship.player.isExplored(planet));
        this.planetDetailLabel.update(planet);
        int[] gases = this.calculateAtmosphere(planet);
        this.calculateFluids(planet, gases);
        this.calculateMetals(planet);
        this.calculateMinerals(planet);
        this.calculateOtherResources(planet);
        this.planetNameLabel.setText(planet.name);
        this.planetIconLabel.setIcon(this.imageCache.planets[planet.ptype.ordinal()]);
    }

    private JList createResourcesList(String[] items) {
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (int i = 0; i < items.length; ++i) {
            model.add(i, "<html>&nbsp;" + items[i] + "</html>");
        }
        JList list = new JList(model);
        list.setBackground(Color.DARK_GRAY);
        list.setForeground(Color.LIGHT_GRAY);
        list.setFont(this.font);
        return list;
    }

    private void fillDronesLists(Ship ship) {
        DefaultListModel<EquipmentWrapper> docked = new DefaultListModel<EquipmentWrapper>();
        for (ShipComponent comp : ship.equipment.components) {
            if (comp.getType() != EquipmentType.DRONE) continue;
            docked.addElement(new EquipmentWrapper(comp));
        }
        this.dockedDronesList.setModel(docked);
        DefaultListModel active = new DefaultListModel();
        this.activeDronesList.setModel(active);
    }

    private void initComponents() {
        this.innerPanel = new JPanel();
        this.planetPanel = new JPanel();
        this.planetNameLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.planetIconLabel = new JLabel();
        this.resourcesPanel = new JPanel();
        this.resourcesLabel = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.gasesPanel = new JPanel();
        this.fluidsPanel = new JPanel();
        this.mineralsPanel = new JPanel();
        this.metalsPanel = new JPanel();
        this.miscPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.availableDronesLabel = new JLabel();
        this.dronesScroll = new JScrollPane();
        this.dockedDronesList = new JList();
        this.deployButton = new JButton();
        this.activeDronesLabel = new JLabel();
        this.activeDronesScroll = new JScrollPane();
        this.activeDronesList = new JList();
        this.haulDroneButton = new JButton();
        this.setBackground(Color.black);
        this.setForeground(Color.green);
        this.setLayout(new GridBagLayout());
        this.innerPanel.setBackground(new Color(15, 20, 37));
        this.innerPanel.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.innerPanel.setForeground(Color.green);
        this.innerPanel.setLayout(new GridBagLayout());
        this.planetPanel.setBackground(Color.black);
        this.planetPanel.setForeground(Color.green);
        this.planetPanel.setOpaque(false);
        this.planetPanel.setLayout(new BorderLayout(0, 8));
        this.planetNameLabel.setBackground(Color.black);
        this.planetNameLabel.setForeground(Color.white);
        this.planetNameLabel.setText("Planet");
        this.planetPanel.add((Component)this.planetNameLabel, "North");
        this.jPanel2.setOpaque(false);
        this.planetIconLabel.setToolTipText("");
        this.jPanel2.add(this.planetIconLabel);
        this.planetPanel.add((Component)this.jPanel2, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 30, 16, 22);
        this.innerPanel.add((Component)this.planetPanel, gridBagConstraints);
        this.resourcesPanel.setBackground(Color.black);
        this.resourcesPanel.setForeground(Color.green);
        this.resourcesPanel.setOpaque(false);
        this.resourcesPanel.setPreferredSize(new Dimension(300, 250));
        this.resourcesPanel.setLayout(new BorderLayout(0, 12));
        this.resourcesLabel.setBackground(Color.black);
        this.resourcesLabel.setForeground(Color.green);
        this.resourcesLabel.setText("Discovered Resources");
        this.resourcesPanel.add((Component)this.resourcesLabel, "North");
        this.jTabbedPane1.setBackground(Color.darkGray);
        this.jTabbedPane1.setForeground(Color.green);
        this.gasesPanel.setLayout(new BorderLayout());
        this.jTabbedPane1.addTab("Gases", this.gasesPanel);
        this.fluidsPanel.setBackground(Color.black);
        this.fluidsPanel.setForeground(Color.green);
        this.fluidsPanel.setLayout(new BorderLayout());
        this.jTabbedPane1.addTab("Fluids", this.fluidsPanel);
        this.mineralsPanel.setBackground(Color.black);
        this.mineralsPanel.setForeground(Color.green);
        this.mineralsPanel.setLayout(new BorderLayout());
        this.jTabbedPane1.addTab("Minerals", this.mineralsPanel);
        this.metalsPanel.setBackground(Color.black);
        this.metalsPanel.setForeground(Color.green);
        this.metalsPanel.setLayout(new BorderLayout());
        this.jTabbedPane1.addTab("Metals", this.metalsPanel);
        this.miscPanel.setBackground(Color.black);
        this.miscPanel.setForeground(Color.green);
        this.miscPanel.setLayout(new BorderLayout());
        this.jTabbedPane1.addTab("Misc.", this.miscPanel);
        this.resourcesPanel.add((Component)this.jTabbedPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 22, 16, 32);
        this.innerPanel.add((Component)this.resourcesPanel, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setPreferredSize(new Dimension(800, 270));
        this.jPanel1.setLayout(null);
        this.availableDronesLabel.setBackground(Color.black);
        this.availableDronesLabel.setForeground(Color.green);
        this.availableDronesLabel.setText("Docked Drones");
        this.jPanel1.add(this.availableDronesLabel);
        this.availableDronesLabel.setBounds(30, 0, 210, 20);
        this.dronesScroll.setBorder(BorderFactory.createLineBorder(new Color(128, 128, 128)));
        this.dockedDronesList.setBackground(Color.darkGray);
        this.dockedDronesList.setForeground(Color.lightGray);
        this.dockedDronesList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.dockedDronesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PlanetViewPanel.this.dockedDronesListValueChanged(evt);
            }
        });
        this.dronesScroll.setViewportView(this.dockedDronesList);
        this.jPanel1.add(this.dronesScroll);
        this.dronesScroll.setBounds(30, 30, 400, 160);
        this.deployButton.setText("Deploy Drone");
        this.deployButton.setEnabled(false);
        this.deployButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanetViewPanel.this.deployButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.deployButton);
        this.deployButton.setBounds(140, 210, 180, 25);
        this.activeDronesLabel.setForeground(Color.green);
        this.activeDronesLabel.setText("Active Drones");
        this.jPanel1.add(this.activeDronesLabel);
        this.activeDronesLabel.setBounds(470, 0, 250, 20);
        this.activeDronesScroll.setBorder(BorderFactory.createLineBorder(new Color(128, 128, 128)));
        this.activeDronesList.setBackground(Color.darkGray);
        this.activeDronesList.setForeground(Color.lightGray);
        this.activeDronesList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.activeDronesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PlanetViewPanel.this.activeDronesListValueChanged(evt);
            }
        });
        this.activeDronesScroll.setViewportView(this.activeDronesList);
        this.jPanel1.add(this.activeDronesScroll);
        this.activeDronesScroll.setBounds(470, 30, 430, 160);
        this.haulDroneButton.setText("Haul Drone Inboard");
        this.haulDroneButton.setEnabled(false);
        this.haulDroneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanetViewPanel.this.haulDroneButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.haulDroneButton);
        this.haulDroneButton.setBounds(600, 210, 170, 25);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        this.innerPanel.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(32, 24, 24, 24);
        this.add((Component)this.innerPanel, gridBagConstraints);
    }

    private void deployButtonActionPerformed(ActionEvent evt) {
        Solar station = null;
        if (this.planet.children.size() > 0 && this.planet.children.get((int)0).btype == Solar.BodyType.STATION) {
            station = this.planet.children.get(0);
        }
        if (this.planet.society != null && this.planet.society.population != 0) {
            JOptionPane.showMessageDialog(this, "This planet is populated. The inhabitants do not allow you\nto mine or harvest resources here.");
        } else if (station != null) {
            JOptionPane.showMessageDialog(this, "This planet is owned by the " + station.society.race.toString().toLowerCase() + ".\n" + "The owners do not allow you to mine\n" + "or harvest resources here.");
        } else {
            Object o = this.dockedDronesList.getSelectedValue();
            if (o != null && o instanceof EquipmentWrapper) {
                ShipComponent drone = ((EquipmentWrapper)o).getComponent();
                DefaultListModel m = (DefaultListModel)this.activeDronesList.getModel();
                m.addElement(o);
                m = (DefaultListModel)this.dockedDronesList.getModel();
                m.removeElement(o);
                this.miningPanel = new MiningPanel(this.planet, this.ship, this.imageCache, drone, this);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(12, 0, 16, 0);
                this.remove(this.innerPanel);
                this.add((Component)this.miningPanel, gridBagConstraints);
                this.validate();
            }
        }
    }

    private void dockedDronesListValueChanged(ListSelectionEvent evt) {
        if (this.ship.getState() == Ship.State.ORBIT && this.ship.spaceBodySeed == this.planet.seed) {
            this.deployButton.setEnabled(this.dockedDronesList.getSelectedValue() != null);
        }
    }

    private void activeDronesListValueChanged(ListSelectionEvent evt) {
        this.haulDroneButton.setEnabled(this.activeDronesList.getSelectedValue() != null);
    }

    private void haulDroneButtonActionPerformed(ActionEvent evt) {
        Object o = this.activeDronesList.getSelectedValue();
        if (o != null && o instanceof EquipmentWrapper) {
            DefaultListModel m = (DefaultListModel)this.dockedDronesList.getModel();
            m.addElement(o);
            m = (DefaultListModel)this.activeDronesList.getModel();
            m.removeElement(o);
        }
    }
}

