/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.border.LineBorder;
import solarex.ship.Ship;
import solarex.system.Solar;
import solarex.ui.ImageCache;
import solarex.ui.components.BodyInfoLabel;
import solarex.ui.components.ImagedPanel;
import solarex.ui.interfaces.ShowPlanetCallback;
import solarex.util.FontFactory;

public class TabularSystemPanel
extends JLayeredPane {
    private static Point right = new Point(1, 0);
    private static Point up = new Point(0, -1);
    private Font font = FontFactory.getSmaller();
    private Color clearColor = new Color(255, 255, 255, 0);
    private BodyInfoLabel infoLabel;
    private ImageCache imageCache;
    private ShowPlanetCallback showPlanetCallback;
    private Ship ship;
    private int maxX;
    private int maxY;

    public void setShowPlanetCallback(ShowPlanetCallback c) {
        this.showPlanetCallback = c;
    }

    private int scale(Solar body) {
        return (int)Math.max(Math.pow(body.radius, 0.5) / 3.2, 4.0);
    }

    private void layoutBody(final Solar body, int startX, int startY, int spacing) {
        ImageIcon icon;
        if (body.children.size() > 0) {
            Solar testee = body.children.get(0);
            if (testee.btype == Solar.BodyType.SPACEPORT) {
                this.layoutBody(testee, startX, startY, spacing);
            }
        }
        final JButton button = new JButton();
        button.setText("<html><center>" + body.name + "</center></html>");
        button.setForeground(Color.WHITE);
        button.setContentAreaFilled(false);
        button.setFont(this.font);
        if (this.ship.spaceBodySeed == body.seed) {
            button.setBorder(new LineBorder(Color.YELLOW, 1));
        } else {
            button.setBorder(new LineBorder(this.clearColor, 1));
        }
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setFocusPainted(false);
        int scale = this.scale(body);
        int w = Math.max(scale, spacing);
        int h = Math.max(scale + 24, spacing);
        int layer = JLayeredPane.DEFAULT_LAYER;
        if (body.btype == Solar.BodyType.SPACEPORT || body.btype == Solar.BodyType.STATION) {
            button.setForeground(Color.ORANGE);
        }
        if (body.btype == Solar.BodyType.SPACEPORT) {
            button.setVerticalTextPosition(0);
            button.setHorizontalTextPosition(10);
            button.setHorizontalAlignment(4);
            button.setLocation(startX - 68 + 2 + w / 2, startY + (h - 46) / 2);
            button.setSize(68, 28);
            ++layer;
        } else {
            button.setVerticalTextPosition(3);
            button.setHorizontalTextPosition(0);
            button.setLocation(startX, startY + h / 16);
            button.setSize(w, h - h / 8);
        }
        if (body.btype == Solar.BodyType.SUN) {
            if (body.stype == Solar.SunType.S_BLACK_HOLE) {
                icon = new ImageIcon(this.imageCache.suns[body.stype.ordinal()].getImage().getScaledInstance(254, 63, 4));
                button.setLocation(startX, startY + h / 4 - 4);
                button.setSize(w * 3, h * 3 / 4);
            } else {
                icon = new ImageIcon(this.imageCache.suns[body.stype.ordinal()].getImage().getScaledInstance(scale, scale, 4));
                button.setSize(w, h);
                button.setLocation(startX, startY);
            }
        } else {
            icon = body.btype == Solar.BodyType.PLANET ? (body.ptype == Solar.PlanetType.RINGS ? new ImageIcon(this.imageCache.planets[body.ptype.ordinal()].getImage().getScaledInstance(scale * 20 / 16, scale * 17 / 16, 4)) : new ImageIcon(this.imageCache.planets[body.ptype.ordinal()].getImage().getScaledInstance(scale, scale, 4))) : (body.btype == Solar.BodyType.SPACEPORT ? new ImageIcon(this.imageCache.spaceport.getImage().getScaledInstance(scale, scale, 4)) : new ImageIcon(this.imageCache.station.getImage().getScaledInstance(scale, scale, 4)));
        }
        button.setIcon(icon);
        this.add((Component)button, new Integer(layer));
        int mx = startX + button.getWidth();
        int my = startY + button.getHeight();
        if (mx > this.maxX) {
            this.maxX = mx;
        }
        if (my > this.maxY) {
            this.maxY = my;
        }
        button.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TabularSystemPanel.this.infoLabel.update(body, ((TabularSystemPanel)TabularSystemPanel.this).ship.player.isExplored(body));
                if (body.btype == Solar.BodyType.SUN) {
                    TabularSystemPanel.this.infoLabel.setLocation(Math.max(button.getX(), 16), Math.max(button.getY() - TabularSystemPanel.this.infoLabel.getHeight() + 32, 128));
                } else {
                    TabularSystemPanel.this.infoLabel.setLocation(Math.max(button.getX(), 16), Math.max(button.getY() + button.getHeight() + 3, 526));
                }
                if (((TabularSystemPanel)TabularSystemPanel.this).ship.loca.equals(body.loca) || ((TabularSystemPanel)TabularSystemPanel.this).ship.player.canInspect(body)) {
                    button.setBorder(new LineBorder(Color.GREEN, 1));
                } else {
                    button.setBorder(new LineBorder(Color.DARK_GRAY, 1));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TabularSystemPanel.this.infoLabel.setText("");
                if (((TabularSystemPanel)TabularSystemPanel.this).ship.spaceBodySeed == body.seed) {
                    button.setBorder(new LineBorder(Color.YELLOW, 1));
                } else {
                    button.setBorder(new LineBorder(TabularSystemPanel.this.clearColor, 1));
                }
            }
        });
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((body.btype == Solar.BodyType.PLANET || body.btype == Solar.BodyType.SPACEPORT || body.btype == Solar.BodyType.STATION) && (((TabularSystemPanel)TabularSystemPanel.this).ship.loca.equals(body.loca) || ((TabularSystemPanel)TabularSystemPanel.this).ship.player.canInspect(body))) {
                    TabularSystemPanel.this.infoLabel.setText("");
                    button.setBorder(new LineBorder(TabularSystemPanel.this.clearColor, 1));
                    TabularSystemPanel.this.showPlanetCallback.showSpaceBody(body);
                }
            }
        });
    }

    private void layoutChildren(Solar system, Point dir, int startX, int startY, int spacing) {
        Point p = new Point(startX, startY);
        ArrayList<Solar> bodies = system.children;
        for (int i = 0; i < bodies.size(); ++i) {
            Solar body = bodies.get(i);
            if (body.btype == Solar.BodyType.SPACEPORT) continue;
            this.layoutBody(body, p.x, p.y, spacing);
            if (dir == up) {
                this.layoutChildren(body, right, p.x + spacing, p.y, spacing);
            } else {
                this.layoutChildren(body, up, p.x + spacing / 4, p.y - spacing / 2, spacing / 2);
            }
            p.x += dir.x * spacing;
            p.y += dir.y * spacing;
            if (dir != right || this.maxX <= p.x) continue;
            p.x = this.maxX;
        }
    }

    public void layoutSystem(Solar system) {
        this.removeAll();
        this.maxX = 0;
        this.maxY = 0;
        int h = 620;
        int spacing = 128;
        int bottom = 220;
        int scale = this.scale(system);
        Point cur = scale < spacing ? new Point(0, h - bottom) : (scale < spacing * 3 ? new Point(spacing - scale / 2, h - bottom - (scale + 24 - spacing) / 2) : new Point(spacing - scale * 3 / 4, h - bottom - (scale + 24 - spacing) / 2));
        this.infoLabel = new BodyInfoLabel();
        this.infoLabel.setLocation(this.maxX / 2 - 100, 444);
        this.infoLabel.setSize(500, 128);
        this.infoLabel.setFont(FontFactory.getNormal());
        this.add(this.infoLabel);
        this.layoutBody(system, cur.x, cur.y, spacing);
        if (system.stype == Solar.SunType.S_BLACK_HOLE) {
            cur.x += 256;
        }
        this.layoutChildren(system, right, cur.x + Math.max(scale, spacing), h - bottom, spacing);
        int width = this.getWidth();
        int height = this.getHeight();
        int prefW = Math.max(this.maxX + 20, width);
        int prefH = Math.max(this.maxY + 11, height);
        this.setSize(prefW, prefH);
        this.setPreferredSize(this.getSize());
        int layer = DEFAULT_LAYER - 1;
        ImagedPanel background = new ImagedPanel();
        background.setOpaque(false);
        background.setBounds(0, 0, prefW, prefH);
        background.setBackgroundImage(this.imageCache.backdrops[0].getImage());
        this.add((Component)background, new Integer(layer));
        JLabel systemNameLabel = new JLabel(system.baseName + " System Information");
        systemNameLabel.setFont(FontFactory.getPanelHeading());
        systemNameLabel.setSize(400, 32);
        systemNameLabel.setLocation(32, 24);
        systemNameLabel.setForeground(Color.WHITE);
        this.add(systemNameLabel);
        this.validate();
    }

    public TabularSystemPanel(Ship ship, ImageCache imageCache) {
        this.ship = ship;
        this.setBackground(Color.BLACK);
        this.setOpaque(true);
        this.setLayout(null);
        this.imageCache = imageCache;
    }
}

