/*
 * Decompiled with CFR 0.152.
 */
package solarex.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import solarex.ui.ImageCache;

public class ComponentFactory {
    private static Color buttonLitColor = new Color(50, 35, 0);
    private static Color buttonMetalColor = new Color(160, 162, 168);

    public static void customizeButton(JButton button) {
        button.setUI(new BlueButtonUI());
    }

    public static void customizeScrollpane(JScrollPane scrolly) {
        scrolly.getVerticalScrollBar().setUI(new ScrollBarUI());
        scrolly.getHorizontalScrollBar().setUI(new ScrollBarUI());
        scrolly.setBackground(Color.BLACK);
        scrolly.setBorder(new LineBorder(Color.GRAY));
        scrolly.getVerticalScrollBar().setUnitIncrement(12);
        scrolly.getHorizontalScrollBar().setUnitIncrement(12);
    }

    public static void customizeButton(JButton button, String iconFile) {
        button.setUI(new IconButtonUI());
        ImageIcon icon = ImageCache.createImageIcon("/solarex/resources/ui/" + iconFile, "");
        button.setIcon(icon);
        button.setText("");
        button.setPreferredSize(new Dimension(icon.getIconWidth() + 2, icon.getIconHeight() + 2));
        button.setOpaque(false);
    }

    private static class ScrollBarUI
    extends BasicScrollBarUI {
        private ScrollBarUI() {
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            c.remove(this.incrButton);
            c.remove(this.decrButton);
            c.setOpaque(false);
        }

        @Override
        protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        }

        @Override
        protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
            if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
                return;
            }
            int w = thumbBounds.width;
            int h = thumbBounds.height;
            g.translate(thumbBounds.x, thumbBounds.y);
            g.setColor(Color.GRAY);
            g.fillRect(1, 1, w - 2, h - 2);
            g.translate(-thumbBounds.x, -thumbBounds.y);
        }

        @Override
        protected JButton createDecreaseButton(int orientation) {
            return new BasicArrowButton(orientation, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK);
        }

        @Override
        protected JButton createIncreaseButton(int orientation) {
            return new BasicArrowButton(orientation, Color.BLACK, Color.DARK_GRAY, Color.GRAY, Color.DARK_GRAY);
        }
    }

    private static class IconButtonUI
    extends BasicButtonUI {
        private Color mid = new Color(48, 96, 128);
        private Color light = new Color(255, 170, 100);
        private Color roll = new Color(96, 192, 255);

        private IconButtonUI() {
        }

        @Override
        public void installUI(JComponent component) {
            BasicBorders.RolloverButtonBorder rb = new BasicBorders.RolloverButtonBorder(this.roll, this.roll, Color.WHITE, this.roll);
            super.installUI(component);
            component.setForeground(this.light);
            component.setBackground(this.mid);
            component.setBorder(rb);
        }
    }

    private static class BlueButtonUI
    extends BasicButtonUI {
        private Color dark = new Color(8, 16, 32);
        private Color mid = new Color(48, 96, 128);
        private Color light = new Color(255, 170, 100);
        private Color roll = new Color(96, 192, 255);
        private Color lines = new Color(72, 136, 192, 96);

        private BlueButtonUI() {
        }

        @Override
        public void installUI(JComponent component) {
            BasicBorders.RolloverButtonBorder rb = new BasicBorders.RolloverButtonBorder(this.roll, this.roll, Color.WHITE, this.roll);
            LineBorder bb = new LineBorder(this.dark, 1);
            CompoundBorder c2 = new CompoundBorder(bb, rb);
            super.installUI(component);
            component.setForeground(this.light);
            component.setBackground(this.mid);
            component.setBorder(new CompoundBorder(c2, new EmptyBorder(1, 12, 1, 12)));
        }

        @Override
        public void paint(Graphics gr, JComponent c) {
            super.paint(gr, c);
            gr.setColor(this.lines);
            int w = c.getWidth() - 10;
            for (int y = 4; y < c.getHeight() - 3; y += 3) {
                gr.fillRect(5, y, w, 1);
            }
        }
    }

    private static class TestButtonUI
    extends BasicButtonUI {
        private TestButtonUI() {
        }

        @Override
        public void installUI(JComponent component) {
            BasicBorders.RolloverButtonBorder rb = new BasicBorders.RolloverButtonBorder(Color.BLACK, Color.BLACK, Color.WHITE, Color.BLACK);
            BevelBorder bb = new BevelBorder(0, buttonMetalColor.brighter(), buttonMetalColor, buttonMetalColor.darker(), buttonMetalColor);
            LineBorder lb = new LineBorder(Color.BLACK, 1);
            CompoundBorder c1 = new CompoundBorder(lb, bb);
            CompoundBorder c2 = new CompoundBorder(c1, rb);
            super.installUI(component);
            component.setForeground(buttonLitColor);
            component.setBackground(buttonMetalColor);
            component.setBorder(new CompoundBorder(c2, new EmptyBorder(1, 12, 1, 12)));
        }
    }
}

