/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;
import org.fuin.utils4j.PropertiesFilePreferences;

public final class PropertiesFilePreferencesFactory
implements PreferencesFactory {
    public static final String SYSTEM_PREF_DIR = "PropertiesFilePreferences.SystemDir";
    public static final String USER_PREF_DIR = "PropertiesFilePreferences.UserDir";
    private final String systemPrefDir;
    private final String userPrefDir;
    private PropertiesFilePreferences systemRoot = null;
    private PropertiesFilePreferences userRoot = null;

    public PropertiesFilePreferencesFactory() {
        this(System.getProperty(SYSTEM_PREF_DIR), System.getProperty(USER_PREF_DIR));
    }

    public PropertiesFilePreferencesFactory(String systemPrefDir, String userPrefDir) {
        this.systemPrefDir = systemPrefDir;
        this.userPrefDir = userPrefDir;
    }

    public final synchronized Preferences systemRoot() {
        if (this.systemRoot == null) {
            this.systemRoot = new PropertiesFilePreferences(this.getValidDir(SYSTEM_PREF_DIR, this.systemPrefDir));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        PropertiesFilePreferencesFactory.this.systemRoot.flush();
                    }
                    catch (BackingStoreException ex) {
                        System.err.println("Failed to save 'systemRoot' preferences!");
                        ex.printStackTrace(System.err);
                    }
                }
            });
        }
        return this.systemRoot;
    }

    public final synchronized Preferences userRoot() {
        if (this.userRoot == null) {
            this.userRoot = new PropertiesFilePreferences(this.getValidDir(USER_PREF_DIR, this.userPrefDir));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        PropertiesFilePreferencesFactory.this.userRoot.flush();
                    }
                    catch (BackingStoreException ex) {
                        System.err.println("Failed to save 'userRoot' preferences!");
                        ex.printStackTrace(System.err);
                    }
                }
            });
        }
        return this.userRoot;
    }

    private File getValidDir(String varName, String dirName) {
        if (dirName == null) {
            throw new RuntimeException("The system variable '" + varName + "' is not set!");
        }
        File dir = new File(dirName);
        if (!dir.exists()) {
            throw new IllegalArgumentException("The directory '" + dir + "' does not exist! [system variable '" + varName + "']");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("The name '" + dir + "' is not a directory! [system variable '" + varName + "']");
        }
        return dir;
    }
}

