/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.Panels;

import gamemaker.Coordinate;
import gamemaker.Exceptions.GameXmlIncorrectException;
import gamemaker.Exceptions.PanelNotPassedException;
import gamemaker.GameMap;
import gamemaker.GameMaps;
import gamemaker.Panels.DialoguePanel;
import gamemaker.Panels.GamePanel;
import gamemaker.Panels.XMLable;
import gamemaker.TeleportLocation;
import gamemaker.XMLSimplify;
import gamemaker.events.GameEvent;
import gamemaker.events.VariableChangeEvent;
import gamemaker.events.soutEvent;
import gamemaker.events.teleportEvent;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class EventPanel
extends GamePanel
implements XMLable {
    private ArrayList<GameEvent> events;
    public final int AREA = 1;
    public final int SQUARE = 2;
    public final int CIRCLE = 3;
    public final int SOUT_EVENT = 1;
    public final int EVENT_TELEPORT = 2;
    public final int EVENT_VARIABLE = 3;
    private int currentShape = 1;
    private int currentEventType = 1;
    private DialoguePanel dialoguePanel;
    private GameMap gameMap;
    private GameMaps gameMaps;

    public void deleteEvents(int mapIndex) {
        for (int i = 0; i < this.events.size(); ++i) {
            TeleportLocation tl;
            if (!this.events.get(i).getEventFuntion().equals("teleport") || (tl = ((teleportEvent)this.events.get(i)).getTeleportLocation()).getMapIndex() != mapIndex) continue;
            this.events.remove(i);
        }
    }

    public EventPanel(GameMap gameMap, GameMaps maps) {
        this.setOpaque(false);
        this.events = new ArrayList(20);
        this.gameMap = gameMap;
        this.gameMaps = maps;
    }

    public GameEvent getCurrentEvent() {
        return this.events.get(this.events.size() - 1);
    }

    public void removeCurrentEvent() {
        if (this.events.size() > 0) {
            this.events.remove(this.events.size() - 1);
        } else {
            System.err.println("There is no event to delete");
        }
    }

    public void setDialoguePanel(DialoguePanel dialoguePanel) {
        this.dialoguePanel = dialoguePanel;
    }

    public DialoguePanel getDialoguePanel() throws PanelNotPassedException {
        if (this.dialoguePanel == null) {
            throw new PanelNotPassedException("DialoguePanel");
        }
        return this.dialoguePanel;
    }

    public boolean isAreaInProgress() {
        if (this.events.size() <= 0) {
            return false;
        }
        int n = this.events.get(this.events.size() - 1).getDrawMode();
        this.events.get(this.events.size() - 1).getClass();
        if (n == 1) {
            return this.events.get(this.events.size() - 1).isComplete();
        }
        return false;
    }

    public void triggerAnyEventAtPoint(Coordinate c) {
        for (int i = 0; i < this.events.size(); ++i) {
            if (!this.events.get(i).isPointWithin(c)) continue;
            this.events.get(i).eventAction();
        }
    }

    public void triggerActionEventAtPoint(Point p) {
        this.triggerActionEventAtPoint(new Coordinate(Math.round(p.getX()), Math.round(p.getY())));
    }

    public void triggerActionEventAtPoint(Coordinate c) {
        boolean stopLoop = false;
        for (int i = 0; i < this.events.size() && !stopLoop; ++i) {
            if (!this.events.get(i).isPointWithin(c)) continue;
            int n = this.events.get(i).getTriggerMode();
            this.events.get(i).getClass();
            if (n != 1) continue;
            stopLoop = this.events.get(i).eventAction();
        }
    }

    public void triggerWalkoverEventAtPoint(Coordinate c) {
        for (int i = 0; i < this.events.size(); ++i) {
            if (!this.events.get(i).isPointWithin(c) || this.events.get(i).getTriggerMode() != this.events.get((int)i).TRIGGER_WALKOVER) continue;
            this.events.get(i).eventAction();
        }
    }

    public void setEventType(int eventType) {
        this.currentEventType = eventType;
    }

    public int getEventType() {
        return this.currentEventType;
    }

    public void setCurrentShapeDiameter(Coordinate c) {
        if (this.events.size() >= 1) {
            this.events.get(this.events.size() - 1).setShapeDiameter(c);
        }
    }

    public void removeEvent(Coordinate c) {
        boolean found = false;
        for (int i = this.events.size() - 1; i >= 0 && !found; --i) {
            if (!this.events.get(i).isPointWithin(c)) continue;
            this.events.remove(i);
            found = true;
        }
    }

    public void addEvent(Coordinate position) {
        GameEvent latestEvent = this.createNewEvent();
        this.events.add(latestEvent);
        if (this.currentShape == 1) {
            latestEvent.addPoint(position);
        } else if (this.currentShape == 2) {
            latestEvent.getClass();
            latestEvent.setDrawShape(position, 2);
        } else if (this.currentShape == 3) {
            latestEvent.setDrawShape(position, latestEvent.TYPE_CIRCLE);
        } else {
            System.out.println("ERROR SHAPE NOT DEFINED");
        }
    }

    public void addPoint(Coordinate c) {
        if (this.currentShape == 1) {
            if (this.events.size() >= 1) {
                GameEvent latestEvent = this.events.get(this.events.size() - 1);
                if (latestEvent.isComplete()) {
                    this.addEvent(c);
                } else {
                    latestEvent.addPoint(c);
                }
            } else {
                this.addEvent(c);
            }
        } else {
            this.addEvent(c);
        }
    }

    public boolean isAreaComplete() {
        if (this.events.size() >= 1) {
            return this.events.get(this.events.size() - 1).isComplete();
        }
        return true;
    }

    public void setCurrentAreaComplete() {
        if (this.events.size() >= 1 && !this.events.get(this.events.size() - 1).isComplete()) {
            this.events.get(this.events.size() - 1).setComplete();
            this.repaint();
            this.events.get(this.events.size() - 1).configureEvent(this.gameMaps.getEventsConditional());
        }
    }

    public void setShapeComplete() {
        if (this.currentShape != 1) {
            this.events.get(this.events.size() - 1).configureEvent(this.gameMaps.getEventsConditional());
        }
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        for (int i = 0; i < this.events.size(); ++i) {
            if (this.events.get(i) == null) continue;
            this.events.get(i).drawEvent(g2);
        }
    }

    private GameEvent createNewEvent() {
        GameEvent event;
        if (this.currentEventType == 1) {
            event = new soutEvent(this, this.gameMap);
            event.setTriggerMode(this.currentEventType);
        } else if (this.currentEventType == 2) {
            event = new teleportEvent(this, this.gameMaps);
            event.getClass();
            event.setTriggerMode(1);
        } else if (this.currentEventType == 3) {
            event = new VariableChangeEvent(this.gameMaps.getCurrentMap());
            event.getClass();
            event.setTriggerMode(1);
        } else {
            event = new soutEvent(this, this.gameMap);
        }
        this.getClass();
        if (this.currentShape == 1) {
            event.getClass();
            event.setDrawMode(1);
        } else {
            this.getClass();
            if (this.currentShape == 3) {
                event.setDrawMode(event.TYPE_CIRCLE);
            } else {
                this.getClass();
                if (this.currentShape == 2) {
                    event.getClass();
                    event.setDrawMode(2);
                }
            }
        }
        return event;
    }

    public void setDrawMode(int shapeCode) {
        GameEvent latestEvent;
        this.currentShape = shapeCode;
        if (this.events.size() > 0 && (latestEvent = this.events.get(this.events.size() - 1)).isShapeInProgress()) {
            latestEvent.setComplete();
        }
    }

    public int getEventShapeMode() {
        return this.currentShape;
    }

    public void fromXML(Element rootElement) throws GameXmlIncorrectException {
        List xmlEvents = rootElement.getChildren("event");
        for (int i = 0; i < xmlEvents.size(); ++i) {
            GameEvent e;
            String type = ((Element)xmlEvents.get(i)).getAttributeValue("type");
            String trigger = ((Element)xmlEvents.get(i)).getAttributeValue("trigger");
            if (type.equals("teleport")) {
                e = new teleportEvent(this, this.gameMaps);
                int mapIndex = XMLSimplify.getXMLInt((Element)xmlEvents.get(i), "mapid");
                int xaxis = XMLSimplify.getXMLInt((Element)xmlEvents.get(i), "xaxis");
                int yaxis = XMLSimplify.getXMLInt((Element)xmlEvents.get(i), "yaxis");
                ((teleportEvent)e).setTeleportLocation(mapIndex, new Coordinate(xaxis, yaxis));
            } else if (type.equals("message")) {
                e = new soutEvent(this, this.gameMap);
                ((soutEvent)e).setMessageText(((Element)xmlEvents.get(i)).getText().trim());
            } else if (type.equals("variablechange")) {
                e = new VariableChangeEvent(this.gameMap);
                ((VariableChangeEvent)e).fromXML((Element)xmlEvents.get(i));
            } else {
                throw new GameXmlIncorrectException("Event attempted to be added that does not exist.");
            }
            e.setEventTrigger(trigger);
            e.fromXML((Element)xmlEvents.get(i));
            this.events.add(e);
        }
    }

    public String toXML() {
        return this.toXML("<events>", "</events>");
    }

    public String toXML(String openTag, String closeTag) {
        String xml = "";
        xml = xml + openTag + "\n";
        for (int i = 0; i < this.events.size(); ++i) {
            if (this.events.get(i) == null) continue;
            xml = xml + this.events.get(i).toXML();
        }
        xml = xml + closeTag + "\n";
        return xml;
    }

    public GameMaps getGameMaps() {
        return this.gameMaps;
    }
}

