/*
 * Decompiled with CFR 0.152.
 */
package gamemaker.Panels;

import gamemaker.Coordinate;
import gamemaker.FileHandler;
import gamemaker.GameMap;
import gamemaker.ImageWithDetails;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ForegroundItem
extends JLabel {
    private ImageWithDetails itemImage;
    private Image displayedImage;
    private GameMap gameMap;
    private ImageIcon thisIcon;
    private Coordinate startPlace;
    private Coordinate lastMove;
    private Rectangle2D[] resizers = new Rectangle2D[4];
    private int resizerWidth = 6;
    private int lastResizerClicked = 0;
    private Rectangle2D initialBounds;

    public ForegroundItem(GameMap gameMap) {
        this.gameMap = gameMap;
        this.thisIcon = new ImageIcon();
    }

    public void paintComponentTwo(Graphics g) {
        int x = this.startPlace.getX() - Math.round(this.displayedImage.getWidth(this) / 2);
        int y = this.startPlace.getY() - Math.round(this.displayedImage.getHeight(this) / 2);
        g.drawImage(this.displayedImage, x, y, this);
    }

    public Coordinate getImageLocation() {
        return this.startPlace;
    }

    public String getImageFileName() {
        return this.itemImage.getFileName();
    }

    public int getImageHashCode() {
        return this.itemImage.getImage().hashCode();
    }

    public void saveImage(String location) throws IOException {
        FileHandler.imageToFile(this.displayedImage, location + this.itemImage.getImage().hashCode() + ".png");
    }

    public void setImage(Coordinate c, ImageWithDetails theImage) throws IOException {
        this.itemImage = theImage;
        int imageWidth = this.itemImage.getImage().getWidth(this.gameMap);
        int imageHeight = this.itemImage.getImage().getHeight(this.gameMap);
        int x1 = c.getX() - imageWidth / 2;
        int y1 = c.getY() - imageHeight / 2;
        this.setBounds(x1, y1, imageWidth, imageHeight);
        this.displayedImage = this.itemImage.getImage();
        this.thisIcon.setImage(this.displayedImage);
        this.setIcon(this.thisIcon);
        this.setResizers();
        this.startPlace = new Coordinate(c.getX(), c.getY());
    }

    public void startMoveItem(Coordinate from, Coordinate to) {
        int width = from.getX() - to.getX();
        int height = from.getY() - to.getY();
        int x1 = from.getX() - (int)(this.getBounds().getWidth() / 2.0) - width;
        int y1 = from.getY() - (int)(this.getBounds().getHeight() / 2.0) - height;
        this.setBounds(x1, y1, (int)this.getBounds().getWidth(), (int)this.getBounds().getHeight());
        this.setResizers();
    }

    public void resizeItem(int ResizerIndex, Coordinate from, Coordinate to) {
        if (this.initialBounds == null) {
            this.initialBounds = this.getBounds();
        }
        if (ResizerIndex > -1 && ResizerIndex <= 3) {
            int widthChange = to.getX() - from.getX();
            int heightChange = to.getY() - from.getY();
            int totalWidth = (int)this.initialBounds.getWidth() + widthChange;
            int totalHeight = (int)this.initialBounds.getHeight() + heightChange;
            int minX = (int)this.initialBounds.getMinX();
            int minY = (int)this.initialBounds.getMinY();
            int width = widthChange;
            int height = heightChange;
            if (ResizerIndex == 0 || ResizerIndex == 1) {
                minY = (double)((int)this.initialBounds.getMinY() + heightChange) < this.initialBounds.getMaxY() ? to.getY() : (int)this.initialBounds.getMaxY();
                height = (int)this.initialBounds.getHeight() - heightChange;
            } else {
                if (totalHeight < 0) {
                    minY = (int)this.initialBounds.getMinY() - Math.abs(totalHeight);
                }
                height = totalHeight;
            }
            if (ResizerIndex == 0 || ResizerIndex == 2) {
                minX = (double)((int)this.initialBounds.getMinX() + widthChange) < this.initialBounds.getMaxX() ? to.getX() : (int)this.initialBounds.getMaxX();
                width = (int)this.initialBounds.getWidth() - widthChange;
            } else {
                if (totalWidth < 0) {
                    minX = (int)this.initialBounds.getMinX() - Math.abs(totalWidth);
                }
                width = totalWidth;
            }
            this.setBounds(minX, minY, Math.abs(width), Math.abs(height));
            int newWidth = Math.abs(width);
            int newHeight = Math.abs(height);
            if (newWidth != 0 && newHeight != 0) {
                this.displayedImage = this.itemImage.getImage().getScaledInstance(newWidth, newHeight, 1);
                this.thisIcon.setImage(this.displayedImage);
            }
            this.setResizers();
        }
    }

    public void finishResize() {
        this.initialBounds = null;
    }

    private void setResizers() {
        this.setResizer(0, (int)this.getBounds().getMinX(), (int)this.getBounds().getMinY());
        this.setResizer(1, (int)this.getBounds().getMaxX(), (int)this.getBounds().getMinY());
        this.setResizer(2, (int)this.getBounds().getMinX(), (int)this.getBounds().getMaxY());
        this.setResizer(3, (int)this.getBounds().getMaxX(), (int)this.getBounds().getMaxY());
    }

    private void setResizer(int index, int x, int y) {
        int x1 = x - this.resizerWidth / 2;
        int y1 = y - this.resizerWidth / 2;
        this.resizers[index] = new Rectangle2D.Double(x1, y1, this.resizerWidth, this.resizerWidth);
    }

    public int checkResizers(Coordinate c) {
        int found = -1;
        for (int i = 0; i <= 3 && found == -1; ++i) {
            if (!this.resizers[i].contains(new Point(c.getX(), c.getY()))) continue;
            found = i;
            this.lastResizerClicked = i;
        }
        return found;
    }

    public void drawResizers(Graphics2D g2) {
        g2.setColor(Color.white);
        g2.fill(this.resizers[0]);
        g2.fill(this.resizers[1]);
        g2.fill(this.resizers[2]);
        g2.fill(this.resizers[3]);
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        g2.setColor(Color.black);
        g2.draw(this.resizers[0]);
        g2.draw(this.resizers[1]);
        g2.draw(this.resizers[2]);
        g2.draw(this.resizers[3]);
    }

    public boolean isPointWithin(Coordinate c) {
        boolean itIs = false;
        if (this.getBounds().contains(new Point(c.getX(), c.getY())) || this.checkResizers(c) > -1) {
            itIs = true;
        }
        return itIs;
    }
}

