/*
 * Decompiled with CFR 0.152.
 */
package gamemaker;

import gamemaker.GameMaps;
import gamemaker.NumberFunctions;
import gamemaker.ScreenFunctions;
import gamemaker.events.VariableOperation;
import gamemaker.events.VariableOperations;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class VariableChangeInput
implements ActionListener {
    private JDialog theDialog;
    private GameMaps maps;
    private ArrayList<ButtonGroup> groups;
    private ArrayList<JTextField> textfields;
    private JTextArea messageBox;
    private JCheckBox useMessage;
    private final int OPTION_NA = 0;
    private final int OPTION_ADD = 1;
    private final int OPTION_SUBTRACT = 2;
    private final int OPTION_SET = 3;
    VariableOperations variableOperations = new VariableOperations();

    public VariableChangeInput() {
        this.theDialog = new JDialog();
        this.theDialog.setTitle("Please specify how you want to edit the variables");
        this.theDialog.setDefaultCloseOperation(2);
        this.theDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.theDialog.setSize(500, 310);
        this.theDialog.setLocation(ScreenFunctions.getScreenCentre(this.theDialog));
        JPanel container = new JPanel();
        JPanel messageOptions = new JPanel();
        messageOptions.setLayout(new GridLayout(0, 2));
        messageOptions.setSize(500, 200);
        container.setLayout(new BorderLayout());
        this.useMessage = new JCheckBox("Display Message When Triggered?");
        this.useMessage.setSelected(true);
        this.messageBox = new JTextArea("Variable Changed!");
        JScrollPane messageScroller = new JScrollPane(this.messageBox);
        messageScroller.setPreferredSize(new Dimension(300, 50));
        this.messageBox.setLineWrap(true);
        this.messageBox.setSize(300, 200);
        messageOptions.add(messageScroller);
        messageOptions.add(this.useMessage);
        JPanel boxes = new JPanel();
        boxes.setLayout(new GridLayout(0, 6));
        this.groups = new ArrayList();
        this.textfields = new ArrayList();
        int numvars = 10;
        for (int i = 0; i < numvars; ++i) {
            this.groups.add(new ButtonGroup());
            JRadioButton b0 = new JRadioButton("N/A");
            JRadioButton b1 = new JRadioButton("add");
            JRadioButton b2 = new JRadioButton("sub");
            JRadioButton b3 = new JRadioButton("set");
            this.groups.get(i).add(b0);
            this.groups.get(i).add(b1);
            this.groups.get(i).add(b2);
            this.groups.get(i).add(b3);
            this.groups.get(i).setSelected(b0.getModel(), true);
            this.textfields.add(new JTextField("0"));
            int num = i + 1;
            boxes.add(new JLabel("Variable " + num + ":"));
            boxes.add(this.textfields.get(i));
            boxes.add(b0);
            boxes.add(b1);
            boxes.add(b2);
            boxes.add(b3);
        }
        JButton okButton = new JButton("OK");
        okButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        boxes.add(new JLabel(""));
        boxes.add(new JLabel(""));
        boxes.add(new JLabel(""));
        boxes.add(new JLabel(""));
        boxes.add(okButton);
        boxes.add(cancelButton);
        container.add((Component)messageOptions, "North");
        container.add((Component)boxes, "Center");
        this.theDialog.add(container);
    }

    public VariableOperations getInput() {
        this.variableOperations = new VariableOperations();
        this.theDialog.setVisible(true);
        this.theDialog.repaint();
        return this.variableOperations;
    }

    private boolean updateVarOperations() {
        this.variableOperations = new VariableOperations();
        if (this.useMessage.isSelected()) {
            this.variableOperations.setMessageEnabled(true);
            this.variableOperations.setMessage(this.messageBox.getText());
        } else {
            this.variableOperations.setMessageEnabled(false);
            this.variableOperations.setMessage("");
        }
        for (int i = 0; i < this.groups.size(); ++i) {
            Enumeration<AbstractButton> enumeration = this.groups.get(i).getElements();
            int count = 0;
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement().isSelected()) {
                    int value = 0;
                    boolean passed = NumberFunctions.validateInteger(this.textfields.get(i).getText());
                    if (passed) {
                        value = Integer.parseInt(this.textfields.get(i).getText());
                    } else if (count == this.OPTION_ADD || count == this.OPTION_SUBTRACT || count == this.OPTION_SET) {
                        this.variableOperations.setArrayList(new ArrayList<VariableOperation>());
                        return false;
                    }
                    if (count == this.OPTION_ADD) {
                        this.variableOperations.getArrayList().add(new VariableOperation(i, value, 0));
                    } else if (count == this.OPTION_SUBTRACT) {
                        this.variableOperations.getArrayList().add(new VariableOperation(i, value, 1));
                    } else if (count == this.OPTION_SET) {
                        this.variableOperations.getArrayList().add(new VariableOperation(i, value, 2));
                    }
                }
                ++count;
            }
            boolean bl = false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            boolean success = this.updateVarOperations();
            if (success) {
                this.closeDialogue();
            } else {
                String error = "Values entered must be integers.";
                JOptionPane.showMessageDialog(this.theDialog, error);
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.variableOperations.setArrayList(new ArrayList<VariableOperation>());
            this.closeDialogue();
        } else {
            System.out.println("invalid action command");
        }
    }

    public void closeDialogue() {
        this.theDialog.setVisible(false);
        this.theDialog.dispose();
    }

    public static void main(String[] args) {
        VariableChangeInput vcm = new VariableChangeInput();
        System.out.println(vcm.getInput());
    }
}

