/*
 * Decompiled with CFR 0.152.
 */
package gamemaker;

import gamemaker.Exceptions.GameXmlIncorrectException;
import java.util.List;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class XMLSimplify {
    public static double getXMLDouble(Element e, String attribute) throws GameXmlIncorrectException {
        double theDouble;
        try {
            theDouble = e.getAttribute(attribute).getDoubleValue();
        }
        catch (DataConversionException dce) {
            throw new GameXmlIncorrectException("The attribute '" + attribute + "' must be set as an int. ");
        }
        return theDouble;
    }

    public static int getXMLInt(Element e, String attribute) throws GameXmlIncorrectException {
        int theInt;
        try {
            theInt = e.getAttribute(attribute).getIntValue();
        }
        catch (DataConversionException dce) {
            throw new GameXmlIncorrectException("The attribute '" + attribute + "' must be set as an int. ");
        }
        return theInt;
    }

    public static boolean getXMLBool(Element e, String attribute) throws GameXmlIncorrectException {
        boolean theBool = false;
        String s = e.getAttribute(attribute).getValue();
        if ((s = s.toUpperCase()).equals("TRUE") || s.equals("T") || s.equals("1")) {
            theBool = true;
        } else if (s.equals("FALSE") || s.equals("F") || s.equals("0")) {
            theBool = false;
        } else {
            throw new GameXmlIncorrectException("boolean incorrectly specified.");
        }
        return theBool;
    }

    public static Element getStrictlySingleElement(Element root, String child) throws GameXmlIncorrectException {
        List elements = root.getChildren(child);
        if (elements.size() > 1) {
            throw new GameXmlIncorrectException("Game XML must define only one '" + child + "' element.");
        }
        if (elements.size() < 1) {
            throw new GameXmlIncorrectException("Game XML must define at least one '" + child + "' element.");
        }
        return (Element)elements.get(0);
    }
}

