/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.bcb.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jvnet.flamingo.bcb.BreadcrumbBarCallBack;
import org.jvnet.flamingo.bcb.BreadcrumbBarException;
import org.jvnet.flamingo.bcb.BreadcrumbItem;
import org.jvnet.flamingo.bcb.JBreadcrumbBar;
import org.jvnet.flamingo.common.StringValuePair;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreadcrumbSvnSelector
extends JBreadcrumbBar<String> {
    public BreadcrumbSvnSelector() {
        super(null);
    }

    public BreadcrumbSvnSelector(String url, String userName, String password) {
        super(new PathCallback(url, userName, password));
    }

    public void setConnectionParams(String url, String userName, String password) {
        this.setConnectionParams(url, userName, password, false);
    }

    public void setConnectionParams(String url, String userName, String password, boolean throwsException) {
        this.callback = new PathCallback(url, userName, password);
        this.callback.setup();
        this.callback.setThrowsExceptions(throwsException);
        this.setPath(new LinkedList());
    }

    protected static InputStream getLeafContent(SVNRepository repository, String leaf) throws SVNException {
        HashMap fileProperties = new HashMap();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        repository.getFile(leaf, -1L, fileProperties, (OutputStream)baos);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    protected static List<StringValuePair<String>> getLeafs(SVNRepository repository, String path) throws SVNException {
        ArrayList<StringValuePair<String>> result = new ArrayList<StringValuePair<String>>();
        Collection entries = repository.getDir(path, -1L, null, (Collection)null);
        for (SVNDirEntry entry : entries) {
            if (entry.getKind() != SVNNodeKind.FILE) continue;
            String prefix = path == null || path.length() == 0 ? "" : path + "/";
            StringValuePair<String> leafInfo = new StringValuePair<String>(entry.getName(), prefix + entry.getName());
            leafInfo.set("size", entry.getSize());
            leafInfo.set("author", entry.getAuthor());
            leafInfo.set("date", entry.getDate());
            leafInfo.set("revision", entry.getRevision());
            result.add(leafInfo);
        }
        Collections.sort(result, new Comparator<StringValuePair<String>>(){

            @Override
            public int compare(StringValuePair<String> o1, StringValuePair<String> o2) {
                return ((String)o1.getKey()).compareTo((String)o2.getKey());
            }
        });
        return result;
    }

    protected static List<StringValuePair<String>> getPathChoices(SVNRepository repository, String path) throws SVNException {
        ArrayList<StringValuePair<String>> result = new ArrayList<StringValuePair<String>>();
        Collection entries = repository.getDir(path, -1L, null, (Collection)null);
        for (SVNDirEntry entry : entries) {
            if (entry.getKind() != SVNNodeKind.DIR) continue;
            String prefix = path == null || path.length() == 0 ? "" : path + "/";
            result.add(new StringValuePair<String>(entry.getName(), prefix + entry.getName()));
        }
        Collections.sort(result, new Comparator<StringValuePair<String>>(){

            @Override
            public int compare(StringValuePair<String> o1, StringValuePair<String> o2) {
                return ((String)o1.getKey()).compareTo((String)o2.getKey());
            }
        });
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PathCallback
    extends BreadcrumbBarCallBack<String> {
        private String url;
        private String userName;
        private String password;
        private SVNRepository repository;

        public PathCallback(String url, String userName, String password) {
            this.url = url;
            this.userName = userName;
            this.password = password;
        }

        @Override
        public void setup() throws BreadcrumbBarException {
            block2: {
                DAVRepositoryFactory.setup();
                SVNRepositoryFactoryImpl.setup();
                FSRepositoryFactory.setup();
                try {
                    this.repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)this.url));
                    ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)this.userName, (String)this.password);
                    this.repository.setAuthenticationManager(authManager);
                }
                catch (SVNException svne) {
                    if (!this.throwsExceptions) break block2;
                    throw new BreadcrumbBarException(svne);
                }
            }
        }

        @Override
        public List<StringValuePair<String>> getPathChoices(List<BreadcrumbItem<String>> path) throws BreadcrumbBarException {
            String lastPath = path == null ? "" : path.get(path.size() - 1).getData();
            try {
                return BreadcrumbSvnSelector.getPathChoices(this.repository, lastPath);
            }
            catch (SVNException svne) {
                if (this.throwsExceptions) {
                    throw new BreadcrumbBarException(svne);
                }
                return null;
            }
        }

        @Override
        public List<StringValuePair<String>> getLeafs(List<BreadcrumbItem<String>> path) throws BreadcrumbBarException {
            String lastPath = path == null ? "" : path.get(path.size() - 1).getData();
            try {
                return BreadcrumbSvnSelector.getLeafs(this.repository, lastPath);
            }
            catch (SVNException svne) {
                svne.printStackTrace();
                return null;
            }
        }

        @Override
        public InputStream getLeafContent(String leaf) throws BreadcrumbBarException {
            try {
                return BreadcrumbSvnSelector.getLeafContent(this.repository, leaf);
            }
            catch (SVNException svne) {
                return null;
            }
        }
    }
}

