/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.common;

import java.awt.Image;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichTooltip {
    protected String title;
    protected Image mainImage;
    protected List<String> descriptionSections;
    protected Image footerImage;
    protected List<String> footerSections;

    public RichTooltip() {
    }

    public RichTooltip(String title, String descriptionSection) {
        this.setTitle(title);
        this.addDescriptionSection(descriptionSection);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMainImage(Image image) {
        this.mainImage = image;
    }

    public void addDescriptionSection(String section) {
        if (this.descriptionSections == null) {
            this.descriptionSections = new LinkedList<String>();
        }
        this.descriptionSections.add(section);
    }

    public void setFooterImage(Image image) {
        this.footerImage = image;
    }

    public void addFooterSection(String section) {
        if (this.footerSections == null) {
            this.footerSections = new LinkedList<String>();
        }
        this.footerSections.add(section);
    }

    public String getTitle() {
        return this.title;
    }

    public Image getMainImage() {
        return this.mainImage;
    }

    public List<String> getDescriptionSections() {
        if (this.descriptionSections == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.descriptionSections);
    }

    public Image getFooterImage() {
        return this.footerImage;
    }

    public List<String> getFooterSections() {
        if (this.footerSections == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.footerSections);
    }
}

