/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon;

import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jvnet.flamingo.common.HorizontalAlignment;
import org.jvnet.flamingo.common.RichToolTipManager;
import org.jvnet.flamingo.common.RichTooltip;
import org.jvnet.flamingo.common.icon.ResizableIcon;
import org.jvnet.flamingo.ribbon.ui.BasicRibbonComponentUI;
import org.jvnet.flamingo.ribbon.ui.RibbonComponentUI;

public class JRibbonComponent
extends RichToolTipManager.JTrackableComponent {
    private ResizableIcon icon;
    private String caption;
    private JComponent mainComponent;
    private boolean isSimpleWrapper;
    private String keyTip;
    private RichTooltip richTooltip;
    private HorizontalAlignment horizontalAlignment;
    public static final String uiClassID = "RibbonComponentUI";

    public JRibbonComponent(JComponent mainComponent) {
        if (mainComponent == null) {
            throw new IllegalArgumentException("All parameters must be non-null");
        }
        this.mainComponent = mainComponent;
        this.isSimpleWrapper = true;
        this.horizontalAlignment = HorizontalAlignment.LEADING;
        this.updateUI();
    }

    public JRibbonComponent(ResizableIcon icon, String caption, JComponent mainComponent) {
        if (caption == null) {
            throw new IllegalArgumentException("Caption must be non-null");
        }
        if (mainComponent == null) {
            throw new IllegalArgumentException("Main component must be non-null");
        }
        this.icon = icon;
        this.caption = caption;
        this.mainComponent = mainComponent;
        this.isSimpleWrapper = false;
        this.horizontalAlignment = HorizontalAlignment.TRAILING;
        this.updateUI();
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI(UIManager.getUI(this));
        } else {
            this.setUI(BasicRibbonComponentUI.createUI(this));
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public RibbonComponentUI getUI() {
        return (RibbonComponentUI)this.ui;
    }

    public ResizableIcon getIcon() {
        return this.icon;
    }

    public String getCaption() {
        return this.caption;
    }

    public JComponent getMainComponent() {
        return this.mainComponent;
    }

    public boolean isSimpleWrapper() {
        return this.isSimpleWrapper;
    }

    public String getKeyTip() {
        return this.keyTip;
    }

    public void setKeyTip(String keyTip) {
        String old = this.keyTip;
        this.keyTip = keyTip;
        this.firePropertyChange("keyTip", old, this.keyTip);
    }

    public RichTooltip getRichTooltip(MouseEvent mouseEvent) {
        return this.richTooltip;
    }

    public void setRichTooltip(RichTooltip richTooltip) {
        this.richTooltip = richTooltip;
        RichToolTipManager richToolTipManager = RichToolTipManager.sharedInstance();
        if (richTooltip != null) {
            richToolTipManager.registerComponent(this);
        } else {
            richToolTipManager.unregisterComponent(this);
        }
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }
}

