/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon.resize;

import java.util.List;
import org.jvnet.flamingo.ribbon.AbstractRibbonBand;
import org.jvnet.flamingo.ribbon.RibbonTask;
import org.jvnet.flamingo.ribbon.resize.BaseRibbonBandResizeSequencingPolicy;
import org.jvnet.flamingo.ribbon.resize.RibbonBandResizePolicy;

public class CoreRibbonResizeSequencingPolicies {

    public static class CollapseFromLast
    extends BaseRibbonBandResizeSequencingPolicy {
        int nextIndex;

        public CollapseFromLast(RibbonTask ribbonTask) {
            super(ribbonTask);
        }

        public void reset() {
            this.nextIndex = this.ribbonTask.getBandCount() - 1;
        }

        public AbstractRibbonBand next() {
            AbstractRibbonBand<?> result = this.ribbonTask.getBand(this.nextIndex);
            List<RibbonBandResizePolicy> resizePolicies = result.getResizePolicies();
            if (result.getCurrentResizePolicy() == resizePolicies.get(resizePolicies.size() - 1)) {
                --this.nextIndex;
                if (this.nextIndex < 0) {
                    this.nextIndex = 0;
                }
            }
            return result;
        }
    }

    public static class RoundRobin
    extends BaseRibbonBandResizeSequencingPolicy {
        int nextIndex;

        public RoundRobin(RibbonTask ribbonTask) {
            super(ribbonTask);
        }

        public void reset() {
            this.nextIndex = this.ribbonTask.getBandCount() - 1;
        }

        public AbstractRibbonBand next() {
            AbstractRibbonBand<?> result = this.ribbonTask.getBand(this.nextIndex);
            --this.nextIndex;
            if (this.nextIndex < 0) {
                this.nextIndex = this.ribbonTask.getBandCount() - 1;
            }
            return result;
        }
    }
}

