/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.slider;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.jvnet.flamingo.slider.FlexiRangeModel;

public class DefaultFlexiRangeModel
implements FlexiRangeModel {
    protected EventListenerList listenerList = new EventListenerList();
    private boolean isAdjusting = false;
    private FlexiRangeModel.Value value = null;
    private FlexiRangeModel.Range[] ranges;

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    public void setRanges(FlexiRangeModel.Range ... ranges) {
        this.ranges = new FlexiRangeModel.Range[ranges.length];
        for (int i = 0; i < ranges.length; ++i) {
            this.ranges[i] = ranges[i];
        }
    }

    public int getRangeCount() {
        return this.ranges.length;
    }

    public FlexiRangeModel.Range getRange(int rangeIndex) {
        return this.ranges[rangeIndex];
    }

    protected boolean isValueLegal(FlexiRangeModel.Value value) {
        boolean isRangeLegal = false;
        for (FlexiRangeModel.Range range : this.ranges) {
            if (!range.equals(value.range)) continue;
            isRangeLegal = true;
        }
        if (!isRangeLegal) {
            return false;
        }
        if (value.rangeFraction < 0.0 || value.rangeFraction > 1.0) {
            return false;
        }
        return !value.range.isDiscrete() || value.rangeFraction == 0.0 || value.rangeFraction == 1.0;
    }

    public FlexiRangeModel.Value getValue() {
        if (this.value == null) {
            return null;
        }
        return new FlexiRangeModel.Value(this.value);
    }

    public void setValue(FlexiRangeModel.Value value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Can't pass null value");
        }
        if (!value.equals(this.value)) {
            if (!this.isValueLegal(value)) {
                throw new IllegalArgumentException("Value is not legal for the model");
            }
            this.value = new FlexiRangeModel.Value(value);
            this.fireStateChanged();
        }
    }

    public void setValueIsAdjusting(boolean b) {
        if (this.isAdjusting != b) {
            this.isAdjusting = b;
            this.fireStateChanged();
        }
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }
}

