/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jvnet.flamingo.common.AbstractCommandButton;
import org.jvnet.flamingo.common.CommandButtonDisplayState;
import org.jvnet.flamingo.common.JCommandButton;
import org.jvnet.flamingo.common.JCommandMenuButton;
import org.jvnet.flamingo.common.icon.EmptyResizableIcon;
import org.jvnet.flamingo.common.icon.FilteredResizableIcon;
import org.jvnet.flamingo.common.popup.JCommandPopupMenu;
import org.jvnet.flamingo.common.popup.JPopupPanel;
import org.jvnet.flamingo.common.popup.PopupPanelCallback;
import test.common.QuickStylesPanel;
import test.svg.transcoded.edit_copy;
import test.svg.transcoded.edit_cut;
import test.svg.transcoded.edit_paste;

public class TestCommandButtons
extends JFrame {
    private boolean toUseSimplePopup = true;

    public TestCommandButtons() {
        super("Command button test");
        this.setIconImage(new BufferedImage(1, 1, 2));
        this.setLayout(new BorderLayout());
        FormLayout lm = new FormLayout("right:pref, 10dlu, center:pref, 4dlu,center:pref, 4dlu, center:pref, 4dlu, center:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm);
        builder.setDefaultDialogBorder();
        builder.append("");
        builder.append("Action only");
        builder.append("Action (main) + popup");
        builder.append("Action + popup (main)");
        builder.append("Popup only");
        this.addButtons(builder, CommandButtonDisplayState.BIG);
        this.addButtons(builder, CommandButtonDisplayState.TILE);
        this.addButtons(builder, CommandButtonDisplayState.MEDIUM);
        this.addButtons(builder, CommandButtonDisplayState.SMALL);
        JPanel buttonsPanel = builder.getPanel();
        this.add((Component)buttonsPanel, "Center");
        JPanel controlPanel = new JPanel(new FlowLayout(1));
        this.configureControlPanel(controlPanel);
        this.add((Component)controlPanel, "South");
    }

    private static String stamp() {
        return new SimpleDateFormat("HH:mm:ss.SSS").format(new Date());
    }

    private void addButtons(DefaultFormBuilder builder, CommandButtonDisplayState state) {
        builder.append(state.getDisplayName() + " state");
        JCommandButton mainButton = new JCommandButton("Paste", new edit_paste());
        mainButton.setDisabledIcon(new FilteredResizableIcon(new edit_paste(), new ColorConvertOp(ColorSpace.getInstance(1003), null)));
        mainButton.setExtraText("Extra for paste");
        mainButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println(TestCommandButtons.stamp() + ": Main paste");
            }
        });
        mainButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
        mainButton.setDisplayState(state);
        mainButton.setFlat(false);
        builder.append(mainButton);
        JCommandButton cutButton = new JCommandButton("Cut", new edit_cut());
        cutButton.setExtraText("Extra for cut");
        cutButton.setPopupCallback(new TestPopupCallback());
        cutButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
        cutButton.setDisplayState(state);
        cutButton.setFlat(false);
        cutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println(TestCommandButtons.stamp() + ": Cut");
            }
        });
        builder.append(cutButton);
        JCommandButton copyButton = new JCommandButton("Copy", new edit_copy());
        copyButton.setExtraText("Extra for copy");
        copyButton.setPopupCallback(new TestPopupCallback());
        copyButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
        copyButton.setDisplayState(state);
        copyButton.setFlat(false);
        copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println(TestCommandButtons.stamp() + ": Copy");
            }
        });
        builder.append(copyButton);
        JCommandButton popupButton = new JCommandButton("Select all", new edit_paste());
        popupButton.setExtraText("Extra for select all");
        popupButton.setPopupCallback(new TestPopupCallback());
        popupButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        popupButton.setDisplayState(state);
        popupButton.setFlat(false);
        builder.append(popupButton);
    }

    protected void configureControlPanel(JPanel controlPanel) {
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        final JComboBox<UIManager.LookAndFeelInfo> jcb = new JComboBox<UIManager.LookAndFeelInfo>(lafs);
        jcb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TestCommandButtons frame = TestCommandButtons.this;
                        boolean wasDecoratedByOS = !frame.isUndecorated();
                        try {
                            UIManager.LookAndFeelInfo selected = (UIManager.LookAndFeelInfo)jcb.getSelectedItem();
                            UIManager.setLookAndFeel(selected.getClassName());
                            SwingUtilities.updateComponentTreeUI(frame);
                        }
                        catch (Exception exc) {
                            // empty catch block
                        }
                        boolean canBeDecoratedByLAF = UIManager.getLookAndFeel().getSupportsWindowDecorations();
                        if (canBeDecoratedByLAF == wasDecoratedByOS) {
                            boolean wasVisible = frame.isVisible();
                            frame.setVisible(false);
                            frame.dispose();
                            if (!canBeDecoratedByLAF) {
                                frame.setUndecorated(false);
                                frame.getRootPane().setWindowDecorationStyle(0);
                            } else {
                                frame.setUndecorated(true);
                                frame.getRootPane().setWindowDecorationStyle(1);
                            }
                            frame.setVisible(wasVisible);
                            wasDecoratedByOS = !frame.isUndecorated();
                        }
                    }
                });
            }
        });
        jcb.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, ((UIManager.LookAndFeelInfo)value).getName(), index, isSelected, cellHasFocus);
            }
        });
        controlPanel.add(jcb);
        final JCheckBox enabled = new JCheckBox("enabled");
        enabled.setSelected(true);
        enabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        this.scan(TestCommandButtons.this);
                        TestCommandButtons.this.repaint();
                    }

                    private void scan(Container c) {
                        for (int i = 0; i < c.getComponentCount(); ++i) {
                            Component child = c.getComponent(i);
                            if (child instanceof AbstractCommandButton) {
                                child.setEnabled(enabled.isSelected());
                            }
                            if (!(child instanceof Container)) continue;
                            this.scan((Container)child);
                        }
                    }
                });
            }
        });
        controlPanel.add(enabled);
        final JCheckBox actionEnabled = new JCheckBox("action enabled");
        actionEnabled.setSelected(true);
        actionEnabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        this.scan(TestCommandButtons.this);
                        TestCommandButtons.this.repaint();
                    }

                    private void scan(Container c) {
                        for (int i = 0; i < c.getComponentCount(); ++i) {
                            Component child = c.getComponent(i);
                            if (child instanceof AbstractCommandButton) {
                                ((AbstractCommandButton)child).getActionModel().setEnabled(actionEnabled.isSelected());
                            }
                            if (!(child instanceof Container)) continue;
                            this.scan((Container)child);
                        }
                    }
                });
            }
        });
        controlPanel.add(actionEnabled);
        final JCheckBox popupEnabled = new JCheckBox("popup enabled");
        popupEnabled.setSelected(true);
        popupEnabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        this.scan(TestCommandButtons.this);
                        TestCommandButtons.this.repaint();
                    }

                    private void scan(Container c) {
                        for (int i = 0; i < c.getComponentCount(); ++i) {
                            Component child = c.getComponent(i);
                            if (child instanceof JCommandButton) {
                                ((JCommandButton)child).getPopupModel().setEnabled(popupEnabled.isSelected());
                            }
                            if (!(child instanceof Container)) continue;
                            this.scan((Container)child);
                        }
                    }
                });
            }
        });
        controlPanel.add(popupEnabled);
        final JCheckBox flat = new JCheckBox("flat");
        flat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        this.scan(TestCommandButtons.this);
                        TestCommandButtons.this.repaint();
                    }

                    private void scan(Container c) {
                        for (int i = 0; i < c.getComponentCount(); ++i) {
                            Component child = c.getComponent(i);
                            if (child instanceof AbstractCommandButton) {
                                ((AbstractCommandButton)child).setFlat(flat.isSelected());
                            }
                            if (!(child instanceof Container)) continue;
                            this.scan((Container)child);
                        }
                    }
                });
            }
        });
        controlPanel.add(flat);
        final JCheckBox downward = new JCheckBox("downward");
        downward.setSelected(true);
        downward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        this.scan(TestCommandButtons.this);
                        TestCommandButtons.this.repaint();
                    }

                    private void scan(Container c) {
                        for (int i = 0; i < c.getComponentCount(); ++i) {
                            Component child = c.getComponent(i);
                            if (child instanceof JCommandButton) {
                                ((JCommandButton)child).setPopupOrientationKind(downward.isSelected() ? JCommandButton.CommandButtonPopupOrientationKind.DOWNWARD : JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD);
                            }
                            if (!(child instanceof Container)) continue;
                            this.scan((Container)child);
                        }
                    }
                });
            }
        });
        controlPanel.add(downward);
        final JCheckBox simplePopupCheckbox = new JCheckBox("simple popup");
        simplePopupCheckbox.setSelected(true);
        simplePopupCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestCommandButtons.this.toUseSimplePopup = simplePopupCheckbox.isSelected();
            }
        });
        controlPanel.add(simplePopupCheckbox);
    }

    public static void main(String[] args) {
        UIManager.installLookAndFeel("JGoodies Plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
        UIManager.installLookAndFeel("JGoodies PlasticXP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        UIManager.installLookAndFeel("JGoodies Plastic3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        UIManager.installLookAndFeel("JGoodies Windows", "com.jgoodies.looks.windows.WindowsLookAndFeel");
        UIManager.installLookAndFeel("Synthetica base", "de.javasoft.plaf.synthetica.SyntheticaStandardLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlackMoon", "de.javasoft.plaf.synthetica.SyntheticaBlackMoonLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlackStar", "de.javasoft.plaf.synthetica.SyntheticaBlackStarLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlueIce", "de.javasoft.plaf.synthetica.SyntheticaBlueIceLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlueMoon", "de.javasoft.plaf.synthetica.SyntheticaBlueMoonLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlueSteel", "de.javasoft.plaf.synthetica.SyntheticaBlueSteelLookAndFeel");
        UIManager.installLookAndFeel("Synthetica GreenDream", "de.javasoft.plaf.synthetica.SyntheticaGreenDreamLookAndFeel");
        UIManager.installLookAndFeel("Synthetica MauveMetallic", "de.javasoft.plaf.synthetica.SyntheticaMauveMetallicLookAndFeel");
        UIManager.installLookAndFeel("Synthetica OrangeMetallic", "de.javasoft.plaf.synthetica.SyntheticaOrangeMetallicLookAndFeel");
        UIManager.installLookAndFeel("Synthetica SkyMetallic", "de.javasoft.plaf.synthetica.SyntheticaSkyMetallicLookAndFeel");
        UIManager.installLookAndFeel("Synthetica SilverMoon", "de.javasoft.plaf.synthetica.SyntheticaSilverMoonLookAndFeel");
        UIManager.installLookAndFeel("Synthetica WhiteVision", "de.javasoft.plaf.synthetica.SyntheticaWhiteVisionLookAndFeel");
        UIManager.installLookAndFeel("A03", "a03.swing.plaf.A03LookAndFeel");
        UIManager.installLookAndFeel("Liquid", "com.birosoft.liquid.LiquidLookAndFeel");
        UIManager.installLookAndFeel("Napkin", "net.sourceforge.napkinlaf.NapkinLookAndFeel");
        UIManager.installLookAndFeel("Pagosoft", "com.pagosoft.plaf.PgsLookAndFeel");
        UIManager.installLookAndFeel("Squareness", "net.beeger.squareness.SquarenessLookAndFeel");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestCommandButtons frame = new TestCommandButtons();
                frame.setSize(800, 400);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                frame.setDefaultCloseOperation(2);
            }
        });
    }

    private class TestPopupCallback
    implements PopupPanelCallback {
        private TestPopupCallback() {
        }

        public JPopupPanel getPopupPanel(JCommandButton commandButton) {
            if (TestCommandButtons.this.toUseSimplePopup) {
                JCommandPopupMenu popupMenu = new JCommandPopupMenu();
                popupMenu.addMenuButton(new JCommandMenuButton("Test menu item 1", new EmptyResizableIcon(16)));
                popupMenu.addMenuButton(new JCommandMenuButton("Test menu item 2", new EmptyResizableIcon(16)));
                popupMenu.addMenuButton(new JCommandMenuButton("Test menu item 3", new EmptyResizableIcon(16)));
                popupMenu.addMenuSeparator();
                popupMenu.addMenuButton(new JCommandMenuButton("Test menu item 4", new EmptyResizableIcon(16)));
                popupMenu.addMenuButton(new JCommandMenuButton("Test menu item 5", new EmptyResizableIcon(16)));
                return popupMenu;
            }
            JCommandPopupMenu popupMenu = new JCommandPopupMenu(new QuickStylesPanel(), 5, 3);
            popupMenu.addMenuButton(new JCommandMenuButton("Save Selection", new EmptyResizableIcon(16)));
            popupMenu.addMenuButton(new JCommandMenuButton("Clear Selection", new EmptyResizableIcon(16)));
            popupMenu.addMenuSeparator();
            popupMenu.addMenuButton(new JCommandMenuButton("Apply Styles", new EmptyResizableIcon(16)));
            return popupMenu;
        }
    }
}

